/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.rhino.type;

import dev.latvian.mods.rhino.type.RecordTypeInfo;
import dev.latvian.mods.rhino.type.TypeInfo;
import dev.latvian.mods.rhino.type.TypeInfoBase;
import dev.latvian.mods.rhino.type.TypeStringContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class ParameterizedTypeInfo
extends TypeInfoBase {
    private final TypeInfo rawType;
    private final TypeInfo[] params;
    private int hashCode;

    ParameterizedTypeInfo(TypeInfo rawType, TypeInfo[] params) {
        this.rawType = rawType;
        this.params = params;
    }

    @Override
    public Class<?> asClass() {
        return this.rawType.asClass();
    }

    @Override
    public boolean is(TypeInfo info) {
        return this.rawType.is(info);
    }

    @Override
    public TypeInfo param(int index) {
        return index >= 0 && index < this.params.length && this.params[index] != TypeInfo.OBJECT ? this.params[index] : TypeInfo.NONE;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(this.rawType, Arrays.hashCode(this.params));
            if (this.hashCode == 0) {
                this.hashCode = 1;
            }
        }
        return this.hashCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (this == object) return true;
        if (!(object instanceof ParameterizedTypeInfo)) return false;
        ParameterizedTypeInfo that = (ParameterizedTypeInfo)object;
        if (this.params.length != that.params.length) return false;
        if (!this.rawType.equals(that.rawType)) return false;
        if (!Arrays.deepEquals(this.params, that.params)) return false;
        return true;
    }

    public String toString() {
        return TypeStringContext.DEFAULT.toString(this);
    }

    @Override
    public void append(TypeStringContext ctx, StringBuilder sb) {
        ctx.append(sb, this.rawType);
        sb.append('<');
        for (int i = 0; i < this.params.length; ++i) {
            if (i > 0) {
                sb.append(',');
                ctx.appendSpace(sb);
            }
            ctx.append(sb, this.params[i]);
        }
        sb.append('>');
    }

    @Override
    public String signature() {
        return this.rawType.signature();
    }

    public TypeInfo rawType() {
        return this.rawType;
    }

    public TypeInfo[] params() {
        return this.params;
    }

    @Override
    public Object newArray(int length) {
        return this.rawType.newArray(length);
    }

    @Override
    public TypeInfo withParams(TypeInfo ... params) {
        return this.rawType.withParams(params);
    }

    @Override
    public boolean isFunctionalInterface() {
        return this.rawType.isFunctionalInterface();
    }

    @Override
    public Map<String, RecordTypeInfo.Component> recordComponents() {
        return this.rawType.recordComponents();
    }

    @Override
    public List<Object> enumConstants() {
        return this.rawType.enumConstants();
    }

    @Override
    public void collectContainedComponentClasses(Collection<Class<?>> classes) {
        this.rawType.collectContainedComponentClasses(classes);
        for (TypeInfo param : this.params) {
            param.collectContainedComponentClasses(classes);
        }
    }
}

