/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.schema.minecraft;

import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.error.KubeRuntimeException;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.RecipeKey;
import dev.latvian.mods.kubejs.recipe.RecipeTypeFunction;
import dev.latvian.mods.kubejs.recipe.schema.KubeRecipeFactory;
import dev.latvian.mods.kubejs.util.TinyMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.world.item.crafting.Ingredient;

public class ShapedKubeRecipe
extends KubeRecipe {
    public static final KubeRecipeFactory RECIPE_FACTORY = new KubeRecipeFactory(KubeJS.id("shaped"), ShapedKubeRecipe.class, ShapedKubeRecipe::new);

    @Override
    public void afterLoaded() {
        RecipeKey patternKey = this.type.schemaType.schema.getKey("pattern");
        RecipeKey keyKey = this.type.schemaType.schema.getKey("key");
        super.afterLoaded();
        ArrayList<String> pattern = new ArrayList<String>((Collection)this.getValue(patternKey));
        TinyMap key = (TinyMap)this.getValue(keyKey);
        if (pattern.isEmpty()) {
            throw new KubeRuntimeException("Pattern is empty!");
        }
        if (key.isEmpty()) {
            throw new KubeRuntimeException("Key map is empty!");
        }
        ArrayList<Character> airs = null;
        ArrayList entries = new ArrayList(Arrays.asList(key.entries()));
        Iterator itr = entries.iterator();
        while (itr.hasNext()) {
            TinyMap.Entry entry = itr.next();
            if (entry.value() != null && !((Ingredient)entry.value()).isEmpty()) continue;
            if (airs == null) {
                airs = new ArrayList<Character>(1);
            }
            airs.add((Character)entry.key());
            itr.remove();
        }
        if (airs != null) {
            for (int i = 0; i < pattern.size(); ++i) {
                for (Character a : airs) {
                    pattern.set(i, ((String)pattern.get(i)).replace(a.charValue(), ' '));
                }
            }
            this.setValue(patternKey, pattern);
            this.setValue(keyKey, new TinyMap(entries));
        }
    }

    @Override
    public RecipeTypeFunction getSerializationTypeFunction() {
        if (!(this.type != this.type.event.shaped || this.type.event.shaped == this.type.event.vanillaShaped || this.json.has("kubejs:ingredient_actions") || this.json.has("kubejs:modify_result") || this.json.has("kubejs:stage") || this.json.has("kubejs:mirror"))) {
            return this.type.event.vanillaShaped;
        }
        return super.getSerializationTypeFunction();
    }
}

