/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.net;

import dev.latvian.mods.kubejs.bindings.event.ItemEvents;
import dev.latvian.mods.kubejs.item.ItemClickedKubeEvent;
import dev.latvian.mods.kubejs.net.KubeJSNet;
import dev.latvian.mods.kubejs.script.ScriptType;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record FirstClickPayload(int clickType) implements CustomPacketPayload
{
    public static final StreamCodec<ByteBuf, FirstClickPayload> STREAM_CODEC = ByteBufCodecs.VAR_INT.map(FirstClickPayload::new, FirstClickPayload::clickType);

    public CustomPacketPayload.Type<?> type() {
        return KubeJSNet.FIRST_CLICK;
    }

    public void handle(IPayloadContext ctx) {
        Player player = ctx.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.clickType == 0 && ItemEvents.FIRST_LEFT_CLICKED.hasListeners()) {
                ctx.enqueueWork(() -> {
                    ItemStack stack = serverPlayer.getItemInHand(InteractionHand.MAIN_HAND);
                    ResourceKey key = stack.getItem().kjs$getKey();
                    if (ItemEvents.FIRST_LEFT_CLICKED.hasListeners((ResourceKey<Item>)key)) {
                        ItemEvents.FIRST_LEFT_CLICKED.post(ScriptType.SERVER, (ResourceKey<Item>)key, new ItemClickedKubeEvent((Player)serverPlayer, InteractionHand.MAIN_HAND, stack));
                    }
                });
            } else if (this.clickType == 1 && ItemEvents.FIRST_RIGHT_CLICKED.hasListeners()) {
                ctx.enqueueWork(() -> {
                    for (InteractionHand hand : InteractionHand.values()) {
                        ItemStack stack = serverPlayer.getItemInHand(hand);
                        ResourceKey key = stack.getItem().kjs$getKey();
                        if (!ItemEvents.FIRST_RIGHT_CLICKED.hasListeners((ResourceKey<Item>)key)) continue;
                        ItemEvents.FIRST_RIGHT_CLICKED.post(ScriptType.SERVER, (ResourceKey<Item>)key, new ItemClickedKubeEvent((Player)serverPlayer, hand, stack));
                    }
                });
            }
        }
    }
}

