/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.item;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.mods.kubejs.component.DataComponentWrapper;
import dev.latvian.mods.kubejs.ingredient.RegExIngredient;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.Lazy;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.kubejs.util.RegExpKJS;
import dev.latvian.mods.kubejs.util.RegistryAccessContainer;
import dev.latvian.mods.kubejs.util.UtilsJS;
import dev.latvian.mods.rhino.Wrapper;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public interface ItemStackJS {
    public static final ItemStack[] EMPTY_ARRAY = new ItemStack[0];
    public static final TypeInfo ITEM_TYPE_INFO = TypeInfo.of(Item.class);
    public static final TypeInfo TYPE_INFO = TypeInfo.of(ItemStack.class);
    public static final Lazy<List<String>> CACHED_ITEM_TYPE_LIST = Lazy.of(() -> {
        ArrayList<String> cachedItemTypeList = new ArrayList<String>();
        for (Item item : BuiltInRegistries.ITEM) {
            cachedItemTypeList.add(item.kjs$getId());
        }
        return cachedItemTypeList;
    });
    public static final Lazy<Map<ResourceLocation, Collection<ItemStack>>> CACHED_ITEM_MAP = Lazy.of(() -> {
        HashMap<ResourceLocation, Collection> map = new HashMap<ResourceLocation, Collection>();
        Set stackList = ItemStackLinkedSet.createTypeAndComponentsSet();
        stackList.addAll(CreativeModeTabs.searchTab().getDisplayItems());
        for (ItemStack stack : stackList) {
            if (stack.isEmpty()) continue;
            map.computeIfAbsent(stack.getItem().kjs$getIdLocation(), _rl -> ItemStackLinkedSet.createTypeAndComponentsSet()).add(stack.kjs$withCount(1));
        }
        for (String itemId : CACHED_ITEM_TYPE_LIST.get()) {
            ResourceLocation itemRl = ResourceLocation.parse((String)itemId);
            map.computeIfAbsent(itemRl, id -> Set.of(((Item)BuiltInRegistries.ITEM.get(id)).getDefaultInstance()));
        }
        return map;
    });
    public static final Lazy<List<ItemStack>> CACHED_ITEM_LIST = Lazy.of(() -> CACHED_ITEM_MAP.get().values().stream().flatMap(Collection::stream).toList());

    public static ItemStack wrap(RegistryAccessContainer registries, @Nullable Object o) {
        if (o instanceof Wrapper) {
            Wrapper w = (Wrapper)o;
            o = w.unwrap();
        }
        if (o == null || o == ItemStack.EMPTY || o == Items.AIR) {
            return ItemStack.EMPTY;
        }
        if (o instanceof ItemStack) {
            ItemStack stack = (ItemStack)o;
            return stack.isEmpty() ? ItemStack.EMPTY : stack;
        }
        if (o instanceof Ingredient) {
            Ingredient ingr = (Ingredient)o;
            return ingr.kjs$getFirst();
        }
        if (o instanceof ResourceLocation) {
            ResourceLocation id = (ResourceLocation)o;
            Item item = (Item)BuiltInRegistries.ITEM.get(id);
            if (item == null || item == Items.AIR) {
                return ItemStack.EMPTY;
            }
            return item.getDefaultInstance();
        }
        if (o instanceof ItemLike) {
            ItemLike itemLike = (ItemLike)o;
            return itemLike.asItem().getDefaultInstance();
        }
        if (o instanceof JsonElement) {
            JsonElement json = (JsonElement)o;
            return ItemStackJS.resultFromRecipeJson(registries.nbt(), json);
        }
        if (o instanceof StringTag) {
            StringTag tag = (StringTag)o;
            return ItemStackJS.wrap(registries, tag.getAsString());
        }
        if (o instanceof Pattern || o instanceof NativeRegExp) {
            Pattern reg = RegExpKJS.wrap(o);
            if (reg != null) {
                return new RegExIngredient(reg).toVanilla().kjs$getFirst();
            }
            return ItemStack.EMPTY;
        }
        if (o instanceof CharSequence) {
            String os;
            String s = os = o.toString().trim();
            ItemStack cached = registries.itemStackParseCache().get(os);
            if (cached != null) {
                return cached.copy();
            }
            int count = 1;
            int spaceIndex = s.indexOf(32);
            if (spaceIndex >= 2 && s.indexOf(120) == spaceIndex - 1) {
                count = Integer.parseInt(s.substring(0, spaceIndex - 1));
                s = s.substring(spaceIndex + 1);
            }
            cached = ItemStackJS.ofString(registries.nbt(), s);
            cached.setCount(count);
            registries.itemStackParseCache().put(os, cached);
            return cached.copy();
        }
        Map<?, ?> map = MapJS.of(o);
        if (map != null) {
            if (map.containsKey("item")) {
                ResourceLocation id = ID.mc(map.get("item").toString());
                Item item = (Item)BuiltInRegistries.ITEM.get(id);
                if (item == null || item == Items.AIR) {
                    return ItemStack.EMPTY;
                }
                ItemStack stack = new ItemStack((ItemLike)item);
                Object obj = map.get("count");
                if (obj instanceof Number) {
                    Number number = (Number)obj;
                    stack.setCount(number.intValue());
                }
                return stack;
            }
            if (map.containsKey("tag")) {
                ItemStack stack = Ingredient.of((TagKey)ItemTags.create((ResourceLocation)ID.mc(map.get("tag")))).kjs$getFirst();
                if (map.containsKey("count")) {
                    stack.setCount(UtilsJS.parseInt(map.get("count"), 1));
                }
                return stack;
            }
        }
        return ItemStack.EMPTY;
    }

    public static Item getRawItem(RegistryAccessContainer registries, @Nullable Object o) {
        if (o == null) {
            return Items.AIR;
        }
        if (o instanceof ItemLike) {
            ItemLike item = (ItemLike)o;
            return item.asItem();
        }
        if (o instanceof CharSequence) {
            String s = o.toString();
            if (s.isEmpty()) {
                return Items.AIR;
            }
            if (s.charAt(0) != '#') {
                return (Item)BuiltInRegistries.ITEM.get(ID.mc(s));
            }
        }
        return ItemStackJS.wrap(registries, o).getItem();
    }

    public static ItemStack resultFromRecipeJson(DynamicOps<Tag> registryOps, @Nullable JsonElement json) {
        if (json == null || json.isJsonNull()) {
            return ItemStack.EMPTY;
        }
        if (json.isJsonPrimitive()) {
            return ItemStackJS.ofString(registryOps, json.getAsString());
        }
        if (json instanceof JsonObject) {
            return (ItemStack)((Pair)ItemStack.OPTIONAL_CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow()).getFirst();
        }
        return ItemStack.EMPTY;
    }

    public static List<ItemStack> getList() {
        return CACHED_ITEM_LIST.get();
    }

    public static List<String> getTypeList() {
        return CACHED_ITEM_TYPE_LIST.get();
    }

    public static Map<ResourceLocation, Collection<ItemStack>> getTypeToStacks() {
        return CACHED_ITEM_MAP.get();
    }

    public static boolean isItemStackLike(Object from) {
        return from instanceof ItemStack;
    }

    public static ItemStack ofString(DynamicOps<Tag> registryOps, String s) {
        if (s.isEmpty() || s.equals("-") || s.equals("air") || s.equals("minecraft:air")) {
            return ItemStack.EMPTY;
        }
        try {
            StringReader reader = new StringReader(s);
            reader.skipWhitespace();
            if (!reader.canRead()) {
                return ItemStack.EMPTY;
            }
            return ItemStackJS.read(registryOps, new StringReader(s));
        }
        catch (CommandSyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static ItemStack read(DynamicOps<Tag> registryOps, StringReader reader) throws CommandSyntaxException {
        char next;
        if (!reader.canRead()) {
            return ItemStack.EMPTY;
        }
        if (reader.peek() == '-') {
            return ItemStack.EMPTY;
        }
        int count = 1;
        if (reader.canRead() && StringReader.isAllowedNumber((char)reader.peek())) {
            count = Mth.ceil((double)reader.readDouble());
            reader.skipWhitespace();
            reader.expect('x');
            reader.skipWhitespace();
            if (count < 1) {
                throw new IllegalArgumentException("Item count smaller than 1 is not allowed!");
            }
        }
        ResourceLocation itemId = ResourceLocation.read((StringReader)reader);
        ItemStack itemStack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(itemId), count);
        char c = next = reader.canRead() ? reader.peek() : (char)'\u0000';
        if (next == '[' || next == '{') {
            itemStack.applyComponents(DataComponentWrapper.readPatch(registryOps, reader));
        }
        return itemStack;
    }
}

