/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block;

import dev.latvian.mods.rhino.Undefined;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record MapColorHelper(int id, String name, MapColor color, Vector3f rgb) implements Function<BlockState, MapColor>
{
    public static final Map<String, MapColorHelper> NAME_MAP = new HashMap<String, MapColorHelper>(64);
    public static final Map<Integer, MapColorHelper> ID_MAP = new HashMap<Integer, MapColorHelper>(64);
    public static final MapColorHelper NONE = MapColorHelper.add("none", MapColor.NONE);

    private static MapColorHelper add(String id, MapColor color) {
        float r = (float)(color.col >> 16 & 0xFF) / 255.0f;
        float g = (float)(color.col >> 8 & 0xFF) / 255.0f;
        float b = (float)(color.col & 0xFF) / 255.0f;
        MapColorHelper helper = new MapColorHelper(color.id, id, color, new Vector3f(r, g, b));
        NAME_MAP.put(id, helper);
        ID_MAP.put(color.id, helper);
        return helper;
    }

    public static MapColor of(Object o) {
        if (o == null || Undefined.isUndefined((Object)o)) {
            return MapColor.NONE;
        }
        if (o instanceof MapColor) {
            MapColor c = (MapColor)o;
            return c;
        }
        if (o instanceof CharSequence) {
            CharSequence s = (CharSequence)o;
            if (s.isEmpty()) {
                return MapColor.NONE;
            }
            if (s.charAt(0) == '#') {
                return MapColorHelper.findClosest((int)Integer.decode((String)s.toString()).intValue()).color;
            }
            return MapColorHelper.NAME_MAP.getOrDefault((Object)s.toString().toLowerCase(), (MapColorHelper)MapColorHelper.NONE).color;
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            return MapColorHelper.findClosest((int)n.intValue()).color;
        }
        if (o instanceof DyeColor) {
            DyeColor c = (DyeColor)o;
            return c.getMapColor();
        }
        return MapColor.NONE;
    }

    public static MapColorHelper reverse(MapColor c) {
        return ID_MAP.getOrDefault(c.id, NONE);
    }

    public static MapColorHelper findClosest(int rgbi) {
        Vector3f rgb = new Vector3f((float)(rgbi >> 16 & 0xFF) / 255.0f, (float)(rgbi >> 8 & 0xFF) / 255.0f, (float)(rgbi & 0xFF) / 255.0f);
        MapColorHelper closest = null;
        float lastDist = Float.MAX_VALUE;
        for (MapColorHelper helper : NAME_MAP.values()) {
            float dist;
            if (helper.color == MapColor.NONE || !((dist = helper.rgb.distanceSquared((Vector3fc)rgb)) < lastDist)) continue;
            closest = helper;
            lastDist = dist;
        }
        return closest == null ? NONE : closest;
    }

    @Override
    public MapColor apply(BlockState blockState) {
        return this.color;
    }

    static {
        MapColorHelper.add("grass", MapColor.GRASS);
        MapColorHelper.add("sand", MapColor.SAND);
        MapColorHelper.add("wool", MapColor.WOOL);
        MapColorHelper.add("fire", MapColor.FIRE);
        MapColorHelper.add("ice", MapColor.ICE);
        MapColorHelper.add("metal", MapColor.METAL);
        MapColorHelper.add("plant", MapColor.PLANT);
        MapColorHelper.add("snow", MapColor.SNOW);
        MapColorHelper.add("clay", MapColor.CLAY);
        MapColorHelper.add("dirt", MapColor.DIRT);
        MapColorHelper.add("stone", MapColor.STONE);
        MapColorHelper.add("water", MapColor.WATER);
        MapColorHelper.add("wood", MapColor.WOOD);
        MapColorHelper.add("quartz", MapColor.QUARTZ);
        MapColorHelper.add("color_orange", MapColor.COLOR_ORANGE);
        MapColorHelper.add("color_magenta", MapColor.COLOR_MAGENTA);
        MapColorHelper.add("color_light_blue", MapColor.COLOR_LIGHT_BLUE);
        MapColorHelper.add("color_yellow", MapColor.COLOR_YELLOW);
        MapColorHelper.add("color_light_green", MapColor.COLOR_LIGHT_GREEN);
        MapColorHelper.add("color_pink", MapColor.COLOR_PINK);
        MapColorHelper.add("color_gray", MapColor.COLOR_GRAY);
        MapColorHelper.add("color_light_gray", MapColor.COLOR_LIGHT_GRAY);
        MapColorHelper.add("color_cyan", MapColor.COLOR_CYAN);
        MapColorHelper.add("color_purple", MapColor.COLOR_PURPLE);
        MapColorHelper.add("color_blue", MapColor.COLOR_BLUE);
        MapColorHelper.add("color_brown", MapColor.COLOR_BROWN);
        MapColorHelper.add("color_green", MapColor.COLOR_GREEN);
        MapColorHelper.add("color_red", MapColor.COLOR_RED);
        MapColorHelper.add("color_black", MapColor.COLOR_BLACK);
        MapColorHelper.add("gold", MapColor.GOLD);
        MapColorHelper.add("diamond", MapColor.DIAMOND);
        MapColorHelper.add("lapis", MapColor.LAPIS);
        MapColorHelper.add("emerald", MapColor.EMERALD);
        MapColorHelper.add("podzol", MapColor.PODZOL);
        MapColorHelper.add("nether", MapColor.NETHER);
        MapColorHelper.add("terracotta_white", MapColor.TERRACOTTA_WHITE);
        MapColorHelper.add("terracotta_orange", MapColor.TERRACOTTA_ORANGE);
        MapColorHelper.add("terracotta_magenta", MapColor.TERRACOTTA_MAGENTA);
        MapColorHelper.add("terracotta_light_blue", MapColor.TERRACOTTA_LIGHT_BLUE);
        MapColorHelper.add("terracotta_yellow", MapColor.TERRACOTTA_YELLOW);
        MapColorHelper.add("terracotta_light_green", MapColor.TERRACOTTA_LIGHT_GREEN);
        MapColorHelper.add("terracotta_pink", MapColor.TERRACOTTA_PINK);
        MapColorHelper.add("terracotta_gray", MapColor.TERRACOTTA_GRAY);
        MapColorHelper.add("terracotta_light_gray", MapColor.TERRACOTTA_LIGHT_GRAY);
        MapColorHelper.add("terracotta_cyan", MapColor.TERRACOTTA_CYAN);
        MapColorHelper.add("terracotta_purple", MapColor.TERRACOTTA_PURPLE);
        MapColorHelper.add("terracotta_blue", MapColor.TERRACOTTA_BLUE);
        MapColorHelper.add("terracotta_brown", MapColor.TERRACOTTA_BROWN);
        MapColorHelper.add("terracotta_green", MapColor.TERRACOTTA_GREEN);
        MapColorHelper.add("terracotta_red", MapColor.TERRACOTTA_RED);
        MapColorHelper.add("terracotta_black", MapColor.TERRACOTTA_BLACK);
        MapColorHelper.add("crimson_nylium", MapColor.CRIMSON_NYLIUM);
        MapColorHelper.add("crimson_stem", MapColor.CRIMSON_STEM);
        MapColorHelper.add("crimson_hyphae", MapColor.CRIMSON_HYPHAE);
        MapColorHelper.add("warped_nylium", MapColor.WARPED_NYLIUM);
        MapColorHelper.add("warped_stem", MapColor.WARPED_STEM);
        MapColorHelper.add("warped_hyphae", MapColor.WARPED_HYPHAE);
        MapColorHelper.add("warped_wart_block", MapColor.WARPED_WART_BLOCK);
        MapColorHelper.add("deepslate", MapColor.DEEPSLATE);
        MapColorHelper.add("raw_iron", MapColor.RAW_IRON);
        MapColorHelper.add("glow_lichen", MapColor.GLOW_LICHEN);
    }
}

