/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.jeed.Jeed;
import net.mehvahdjukaar.jeed.common.CodecUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;

public record EffectProviderRecipe(Optional<Holder<MobEffect>> effect, NonNullList<Ingredient> providers, HolderSet<MobEffect> effectProviders, HolderSet<Fluid> fluidProviders) implements Recipe<SingleRecipeInput>
{
    public String getGroup() {
        return "effect_provider";
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.providers;
    }

    public boolean matches(SingleRecipeInput recipeInput, Level level) {
        return false;
    }

    public ItemStack assemble(SingleRecipeInput recipeInput, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean isSpecial() {
        return true;
    }

    public RecipeSerializer<?> getSerializer() {
        return Jeed.getEffectProviderSerializer();
    }

    public RecipeType<?> getType() {
        return Jeed.getEffectProviderType();
    }

    public Collection<? extends Holder<MobEffect>> getEffects() {
        return this.effect.isEmpty() ? BuiltInRegistries.MOB_EFFECT.holders().toList() : Collections.singletonList(this.effect.get());
    }

    public static class Serializer
    implements RecipeSerializer<EffectProviderRecipe> {
        private static final MapCodec<EffectProviderRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.MOB_EFFECT.holderByNameCodec().optionalFieldOf("effect").forGetter(shapelessRecipe -> shapelessRecipe.effect), (App)CodecUtil.INGREDIENT_WITH_TAG.listOf().optionalFieldOf("providers", List.of()).flatXmap(list -> {
            Object[] ingredients = (Ingredient[])list.stream().filter(ingredient -> !ingredient.isEmpty()).toArray(Ingredient[]::new);
            return DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])ingredients));
        }, DataResult::success).forGetter(shapelessRecipe -> shapelessRecipe.providers), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.MOB_EFFECT).optionalFieldOf("effect_providers", (Object)HolderSet.empty()).forGetter(r -> r.effectProviders), (App)RegistryCodecs.homogeneousList((ResourceKey)Registries.FLUID).optionalFieldOf("fluid_providers", (Object)HolderSet.empty()).forGetter(r -> r.fluidProviders)).apply((Applicative)instance, EffectProviderRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, EffectProviderRecipe> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.optional((StreamCodec)ByteBufCodecs.holderRegistry((ResourceKey)Registries.MOB_EFFECT)), EffectProviderRecipe::effect, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.collection(NonNullList::createWithCapacity)), EffectProviderRecipe::providers, (StreamCodec)ByteBufCodecs.holderSet((ResourceKey)Registries.MOB_EFFECT), EffectProviderRecipe::effectProviders, (StreamCodec)ByteBufCodecs.holderSet((ResourceKey)Registries.FLUID), EffectProviderRecipe::fluidProviders, EffectProviderRecipe::new);

        public MapCodec<EffectProviderRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, EffectProviderRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

