/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.common.item;

import fonnymunkey.simplehats.SimpleHatsCommon;
import fonnymunkey.simplehats.common.entity.HatDisplay;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class HatDisplayItem
extends Item {
    public HatDisplayItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Direction direction = context.getClickedFace();
        if (direction == Direction.DOWN) {
            return InteractionResult.FAIL;
        }
        Level level = context.getLevel();
        BlockPlaceContext blockPlaceContext = new BlockPlaceContext(context);
        BlockPos pos = blockPlaceContext.getClickedPos();
        ItemStack itemStack = context.getItemInHand();
        Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)pos);
        AABB aabb = SimpleHatsCommon.MOD_REGISTRY.getHatDisplayEntity().getDimensions().makeBoundingBox(vec3.x(), vec3.y(), vec3.z());
        if (level.noCollision(null, aabb) && level.getEntities(null, aabb).isEmpty()) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Consumer consumer = EntityType.appendCustomEntityStackConfig(entity -> {}, (ServerLevel)serverLevel, (ItemStack)itemStack, (Player)context.getPlayer());
                HatDisplay hatDisplay = (HatDisplay)SimpleHatsCommon.MOD_REGISTRY.getHatDisplayEntity().create(serverLevel, consumer, pos, MobSpawnType.SPAWN_EGG, true, true);
                if (hatDisplay == null) {
                    return InteractionResult.FAIL;
                }
                float f = 0.0f;
                f = context.getPlayer() != null && context.getPlayer().isCrouching() ? (float)Mth.floor((float)((Mth.wrapDegrees((float)(context.getRotation() - 180.0f)) + 22.5f) / 45.0f)) * 45.0f : (float)((int)Mth.wrapDegrees((float)(context.getRotation() - 180.0f)));
                hatDisplay.moveTo(hatDisplay.getX(), hatDisplay.getY(), hatDisplay.getZ(), f, 0.0f);
                serverLevel.addFreshEntityWithPassengers((Entity)hatDisplay);
                level.playSound(null, hatDisplay.getX(), hatDisplay.getY(), hatDisplay.getZ(), SoundEvents.ARMOR_STAND_PLACE, SoundSource.BLOCKS, 0.75f, 0.8f);
                hatDisplay.gameEvent((Holder)GameEvent.ENTITY_PLACE, (Entity)context.getPlayer());
            }
            itemStack.shrink(1);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return InteractionResult.FAIL;
    }
}

