/*
 * Decompiled with CFR 0.152.
 */
package net.cathienova.haventrowel.item;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.cathienova.haventrowel.config.HavenConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TrowelItem
extends Item {
    public TrowelItem(Item.Properties pProperties) {
        super(pProperties);
    }

    public InteractionResult useOn(UseOnContext context) {
        if (context.getLevel().isClientSide()) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer player = (ServerPlayer)context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        ArrayList<ItemStack> blockItems = new ArrayList<ItemStack>();
        TrowelItem.getRandomBlock(player, blockItems);
        if (blockItems.isEmpty()) {
            return InteractionResult.FAIL;
        }
        ItemStack randomBlockItem = blockItems.get(new Random().nextInt(blockItems.size()));
        BlockPos pos = context.getClickedPos().relative(context.getClickedFace());
        AABB targetBlockArea = new AABB(Vec3.atCenterOf((Vec3i)pos), Vec3.atCenterOf((Vec3i)pos.offset(1, 1, 1)));
        if (!context.getLevel().getEntities(null, targetBlockArea).isEmpty() || !context.getLevel().getBlockState(pos).isAir()) {
            return InteractionResult.FAIL;
        }
        BlockPlaceContext placeContext = new BlockPlaceContext(context);
        BlockState blockState = ((BlockItem)randomBlockItem.getItem()).getBlock().getStateForPlacement(placeContext);
        if (blockState == null) {
            return InteractionResult.FAIL;
        }
        if (!context.getLevel().setBlock(pos, blockState, 3)) {
            return InteractionResult.FAIL;
        }
        context.getLevel().gameEvent((Holder)GameEvent.BLOCK_PLACE, pos, GameEvent.Context.of((Entity)player, (BlockState)blockState));
        context.getLevel().playSound((Player)player, pos, blockState.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        if (!player.isCreative()) {
            randomBlockItem.shrink(1);
        }
        return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide());
    }

    private static void getRandomBlock(ServerPlayer player, ArrayList<ItemStack> blockItems) {
        ItemStack itemStack;
        int i;
        for (i = 0; i < 9; ++i) {
            itemStack = player.getInventory().getItem(i);
            if (!(itemStack.getItem() instanceof BlockItem) || TrowelItem.isBlacklisted(((BlockItem)itemStack.getItem()).getBlock().defaultBlockState())) continue;
            blockItems.add(itemStack);
        }
        if (HavenConfig.enable_inventory_blocks) {
            for (i = 9; i < 36; ++i) {
                itemStack = player.getInventory().getItem(i);
                if (!(itemStack.getItem() instanceof BlockItem) || TrowelItem.isBlacklisted(((BlockItem)itemStack.getItem()).getBlock().defaultBlockState())) continue;
                blockItems.add(itemStack);
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltip, tooltipFlag);
        if (HavenConfig.enable_inventory_blocks) {
            tooltip.add((Component)Component.translatable((String)"item.haventrowel.trowel.tooltip.inventory").withStyle(ChatFormatting.GOLD));
        } else {
            tooltip.add((Component)Component.translatable((String)"item.haventrowel.trowel.tooltip.hotbar").withStyle(ChatFormatting.GOLD));
        }
    }

    private static boolean isBlacklisted(BlockState state) {
        String blockId = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString();
        if (HavenConfig.trowel_blacklist == null || HavenConfig.trowel_blacklist.isEmpty()) {
            return false;
        }
        for (String id : HavenConfig.trowel_blacklist) {
            if (!(id.startsWith("#") ? state.is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.parse((String)id.substring(1)))) : id.equals(blockId))) continue;
            return true;
        }
        return false;
    }
}

