/*
 * Decompiled with CFR 0.152.
 */
package net.cathienova.haventrowel.datagen;

import java.util.concurrent.CompletableFuture;
import net.cathienova.haventrowel.datagen.ModAdvancementProvider;
import net.cathienova.haventrowel.datagen.ModEngLangProvider;
import net.cathienova.haventrowel.datagen.ModItemModelProvider;
import net.cathienova.haventrowel.datagen.recipes.ModRecipeProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

public class DataGenerators {

    @EventBusSubscriber(modid="haventrowel", bus=EventBusSubscriber.Bus.MOD)
    public static class ModProvider {
        @SubscribeEvent
        public static void gatherData(GatherDataEvent event) {
            DataGenerator generator = event.getGenerator();
            PackOutput output = generator.getPackOutput();
            ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
            CompletableFuture lookupProvider = event.getLookupProvider();
            boolean includeClient = event.includeClient();
            boolean includeServer = event.includeServer();
            if (includeClient) {
                generator.addProvider(includeClient, (DataProvider)new ModEngLangProvider(output));
                generator.addProvider(includeClient, (DataProvider)new ModItemModelProvider(output, existingFileHelper));
            }
            if (includeServer) {
                generator.addProvider(includeServer, (DataProvider)new ModRecipeProvider(output, lookupProvider));
                generator.addProvider(includeServer, (DataProvider)new ModAdvancementProvider(output, lookupProvider, existingFileHelper));
            }
        }
    }
}

