/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.command.debug;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.wispforest.owo.Owo;
import io.wispforest.owo.ops.TextOps;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class HealCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"heal").executes(HealCommand::executeFullHeal)).then(Commands.argument((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(HealCommand::executeSelfHeal))).then(((RequiredArgumentBuilder)Commands.argument((String)"entity", (ArgumentType)EntityArgument.entity()).executes(HealCommand::executeTargetedFullHeal)).then(Commands.argument((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(HealCommand::executeTargetedHeal))));
    }

    private static int executeFullHeal(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        float f;
        Entity target = ((CommandSourceStack)context.getSource()).getEntityOrException();
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            f = living.getMaxHealth();
        } else {
            f = Float.MAX_VALUE;
        }
        return HealCommand.executeHeal(context, target, f);
    }

    private static int executeSelfHeal(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return HealCommand.executeHeal(context, ((CommandSourceStack)context.getSource()).getEntityOrException(), FloatArgumentType.getFloat(context, (String)"amount"));
    }

    private static int executeTargetedFullHeal(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        float f;
        Entity target = EntityArgument.getEntity(context, (String)"entity");
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            f = living.getMaxHealth();
        } else {
            f = Float.MAX_VALUE;
        }
        return HealCommand.executeHeal(context, target, f);
    }

    private static int executeTargetedHeal(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return HealCommand.executeHeal(context, EntityArgument.getEntity(context, (String)"entity"), FloatArgumentType.getFloat(context, (String)"amount"));
    }

    private static int executeHeal(CommandContext<CommandSourceStack> context, Entity entity, float amount) throws CommandSyntaxException {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            float healed = living.getHealth();
            living.heal(amount);
            float thankYouMojang = healed = living.getHealth() - healed;
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> TextOps.concat(Owo.PREFIX, (Component)TextOps.withColor("healed \u00a7" + thankYouMojang + " \u00a7hp", TextOps.color(ChatFormatting.GRAY), 12157951, TextOps.color(ChatFormatting.GRAY))), false);
        } else {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)TextOps.concat(Owo.PREFIX, Component.nullToEmpty((String)"Cannot heal non living entity")));
        }
        return (int)Math.floor(amount);
    }
}

