/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.mixins.neoforge;

import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.common.block.IAntiquable;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncAntiqueInk;
import net.mehvahdjukaar.supplementaries.neoforge.CapabilityHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net/minecraft/network/protocol/game/ClientboundLevelChunkPacketData$BlockEntityInfo"})
public abstract class ChunkHolderMixin {
    @Inject(method={"create(Lnet/minecraft/world/level/block/entity/BlockEntity;)Lnet/minecraft/network/protocol/game/ClientboundLevelChunkPacketData$BlockEntityInfo;"}, at={@At(value="HEAD")})
    private static void sendBlockEntityCaps(BlockEntity te, CallbackInfoReturnable<?> cir) {
        Level level;
        if (te != null && (level = te.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MinecraftServer server = serverLevel.getServer();
            BlockPos pos = te.getBlockPos();
            server.tell((Runnable)new TickTask(server.getTickCount(), () -> {
                IAntiquable cap = (IAntiquable)serverLevel.getCapability(CapabilityHandler.ANTIQUE_TEXT_CAP, pos, te.getBlockState(), te, null);
                if (cap != null) {
                    ServerChunkCache chunkSource = serverLevel.getChunkSource();
                    chunkSource.chunkMap.getPlayers(new ChunkPos(pos), false).forEach(p -> NetworkHelper.sendToClientPlayer((ServerPlayer)p, (CustomPacketPayload)new ClientBoundSyncAntiqueInk(pos, cap.supplementaries$isAntique())));
                }
            }));
        }
    }
}

