/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ChangeDimensionCommand {
    private static final SimpleCommandExceptionType INVALID_POSITION = new SimpleCommandExceptionType((Message)Component.translatable((String)"commands.teleport.invalidPosition"));

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandBuildContext context) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"dimension").requires(p -> p.hasPermission(2))).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"dimension", (ArgumentType)new DimensionArgument()).executes(c -> ChangeDimensionCommand.teleportToPos((CommandContext<CommandSourceStack>)c, List.of(((CommandSourceStack)c.getSource()).getEntityOrException()), DimensionArgument.getDimension((CommandContext)c, (String)"dimension"), (Coordinates)WorldCoordinates.current()))).then(Commands.argument((String)"location", (ArgumentType)Vec3Argument.vec3()).executes(c -> ChangeDimensionCommand.teleportToPos((CommandContext<CommandSourceStack>)c, List.of(((CommandSourceStack)c.getSource()).getEntityOrException()), DimensionArgument.getDimension((CommandContext)c, (String)"dimension"), Vec3Argument.getCoordinates((CommandContext)c, (String)"location"))))).then(((RequiredArgumentBuilder)Commands.argument((String)"targets", (ArgumentType)EntityArgument.entities()).executes(c -> ChangeDimensionCommand.teleportToPos((CommandContext<CommandSourceStack>)c, EntityArgument.getEntities((CommandContext)c, (String)"targets"), DimensionArgument.getDimension((CommandContext)c, (String)"dimension"), (Coordinates)WorldCoordinates.current()))).then(Commands.argument((String)"location", (ArgumentType)Vec3Argument.vec3()).executes(c -> ChangeDimensionCommand.teleportToPos((CommandContext<CommandSourceStack>)c, EntityArgument.getEntities((CommandContext)c, (String)"targets"), DimensionArgument.getDimension((CommandContext)c, (String)"dimension"), Vec3Argument.getCoordinates((CommandContext)c, (String)"location"))))));
    }

    private static int teleportToPos(CommandContext<CommandSourceStack> context, Collection<? extends Entity> targets, ServerLevel level, Coordinates position) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        Vec3 vec3 = position.getPosition(source);
        EnumSet<RelativeMovement> set = EnumSet.noneOf(RelativeMovement.class);
        if (position.isXRelative()) {
            set.add(RelativeMovement.X);
        }
        if (position.isYRelative()) {
            set.add(RelativeMovement.Y);
        }
        if (position.isZRelative()) {
            set.add(RelativeMovement.Z);
        }
        set.add(RelativeMovement.X_ROT);
        set.add(RelativeMovement.Y_ROT);
        for (Entity entity : targets) {
            ChangeDimensionCommand.performTeleport(source, entity, level, vec3.x, vec3.y, vec3.z, set);
        }
        if (targets.size() == 1) {
            source.sendSuccess(() -> Component.translatable((String)"commands.teleport.success.location.single", (Object[])new Object[]{((Entity)targets.iterator().next()).getDisplayName(), ChangeDimensionCommand.formatDouble(vec3.x), ChangeDimensionCommand.formatDouble(vec3.y), ChangeDimensionCommand.formatDouble(vec3.z)}), true);
        } else {
            source.sendSuccess(() -> Component.translatable((String)"commands.teleport.success.location.multiple", (Object[])new Object[]{targets.size(), ChangeDimensionCommand.formatDouble(vec3.x), ChangeDimensionCommand.formatDouble(vec3.y), ChangeDimensionCommand.formatDouble(vec3.z)}), true);
        }
        return targets.size();
    }

    private static void performTeleport(CommandSourceStack source, Entity entity, ServerLevel level, double x, double y, double z, Set<RelativeMovement> relativeList) throws CommandSyntaxException {
        float g;
        BlockPos blockPos = BlockPos.containing((double)x, (double)y, (double)z);
        if (!Level.isInSpawnableBounds((BlockPos)blockPos)) {
            throw INVALID_POSITION.create();
        }
        float f = Mth.wrapDegrees((float)entity.getYRot());
        if (entity.teleportTo(level, x, y, z, relativeList, f, g = Mth.wrapDegrees((float)entity.getXRot()))) {
            LivingEntity livingEntity;
            if (!(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).isFallFlying()) {
                entity.setDeltaMovement(entity.getDeltaMovement().multiply(1.0, 0.0, 1.0));
                entity.setOnGround(true);
            }
            if (entity instanceof PathfinderMob) {
                PathfinderMob pathfinderMob = (PathfinderMob)entity;
                pathfinderMob.getNavigation().stop();
            }
        }
    }

    private static String formatDouble(double d) {
        return String.format(Locale.ROOT, "%f", d);
    }
}

