/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.faucet;

import com.mojang.datafixers.util.Pair;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FaucetTarget;
import net.mehvahdjukaar.supplementaries.common.block.faucet.FluidOffer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;

class BrewingStandInteraction
implements FaucetSource.Tile,
FaucetTarget.Tile {
    BrewingStandInteraction() {
    }

    @Override
    public FluidOffer getProvidedFluid(Level level, BlockPos pos, Direction dir, BlockEntity tile) {
        if (tile instanceof BrewingStandBlockEntity) {
            BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)tile;
            for (int i = 0; i < 3; ++i) {
                ItemStack stack = brewingStand.getItem(i);
                Pair opt = SoftFluidStack.fromItem((ItemStack)stack);
                if (opt == null) continue;
                return FluidOffer.of((SoftFluidStack)opt.getFirst());
            }
        }
        return null;
    }

    @Override
    public void drain(Level level, BlockPos pos, Direction dir, BlockEntity tile, int amount) {
        if (tile instanceof BrewingStandBlockEntity) {
            BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)tile;
            for (int i = 0; i < 3; ++i) {
                ItemStack stack = brewingStand.getItem(i);
                Pair opt = SoftFluidStack.fromItem((ItemStack)stack);
                if (opt == null) continue;
                ItemStack remainder = stack.getItem().hasCraftingRemainingItem() ? Items.GLASS_BOTTLE.getDefaultInstance() : (ItemStack)ForgeHelper.getCraftingRemainingItem((ItemStack)stack).get();
                brewingStand.setItem(i, remainder);
                tile.setChanged();
                return;
            }
        }
    }

    @Override
    public Integer fill(Level level, BlockPos pos, BlockEntity tile, FluidOffer offer) {
        if (tile instanceof BrewingStandBlockEntity) {
            int i;
            BrewingStandBlockEntity brewingStand = (BrewingStandBlockEntity)tile;
            int needToPlace = offer.minAmount();
            ItemStack[] toPlace = new ItemStack[3];
            for (i = 0; i < 3 && needToPlace > 0; ++i) {
                ItemStack stack = brewingStand.getItem(i);
                Pair filled = offer.fluid().toItem(stack, true);
                if (filled == null) continue;
                ItemStack filledItem = (ItemStack)filled.getFirst();
                brewingStand.setItem(i, ItemStack.EMPTY);
                if (brewingStand.canPlaceItem(i, filledItem)) {
                    toPlace[i] = filledItem;
                    --needToPlace;
                }
                brewingStand.setItem(i, stack);
            }
            if (needToPlace == 0) {
                for (i = 0; i < 3; ++i) {
                    if (toPlace[i] == null) continue;
                    brewingStand.setItem(i, toPlace[i]);
                }
                tile.setChanged();
                return offer.minAmount();
            }
        }
        return null;
    }
}

