/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import com.google.common.base.Suppliers;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.block.IPistonMotionReact;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidConsumer;
import net.mehvahdjukaar.moonlight.api.block.IWashable;
import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.util.FakePlayerManager;
import net.mehvahdjukaar.moonlight.api.util.PotionBottleType;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.tiles.BambooSpikesBlockTile;
import net.mehvahdjukaar.supplementaries.common.items.BambooSpikesTippedItem;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModComponents;
import net.mehvahdjukaar.supplementaries.reg.ModDamageSources;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LingeringPotionItem;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BambooSpikesBlock
extends WaterBlock
implements ISoftFluidConsumer,
EntityBlock,
IWashable,
IPistonMotionReact {
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    protected static final VoxelShape SHAPE_UP = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final VoxelShape SHAPE_DOWN = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_SOUTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape SHAPE_WEST = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SHAPE_EAST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    public static final DirectionProperty FACING = DirectionalBlock.FACING;
    public static final BooleanProperty TIPPED = ModBlockProperties.TIPPED;
    private static final GameProfile SPIKE_PLAYER = new GameProfile(UUID.randomUUID(), "Spike Fake Player");
    private static final Supplier<Boolean> TIPPED_ENABLED = Suppliers.memoize(CommonConfigs.Functional.TIPPED_SPIKES_ENABLED::get);

    public BambooSpikesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)TIPPED, (Comparable)Boolean.valueOf(false)));
    }

    public static DamageSource getDamageSource(Level level) {
        if (CommonConfigs.Functional.BAMBOO_SPIKES_DROP_LOOT.get().booleanValue()) {
            Player fakePlayer = FakePlayerManager.get((GameProfile)SPIKE_PLAYER, (Level)level);
            if (fakePlayer instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)fakePlayer;
                sp.getAdvancements().stopListening();
                sp.setGameMode(GameType.SPECTATOR);
            }
            return ModDamageSources.spikePlayer(fakePlayer);
        }
        return ModDamageSources.spike(level);
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        ItemStack stack = context.getItemInHand();
        Integer charges = (Integer)stack.getOrDefault(ModComponents.CHARGES.get(), (Object)0);
        boolean hasPotion = stack.has(DataComponents.POTION_CONTENTS);
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getClickedFace())).setValue((Property)TIPPED, (Comparable)Boolean.valueOf(charges != 0 && hasPotion));
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(this.getSpikeItem((BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY)));
        return list;
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.UP -> SHAPE_UP;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
        };
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return Shapes.block();
    }

    public void entityInside(BlockState state, Level level, BlockPos pos, Entity entityIn) {
        Player player;
        if (entityIn instanceof Player && (player = (Player)entityIn).isCreative()) {
            return;
        }
        if (entityIn instanceof LivingEntity) {
            LivingEntity le = (LivingEntity)entityIn;
            if (entityIn.isAlive()) {
                boolean up = state.getValue((Property)FACING) == Direction.UP;
                double vy = up ? 0.45 : 0.95;
                float fall = entityIn.fallDistance;
                entityIn.makeStuckInBlock(state, new Vec3(0.95, vy, 0.95));
                entityIn.fallDistance = fall;
                if (!level.isClientSide) {
                    BambooSpikesBlockTile te;
                    BlockEntity blockEntity;
                    if (up && entityIn instanceof Player && entityIn.isShiftKeyDown()) {
                        return;
                    }
                    float damage = entityIn.getY() > (double)pos.getY() + 0.0625 ? 3.0f : 1.5f;
                    entityIn.hurt(BambooSpikesBlock.getDamageSource(level), damage);
                    if (((Boolean)state.getValue((Property)TIPPED)).booleanValue() && (blockEntity = level.getBlockEntity(pos)) instanceof BambooSpikesBlockTile && (te = (BambooSpikesBlockTile)blockEntity).interactWithEntity(le, level)) {
                        level.setBlock(pos, (BlockState)state.setValue((Property)TIPPED, (Comparable)Boolean.valueOf(false)), 3);
                        level.gameEvent(entityIn, (Holder)GameEvent.BLOCK_CHANGE, pos);
                    }
                }
            }
        }
    }

    @Nullable
    public PathType getBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob) {
        return PathType.DAMAGE_OTHER;
    }

    @Nullable
    public PathType getAdjacentBlockPathType(BlockState state, BlockGetter level, BlockPos pos, @Nullable Mob mob, PathType originalType) {
        return PathType.DAMAGE_OTHER;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!TIPPED_ENABLED.get().booleanValue() || ((Boolean)state.getValue((Property)TIPPED)).booleanValue()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (stack.getItem() instanceof LingeringPotionItem) {
            PotionContents potion = BambooSpikesTippedItem.getPotion(stack);
            if (BambooSpikesBlock.tryAddingPotion(state, (LevelAccessor)level, pos, potion, (Entity)player) && !player.isCreative()) {
                player.setItemInHand(hand, ItemUtils.createFilledResult((ItemStack)stack.copy(), (Player)player, (ItemStack)new ItemStack((ItemLike)Items.GLASS_BOTTLE), (boolean)false));
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, TIPPED});
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return this.getSpikeItem(level.getBlockEntity(pos));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return (Boolean)pState.getValue((Property)TIPPED) != false ? new BambooSpikesBlockTile(pPos, pState) : null;
    }

    public void animateTick(BlockState state, Level world, BlockPos pos, RandomSource random) {
        BlockEntity blockEntity;
        if (0.01 > (double)random.nextFloat() && ((Boolean)state.getValue((Property)TIPPED)).booleanValue() && (blockEntity = world.getBlockEntity(pos)) instanceof BambooSpikesBlockTile) {
            BambooSpikesBlockTile tile = (BambooSpikesBlockTile)blockEntity;
            tile.makeParticle(world);
        }
    }

    public boolean tryAcceptingFluid(Level world, BlockState state, BlockPos pos, SoftFluidStack fluid) {
        if (!TIPPED_ENABLED.get().booleanValue() || ((Boolean)state.getValue((Property)TIPPED)).booleanValue()) {
            return false;
        }
        if (fluid.is(MLBuiltinSoftFluids.POTION) && PotionBottleType.getOrDefault((SoftFluidStack)fluid) == PotionBottleType.LINGERING) {
            PotionContents content = BambooSpikesTippedItem.getPotion(fluid);
            return BambooSpikesBlock.tryAddingPotion(state, (LevelAccessor)world, pos, content, null);
        }
        return false;
    }

    public static boolean tryAddingPotion(BlockState state, LevelAccessor world, BlockPos pos, PotionContents potion, @Nullable Entity adder) {
        BambooSpikesBlockTile tile;
        world.setBlock(pos, (BlockState)state.setValue((Property)TIPPED, (Comparable)Boolean.valueOf(true)), 0);
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof BambooSpikesBlockTile && (tile = (BambooSpikesBlockTile)te).tryApplyPotion(potion)) {
            world.playSound(null, pos, SoundEvents.HONEY_BLOCK_FALL, SoundSource.BLOCKS, 0.5f, 1.5f);
            world.setBlock(pos, (BlockState)state.setValue((Property)TIPPED, (Comparable)Boolean.valueOf(true)), 3);
            world.gameEvent(adder, (Holder)GameEvent.BLOCK_CHANGE, pos);
            return true;
        }
        if (te != null) {
            te.setRemoved();
        }
        world.setBlock(pos, (BlockState)state.setValue((Property)TIPPED, (Comparable)Boolean.valueOf(false)), 0);
        return false;
    }

    public boolean tryWash(Level level, BlockPos pos, BlockState state, Vec3 hitVec) {
        if (((Boolean)state.getValue((Property)TIPPED)).booleanValue()) {
            if (!level.isClientSide) {
                BlockEntity te = level.getBlockEntity(pos);
                if (te != null) {
                    te.setRemoved();
                }
                level.setBlock(pos, (BlockState)state.setValue((Property)TIPPED, (Comparable)Boolean.valueOf(false)), 3);
            }
            return true;
        }
        return false;
    }

    public boolean ticksWhileMoved() {
        return true;
    }

    public void moveTick(Level level, BlockPos pos, BlockState movedState, AABB aabb, PistonMovingBlockEntity tile) {
        boolean sameDir = ((Direction)movedState.getValue((Property)FACING)).equals((Object)tile.getDirection());
        if (CompatHandler.QUARK) {
            QuarkCompat.tickPiston(level, pos, movedState, aabb, sameDir, (BlockEntity)tile);
        }
    }

    public ItemStack getSpikeItem(@Nullable BlockEntity te) {
        if (te instanceof BambooSpikesBlockTile) {
            BambooSpikesBlockTile tile = (BambooSpikesBlockTile)te;
            return Utils.saveTileToItem((BlockEntity)tile);
        }
        return ModRegistry.BAMBOO_SPIKES_ITEM.get().getDefaultInstance();
    }
}

