/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.platform;

import com.mrbysco.armorposer.config.PoserConfig;
import com.mrbysco.armorposer.data.SwapData;
import com.mrbysco.armorposer.data.SyncData;
import com.mrbysco.armorposer.packets.ArmorStandSwapPayload;
import com.mrbysco.armorposer.packets.ArmorStandSyncPayload;
import com.mrbysco.armorposer.platform.services.IPlatformHelper;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.network.PacketDistributor;

public class NeoForgePlatformHelper
implements IPlatformHelper {
    @Override
    public void updateEntity(ArmorStand armorStand, CompoundTag compound) {
        CompoundTag CompoundNBT = armorStand.saveWithoutId(new CompoundTag()).copy();
        CompoundNBT.merge(compound);
        armorStand.load(CompoundNBT);
        PacketDistributor.sendToServer((CustomPacketPayload)new ArmorStandSyncPayload(new SyncData(armorStand.getUUID(), compound)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void swapSlots(ArmorStand armorStand, SwapData.Action action) {
        PacketDistributor.sendToServer((CustomPacketPayload)new ArmorStandSwapPayload(new SwapData(armorStand.getUUID(), action)), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public boolean allowScrolling() {
        return (Boolean)PoserConfig.COMMON.allowScrolling.get();
    }

    @Override
    public Path getUserPresetFolder() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Override
    public boolean isResizeRestrictedToOPS() {
        return (Boolean)PoserConfig.COMMON.restrictResizeToOP.get();
    }

    @Override
    public List<? extends String> getResizeWhitelist() {
        return (List)PoserConfig.COMMON.resizeWhitelist.get();
    }

    @Override
    public String getModVersion() {
        return ModList.get().getModFileById("armorposer").versionString();
    }
}

