/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.data;

import com.mrbysco.armorposer.Reference;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.UUIDUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;

public record SyncData(UUID entityUUID, CompoundTag tag) {
    public static final StreamCodec<FriendlyByteBuf, SyncData> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, SyncData::entityUUID, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, SyncData::tag, SyncData::new);
    private static final List<String> allowedKeys = List.of("Invisible", "NoBasePlate", "NoGravity", "ShowArms", "Small", "CustomNameVisible", "Invulnerable", "Pose", "DisabledSlots", "Pose", "Scale", "Move", "Rotation");

    public void handleData(ArmorStand armorStand, Player player) {
        CompoundTag entityTag = armorStand.saveWithoutId(new CompoundTag());
        CompoundTag entityTagCopy = entityTag.copy();
        if (!this.tag.isEmpty()) {
            AttributeInstance attributeInstance;
            double scale;
            List<String> keysToRemove = this.tag.getAllKeys().stream().filter(key -> !allowedKeys.contains(key)).toList();
            keysToRemove.forEach(arg_0 -> ((CompoundTag)this.tag).remove(arg_0));
            entityTagCopy.merge(this.tag);
            armorStand.load(entityTagCopy);
            armorStand.setUUID(this.entityUUID);
            ListTag tagList = this.tag.getList("Move", 6);
            double xOffset = tagList.getDouble(0);
            double yOffset = tagList.getDouble(1);
            double zOffset = tagList.getDouble(2);
            if (xOffset != 0.0 || yOffset != 0.0 || zOffset != 0.0) {
                armorStand.setPosRaw(armorStand.getX() + xOffset, armorStand.getY() + yOffset, armorStand.getZ() + zOffset);
            }
            if (Reference.canResize(player) && (scale = this.tag.getDouble("Scale")) > 0.0 && (attributeInstance = armorStand.getAttributes().getInstance(Attributes.SCALE)) != null) {
                attributeInstance.setBaseValue(scale);
            }
        }
    }
}

