/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.config;

import com.mrbysco.armorposer.Reference;
import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class PoserConfig {
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Reference.LOGGER.debug("Loaded {}'s config file {}", (Object)"armorposer", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Reference.LOGGER.debug("{}'s config just got changed on the file system!", (Object)"armorposer");
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.BooleanValue enableConfigGui;
        public final ModConfigSpec.BooleanValue enableNameTags;
        public final ModConfigSpec.BooleanValue allowScrolling;
        public final ModConfigSpec.BooleanValue restrictResizeToOP;
        public final ModConfigSpec.ConfigValue<List<? extends String>> resizeWhitelist;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("General settings").translation("armorposer.config.general").push("General");
            this.enableConfigGui = builder.comment("Show the Armor Stand configuration GUI on shift right click").translation("armorposer.config.enableConfigGui").define("enableConfigGui", true);
            this.enableNameTags = builder.comment("Allow Armor Stand to be renamed using name tags").translation("armorposer.config.enableNameTags").define("enableNameTags", true);
            this.allowScrolling = builder.comment("Allow scrolling to increase / decrease an angle value in the posing screen").translation("armorposer.config.allowScrolling").define("allowScrolling", true);
            this.restrictResizeToOP = builder.comment("Restrict the ability to resize the Armor Stand to server operators").translation("armorposer.config.restrictResizeToOP").define("restrictResizeToOP", false);
            this.resizeWhitelist = builder.comment("List of players that are allowed to resize the Armor Stand when restrictResizeToOP is enabled").translation("armorposer.config.resizeWhitelist").defineListAllowEmpty("resizeWhitelist", List.of(), () -> "", o -> o instanceof String);
            builder.pop();
        }
    }
}

