/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client.gui.widgets;

import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.math.NumberUtils;

public class SizeField
extends EditBox {
    public final float scrollMultiplier = 0.1f;
    public final float minValue = 0.01f;
    public final float maxValue = 10.0f;

    public SizeField(Font font, int x, int y, int width, int height, Component defaultValue) {
        super(font, x, y, width, height, defaultValue);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void insertText(String textToWrite) {
        float currentValue;
        if (this.isNumeric(textToWrite)) {
            super.insertText(textToWrite);
        }
        if ((currentValue = this.getFloat()) > 10.0f) {
            this.setValue(String.valueOf(10.0f));
        } else if (currentValue < 0.01f) {
            this.setValue(String.valueOf(0.01f));
        }
    }

    public String getValue() {
        return this.isNumeric(super.getValue()) ? super.getValue() : "1.0";
    }

    public void setValue(String value) {
        if (value.isEmpty()) {
            super.setValue("1.0");
        } else {
            super.setValue(String.format("%.2f", Float.valueOf(Float.parseFloat(value))));
        }
    }

    public float getFloat() {
        return NumberUtils.toFloat((String)super.getValue(), (float)1.0f);
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
        if (!focused) {
            this.setHighlightPos(this.getValue().length());
            this.moveCursorToEnd(false);
        }
    }

    protected boolean isNumeric(String value) {
        return value.equals(".") || NumberUtils.isParsable((String)value);
    }
}

