/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.registries;

import com.google.common.base.Function;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllDisplaySources;
import com.simibubi.create.AllMountedStorageTypes;
import com.simibubi.create.AllSpriteShifts;
import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.api.behaviour.display.DisplaySource;
import com.simibubi.create.api.behaviour.interaction.MovingInteractionBehaviour;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.api.stress.BlockStressValues;
import com.simibubi.create.content.decoration.encasing.CasingBlock;
import com.simibubi.create.content.decoration.encasing.CasingConnectivity;
import com.simibubi.create.content.decoration.encasing.EncasedCTBehaviour;
import com.simibubi.create.content.decoration.encasing.EncasingRegistry;
import com.simibubi.create.content.fluids.PipeAttachmentModel;
import com.simibubi.create.content.fluids.pipes.EncasedPipeBlock;
import com.simibubi.create.content.kinetics.belt.BeltBlockEntity;
import com.simibubi.create.content.kinetics.gearbox.GearboxBlock;
import com.simibubi.create.content.kinetics.simpleRelays.BracketedKineticBlockModel;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogCTBehaviour;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedCogwheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.encased.EncasedShaftBlock;
import com.simibubi.create.content.logistics.depot.MountedDepotInteractionBehaviour;
import com.simibubi.create.content.processing.AssemblyOperatorBlockItem;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.ModelGen;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.foundation.data.TagGen;
import com.simibubi.create.foundation.item.ItemDescription;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.providers.RegistrateProvider;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import fr.iglee42.createcasing.CreateCasing;
import fr.iglee42.createcasing.blocks.ConfigurableGearboxBlock;
import fr.iglee42.createcasing.blocks.CreativeCogwheelBlock;
import fr.iglee42.createcasing.blocks.customs.CustomChainDriveBlock;
import fr.iglee42.createcasing.blocks.customs.CustomChainGearshiftBlock;
import fr.iglee42.createcasing.blocks.customs.CustomDepotBlock;
import fr.iglee42.createcasing.blocks.customs.CustomGearboxBlock;
import fr.iglee42.createcasing.blocks.customs.CustomMixerBlock;
import fr.iglee42.createcasing.blocks.customs.CustomPressBlock;
import fr.iglee42.createcasing.blocks.customs.EncasedCustomCogwheelBlock;
import fr.iglee42.createcasing.blocks.customs.WoodenCogwheelBlock;
import fr.iglee42.createcasing.blocks.publics.PublicChainConveyorBlock;
import fr.iglee42.createcasing.blocks.publics.PublicEncasedCogwheelBlock;
import fr.iglee42.createcasing.blocks.publics.PublicEncasedPipeBlock;
import fr.iglee42.createcasing.blocks.publics.PublicEncasedShaftBlock;
import fr.iglee42.createcasing.blocks.shafts.BrassShaftBlock;
import fr.iglee42.createcasing.blocks.shafts.EncasedCustomShaftBlock;
import fr.iglee42.createcasing.blocks.shafts.GlassShaftBlock;
import fr.iglee42.createcasing.blocks.shafts.MetalShaftBlock;
import fr.iglee42.createcasing.blocks.shafts.WoodenShaftBlock;
import fr.iglee42.createcasing.config.CCStress;
import fr.iglee42.createcasing.items.CustomVerticalGearboxItem;
import fr.iglee42.createcasing.items.WoodenCogwheelBlockItem;
import fr.iglee42.createcasing.registries.EncasedBlockStateGens;
import fr.iglee42.createcasing.registries.EncasedCreativeModeTabs;
import fr.iglee42.createcasing.registries.EncasedItems;
import fr.iglee42.createcasing.registries.EncasedSprites;
import fr.iglee42.createcasing.utils.CasingBuilderTransformers;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.createmod.catnip.data.Couple;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.registries.DeferredRegister;

public class EncasedBlocks {
    public static final DeferredRegister<Block> BLOCKS;
    public static final BlockEntry<CasingBlock> CREATIVE_CASING;
    public static BeltBlockEntity.CasingType COPPER_BELT_CASING;
    public static BeltBlockEntity.CasingType RAILWAY_BELT_CASING;
    public static BeltBlockEntity.CasingType INDUSTRIAL_IRON_BELT_CASING;
    public static BeltBlockEntity.CasingType CREATIVE_BELT_CASING;
    public static BeltBlockEntity.CasingType WEATHERED_IRON_BELT_CASING;
    public static BeltBlockEntity.CasingType REFINED_RADIANCE_BELT_CASING;
    public static BeltBlockEntity.CasingType SHADOW_STEEL_BELT_CASING;
    public static final BlockEntry<PublicEncasedShaftBlock> RAILWAY_ENCASED_SHAFT;
    public static final BlockEntry<PublicEncasedShaftBlock> COPPER_ENCASED_SHAFT;
    public static final BlockEntry<PublicEncasedShaftBlock> SHADOW_STEEL_ENCASED_SHAFT;
    public static final BlockEntry<PublicEncasedShaftBlock> REFINED_RADIANCE_ENCASED_SHAFT;
    public static final BlockEntry<PublicEncasedShaftBlock> CREATIVE_ENCASED_SHAFT;
    public static final BlockEntry<PublicEncasedShaftBlock> INDUSTRIAL_IRON_ENCASED_SHAFT;
    public static final BlockEntry<PublicEncasedShaftBlock> WEATHERED_IRON_ENCASED_SHAFT;
    public static final BlockEntry<PublicEncasedCogwheelBlock> RAILWAY_ENCASED_COGWHEEL;
    public static final BlockEntry<PublicEncasedCogwheelBlock> COPPER_ENCASED_COGWHEEL;
    public static final BlockEntry<PublicEncasedCogwheelBlock> SHADOW_STEEL_ENCASED_COGWHEEL;
    public static final BlockEntry<PublicEncasedCogwheelBlock> REFINED_RADIANCE_ENCASED_COGWHEEL;
    public static final BlockEntry<PublicEncasedCogwheelBlock> CREATIVE_ENCASED_COGWHEEL;
    public static final BlockEntry<PublicEncasedCogwheelBlock> INDUSTRIAL_IRON_ENCASED_COGWHEEL;
    public static final BlockEntry<PublicEncasedCogwheelBlock> WEATHERED_IRON_ENCASED_COGWHEEL;
    public static final BlockEntry<PublicEncasedCogwheelBlock> RAILWAY_ENCASED_COGWHEEL_LARGE;
    public static final BlockEntry<PublicEncasedCogwheelBlock> COPPER_ENCASED_COGWHEEL_LARGE;
    public static final BlockEntry<PublicEncasedCogwheelBlock> SHADOW_STEEL_ENCASED_COGWHEEL_LARGE;
    public static final BlockEntry<PublicEncasedCogwheelBlock> REFINED_RADIANCE_ENCASED_COGWHEEL_LARGE;
    public static final BlockEntry<PublicEncasedCogwheelBlock> CREATIVE_ENCASED_COGWHEEL_LARGE;
    public static final BlockEntry<PublicEncasedCogwheelBlock> INDUSTRIAL_IRON_ENCASED_COGWHEEL_LARGE;
    public static final BlockEntry<PublicEncasedCogwheelBlock> WEATHERED_IRON_ENCASED_COGWHEEL_LARGE;
    public static final BlockEntry<PublicEncasedPipeBlock> ENCASED_ANDESITE_FLUID_PIPE;
    public static final BlockEntry<PublicEncasedPipeBlock> ENCASED_BRASS_FLUID_PIPE;
    public static final BlockEntry<PublicEncasedPipeBlock> ENCASED_RAILWAY_FLUID_PIPE;
    public static final BlockEntry<PublicEncasedPipeBlock> ENCASED_SHADOW_STEEL_FLUID_PIPE;
    public static final BlockEntry<PublicEncasedPipeBlock> ENCASED_REFINED_RADIANCE_FLUID_PIPE;
    public static final BlockEntry<PublicEncasedPipeBlock> ENCASED_CREATIVE_FLUID_PIPE;
    public static final BlockEntry<PublicEncasedPipeBlock> ENCASED_INDUSTRIAL_IRON_FLUID_PIPE;
    public static final BlockEntry<PublicEncasedPipeBlock> ENCASED_WEATHERED_IRON_FLUID_PIPE;
    public static final BlockEntry<CustomGearboxBlock> BRASS_GEARBOX;
    public static final BlockEntry<CustomGearboxBlock> COPPER_GEARBOX;
    public static final BlockEntry<CustomGearboxBlock> RAILWAY_GEARBOX;
    public static final BlockEntry<CustomGearboxBlock> CREATIVE_GEARBOX;
    public static final BlockEntry<CustomGearboxBlock> INDUSTRIAL_IRON_GEARBOX;
    public static final BlockEntry<CustomGearboxBlock> WEATHERED_IRON_GEARBOX;
    public static final BlockEntry<CustomGearboxBlock> REFINED_RADIANCE_GEARBOX;
    public static final BlockEntry<CustomGearboxBlock> SHADOW_STEEL_GEARBOX;
    public static final BlockEntry<CustomMixerBlock> BRASS_MIXER;
    public static final BlockEntry<CustomMixerBlock> COPPER_MIXER;
    public static final BlockEntry<CustomMixerBlock> RAILWAY_MIXER;
    public static final BlockEntry<CustomMixerBlock> CREATIVE_MIXER;
    public static final BlockEntry<CustomMixerBlock> INDUSTRIAL_IRON_MIXER;
    public static final BlockEntry<CustomMixerBlock> WEATHERED_IRON_MIXER;
    public static final BlockEntry<CustomMixerBlock> REFINED_RADIANCE_MIXER;
    public static final BlockEntry<CustomMixerBlock> SHADOW_STEEL_MIXER;
    public static final BlockEntry<CustomPressBlock> BRASS_PRESS;
    public static final BlockEntry<CustomPressBlock> COPPER_PRESS;
    public static final BlockEntry<CustomPressBlock> RAILWAY_PRESS;
    public static final BlockEntry<CustomPressBlock> CREATIVE_PRESS;
    public static final BlockEntry<CustomPressBlock> INDUSTRIAL_IRON_PRESS;
    public static final BlockEntry<CustomPressBlock> WEATHERED_IRON_PRESS;
    public static final BlockEntry<CustomPressBlock> REFINED_RADIANCE_PRESS;
    public static final BlockEntry<CustomPressBlock> SHADOW_STEEL_PRESS;
    public static final BlockEntry<CustomDepotBlock> BRASS_DEPOT;
    public static final BlockEntry<CustomDepotBlock> COPPER_DEPOT;
    public static final BlockEntry<CustomDepotBlock> RAILWAY_DEPOT;
    public static final BlockEntry<CustomDepotBlock> CREATIVE_DEPOT;
    public static final BlockEntry<CustomDepotBlock> INDUSTRIAL_IRON_DEPOT;
    public static final BlockEntry<CustomDepotBlock> WEATHERED_IRON_DEPOT;
    public static final BlockEntry<CustomDepotBlock> REFINED_RADIANCE_DEPOT;
    public static final BlockEntry<CustomDepotBlock> SHADOW_STEEL_DEPOT;
    public static final BlockEntry<CustomChainDriveBlock> BRASS_CHAIN_DRIVE;
    public static final BlockEntry<CustomChainDriveBlock> COPPER_CHAIN_DRIVE;
    public static final BlockEntry<CustomChainDriveBlock> RAILWAY_CHAIN_DRIVE;
    public static final BlockEntry<CustomChainDriveBlock> CREATIVE_CHAIN_DRIVE;
    public static final BlockEntry<CustomChainDriveBlock> INDUSTRIAL_IRON_CHAIN_DRIVE;
    public static final BlockEntry<CustomChainDriveBlock> WEATHERED_IRON_CHAIN_DRIVE;
    public static final BlockEntry<CustomChainDriveBlock> REFINED_RADIANCE_CHAIN_DRIVE;
    public static final BlockEntry<CustomChainDriveBlock> SHADOW_STEEL_CHAIN_DRIVE;
    public static final BlockEntry<CustomChainGearshiftBlock> BRASS_CHAIN_GEARSHIFT;
    public static final BlockEntry<CustomChainGearshiftBlock> COPPER_CHAIN_GEARSHIFT;
    public static final BlockEntry<CustomChainGearshiftBlock> RAILWAY_CHAIN_GEARSHIFT;
    public static final BlockEntry<CustomChainGearshiftBlock> CREATIVE_CHAIN_GEARSHIFT;
    public static final BlockEntry<CustomChainGearshiftBlock> INDUSTRIAL_IRON_CHAIN_GEARSHIFT;
    public static final BlockEntry<CustomChainGearshiftBlock> WEATHERED_IRON_CHAIN_GEARSHIFT;
    public static final BlockEntry<CustomChainGearshiftBlock> REFINED_RADIANCE_CHAIN_GEARSHIFT;
    public static final BlockEntry<CustomChainGearshiftBlock> SHADOW_STEEL_CHAIN_GEARSHIFT;
    public static final BlockEntry<ConfigurableGearboxBlock> ANDESITE_CONFIGURABLE_GEARBOX;
    public static final BlockEntry<ConfigurableGearboxBlock> BRASS_CONFIGURABLE_GEARBOX;
    public static final BlockEntry<ConfigurableGearboxBlock> COPPER_CONFIGURABLE_GEARBOX;
    public static final BlockEntry<ConfigurableGearboxBlock> RAILWAY_CONFIGURABLE_GEARBOX;
    public static final BlockEntry<ConfigurableGearboxBlock> CREATIVE_CONFIGURABLE_GEARBOX;
    public static final BlockEntry<ConfigurableGearboxBlock> INDUSTRIAL_IRON_CONFIGURABLE_GEARBOX;
    public static final BlockEntry<ConfigurableGearboxBlock> WEATHERED_IRON_CONFIGURABLE_GEARBOX;
    public static final BlockEntry<ConfigurableGearboxBlock> REFINED_RADIANCE_CONFIGURABLE_GEARBOX;
    public static final BlockEntry<ConfigurableGearboxBlock> SHADOW_STEEL_CONFIGURABLE_GEARBOX;
    public static final BlockEntry<PublicChainConveyorBlock> BRASS_CHAIN_CONVEYOR;
    public static final BlockEntry<PublicChainConveyorBlock> COPPER_CHAIN_CONVEYOR;
    public static final BlockEntry<PublicChainConveyorBlock> RAILWAY_CHAIN_CONVEYOR;
    public static final BlockEntry<PublicChainConveyorBlock> CREATIVE_CHAIN_CONVEYOR;
    public static final BlockEntry<PublicChainConveyorBlock> INDUSTRIAL_IRON_CHAIN_CONVEYOR;
    public static final BlockEntry<PublicChainConveyorBlock> WEATHERED_IRON_CHAIN_CONVEYOR;
    public static final BlockEntry<PublicChainConveyorBlock> REFINED_RADIANCE_CHAIN_CONVEYOR;
    public static final BlockEntry<PublicChainConveyorBlock> SHADOW_STEEL_CHAIN_CONVEYOR;
    public static final BlockEntry<WoodenShaftBlock> OAK_SHAFT;
    public static final BlockEntry<WoodenShaftBlock> SPRUCE_SHAFT;
    public static final BlockEntry<WoodenShaftBlock> BIRCH_SHAFT;
    public static final BlockEntry<WoodenShaftBlock> JUNGLE_SHAFT;
    public static final BlockEntry<WoodenShaftBlock> ACACIA_SHAFT;
    public static final BlockEntry<WoodenShaftBlock> DARK_OAK_SHAFT;
    public static final BlockEntry<WoodenShaftBlock> MANGROVE_SHAFT;
    public static final BlockEntry<WoodenShaftBlock> CHERRY_SHAFT;
    public static final BlockEntry<WoodenShaftBlock> BAMBOO_SHAFT;
    public static final BlockEntry<WoodenShaftBlock> CRIMSON_SHAFT;
    public static final BlockEntry<WoodenShaftBlock> WARPED_SHAFT;
    public static final BlockEntry<WoodenCogwheelBlock> OAK_COGWHEEL;
    public static final BlockEntry<WoodenCogwheelBlock> BIRCH_COGWHEEL;
    public static final BlockEntry<WoodenCogwheelBlock> JUNGLE_COGWHEEL;
    public static final BlockEntry<WoodenCogwheelBlock> ACACIA_COGWHEEL;
    public static final BlockEntry<WoodenCogwheelBlock> DARK_OAK_COGWHEEL;
    public static final BlockEntry<WoodenCogwheelBlock> MANGROVE_COGWHEEL;
    public static final BlockEntry<WoodenCogwheelBlock> CHERRY_COGWHEEL;
    public static final BlockEntry<WoodenCogwheelBlock> BAMBOO_COGWHEEL;
    public static final BlockEntry<WoodenCogwheelBlock> CRIMSON_COGWHEEL;
    public static final BlockEntry<WoodenCogwheelBlock> WARPED_COGWHEEL;
    public static final BlockEntry<WoodenCogwheelBlock> OAK_LARGE_COGWHEEL;
    public static final BlockEntry<WoodenCogwheelBlock> BIRCH_LARGE_COGWHEEL;
    public static final BlockEntry<WoodenCogwheelBlock> JUNGLE_LARGE_COGWHEEL;
    public static final BlockEntry<WoodenCogwheelBlock> ACACIA_LARGE_COGWHEEL;
    public static final BlockEntry<WoodenCogwheelBlock> DARK_OAK_LARGE_COGWHEEL;
    public static final BlockEntry<WoodenCogwheelBlock> MANGROVE_LARGE_COGWHEEL;
    public static final BlockEntry<WoodenCogwheelBlock> CHERRY_LARGE_COGWHEEL;
    public static final BlockEntry<WoodenCogwheelBlock> BAMBOO_LARGE_COGWHEEL;
    public static final BlockEntry<WoodenCogwheelBlock> CRIMSON_LARGE_COGWHEEL;
    public static final BlockEntry<WoodenCogwheelBlock> WARPED_LARGE_COGWHEEL;
    public static final BlockEntry<GlassShaftBlock> GLASS_SHAFT;
    public static final BlockEntry<BrassShaftBlock> BRASS_SHAFT;
    public static final BlockEntry<MetalShaftBlock> MLDEG_SHAFT;
    public static final BlockEntry<CreativeCogwheelBlock> CREATIVE_COGWHEEL;

    public static BlockEntry<CasingBlock> createCasing(String name, CTSpriteShiftEntry connectedTexturesSprite) {
        return ((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_casing", CasingBlock::new).properties(p -> p.mapColor(MapColor.PODZOL)).transform(CasingBuilderTransformers.casing(() -> connectedTexturesSprite))).blockstate((c, p) -> p.simpleBlock((Block)c.get(), (ModelFile)p.models().cubeAll(c.getName(), Create.asResource((String)("block/" + c.getId().getPath()))))).simpleItem().register();
    }

    private static BlockEntry<PublicEncasedShaftBlock> createShaft(String name, Supplier<Block> casing, CTSpriteShiftEntry sprite) {
        return EncasedBlocks.createShaft(AllBlocks.SHAFT, name, casing, sprite, PublicEncasedShaftBlock::new);
    }

    private static <E extends Block, T extends EncasedShaftBlock> BlockEntry<T> createShaft(BlockEntry<E> shaft, String name, Supplier<Block> casing, CTSpriteShiftEntry sprite, NonNullBiFunction<BlockBehaviour.Properties, Supplier<Block>, T> factory) {
        String s = shaft.getId().getPath().replace("_shaft", "");
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_encased" + (String)(shaft.equals((Object)AllBlocks.SHAFT) ? "" : "_" + s) + "_shaft", p -> (EncasedShaftBlock)factory.apply(p, (Object)casing)).properties(p -> p.mapColor(MapColor.PODZOL)).transform(CasingBuilderTransformers.encasedShaft(shaft, name, () -> sprite))).transform((NonNullFunction)EncasingRegistry.addVariantTo(shaft))).transform(TagGen.axeOrPickaxe())).onRegisterAfter(Registries.ITEM, CreateCasing::hideItem)).register();
    }

    private static BlockEntry<PublicEncasedCogwheelBlock> createCogwheel(String name, Supplier<Block> casing, CTSpriteShiftEntry sprite, CTSpriteShiftEntry sideSprite, CTSpriteShiftEntry otherSideSprite) {
        return EncasedBlocks.createCogwheel(AllBlocks.COGWHEEL, name, casing, sprite, sideSprite, otherSideSprite, (p, c) -> new PublicEncasedCogwheelBlock((BlockBehaviour.Properties)p, false, (Supplier<Block>)c));
    }

    private static <E extends Block, T extends EncasedCogwheelBlock> BlockEntry<T> createCogwheel(BlockEntry<E> cogwheel, String name, Supplier<Block> casing, CTSpriteShiftEntry sprite, CTSpriteShiftEntry sideSprite, CTSpriteShiftEntry otherSideSprite, NonNullBiFunction<BlockBehaviour.Properties, Supplier<Block>, T> factory) {
        String s = cogwheel.getId().getPath().replace("_cogwheel", "");
        BlockBuilder builder = (BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_encased" + (String)(cogwheel.equals((Object)AllBlocks.COGWHEEL) ? "" : "_" + s) + "_cogwheel", p -> (EncasedCogwheelBlock)factory.apply(p, (Object)casing)).properties(p -> p.mapColor(MapColor.PODZOL)).transform(CasingBuilderTransformers.encasedCogwheel(cogwheel, name, () -> sprite))).transform((NonNullFunction)EncasingRegistry.addVariantTo(cogwheel))).transform(TagGen.axeOrPickaxe())).onRegisterAfter(Registries.ITEM, CreateCasing::hideItem);
        if (sprite != null) {
            builder = (BlockBuilder)builder.onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCogCTBehaviour(sprite, Couple.create((Object)sideSprite, (Object)otherSideSprite))));
        }
        return builder.register();
    }

    private static BlockEntry<PublicEncasedCogwheelBlock> createLargeCogwheel(String name, Supplier<Block> casing, CTSpriteShiftEntry sprite) {
        return EncasedBlocks.createLargeCogwheel(AllBlocks.LARGE_COGWHEEL, name, casing, sprite, (p, c) -> new PublicEncasedCogwheelBlock((BlockBehaviour.Properties)p, true, (Supplier<Block>)c));
    }

    private static <E extends Block, T extends EncasedCogwheelBlock> BlockEntry<T> createLargeCogwheel(BlockEntry<E> cogwheel, String name, Supplier<Block> casing, CTSpriteShiftEntry sprite, NonNullBiFunction<BlockBehaviour.Properties, Supplier<Block>, T> factory) {
        String s = cogwheel.getId().getPath().replace("_large_cogwheel", "");
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_encased" + (String)(cogwheel.equals((Object)AllBlocks.LARGE_COGWHEEL) ? "" : "_" + s) + "_large_cogwheel", p -> (EncasedCogwheelBlock)factory.apply(p, (Object)casing)).properties(p -> p.mapColor(MapColor.PODZOL)).transform(CasingBuilderTransformers.encasedLargeCogwheel(cogwheel, name, () -> sprite))).transform((NonNullFunction)EncasingRegistry.addVariantTo(cogwheel))).transform(TagGen.axeOrPickaxe())).onRegisterAfter(Registries.ITEM, CreateCasing::hideItem)).register();
    }

    private static BlockEntry<PublicEncasedPipeBlock> createPipe(String name, Supplier<Block> casing, CTSpriteShiftEntry sprite) {
        BlockBuilder<PublicEncasedPipeBlock, CreateRegistrate> builder = (BlockBuilder<PublicEncasedPipeBlock, CreateRegistrate>)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_encased_fluid_pipe", p -> new PublicEncasedPipeBlock((BlockBehaviour.Properties)p, casing)).initialProperties(SharedProperties::copperMetal).properties(p -> p.mapColor(MapColor.TERRACOTTA_LIGHT_GRAY)).properties(BlockBehaviour.Properties::noOcclusion).transform(TagGen.axeOrPickaxe())).blockstate(EncasedBlockStateGens.encasedPipe(name)).onRegister(CreateRegistrate.blockModel(() -> PipeAttachmentModel::withAO))).loot((p, b) -> p.dropOther((Block)b, (ItemLike)AllBlocks.FLUID_PIPE.get())).transform((NonNullFunction)EncasingRegistry.addVariantTo((Supplier)AllBlocks.FLUID_PIPE))).onRegisterAfter(Registries.ITEM, CreateCasing::hideItem);
        builder = EncasedBlocks.connectedTexture(builder, sprite, (block, cc) -> cc.make((Block)block, sprite, (s, f) -> (Boolean)s.getValue((Property)EncasedPipeBlock.FACING_TO_PROPERTY_MAP.get(f)) == false));
        return builder.register();
    }

    private static BlockEntry<CustomGearboxBlock> createGearbox(String name, CTSpriteShiftEntry sprite, ItemEntry<CustomVerticalGearboxItem> item) {
        BlockBuilder<CustomGearboxBlock, CreateRegistrate> entry = ((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_gearbox", p -> new CustomGearboxBlock((BlockBehaviour.Properties)p, item)).initialProperties(SharedProperties::stone).properties(BlockBehaviour.Properties::noOcclusion).properties(p -> p.mapColor(MapColor.PODZOL)).transform(CCStress.setNoImpact())).transform(TagGen.axeOrPickaxe())).blockstate(EncasedBlockStateGens.gearbox(name));
        entry = EncasedBlocks.connectedTexture(entry, sprite, (block, cc) -> cc.make((Block)block, sprite, (s, f) -> f.getAxis() == s.getValue((Property)GearboxBlock.AXIS)));
        return ((BlockBuilder)entry.item().model((ctx, prov) -> ((ItemModelBuilder)prov.getBuilder(ctx.getName())).parent(Objects.requireNonNull(EncasedBlockStateGens.gearboxModel((RegistrateProvider)prov, name, "item")))).build()).register();
    }

    private static BlockEntry<CustomMixerBlock> createMixer(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_mixer", CustomMixerBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.mapColor(MapColor.STONE)).properties(BlockBehaviour.Properties::noOcclusion).transform(TagGen.axeOrPickaxe())).blockstate(EncasedBlockStateGens.mixer(name)).onRegisterAfter(Registries.ITEM, v -> ItemDescription.useKey((ItemLike)v, (String)"block.createcasing.custom_mixer"))).addLayer(() -> RenderType::cutoutMipped).transform(CCStress.setImpact(4.0))).item(AssemblyOperatorBlockItem::new).model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(EncasedBlockStateGens.mixerModel((RegistrateProvider)p, name, true))).build()).register();
    }

    private static BlockEntry<CustomPressBlock> createPress(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_press", CustomPressBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.mapColor(MapColor.PODZOL)).properties(BlockBehaviour.Properties::noOcclusion).transform(TagGen.axeOrPickaxe())).blockstate(EncasedBlockStateGens.press(name)).transform(CCStress.setImpact(8.0))).onRegisterAfter(Registries.ITEM, v -> ItemDescription.useKey((ItemLike)v, (String)"block.createcasing.custom_press"))).item(AssemblyOperatorBlockItem::new).model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(EncasedBlockStateGens.pressModel((RegistrateProvider)p, name, true))).build()).register();
    }

    private static BlockEntry<WoodenShaftBlock> createWoodenShaft(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_shaft", WoodenShaftBlock::new).initialProperties(SharedProperties::wooden).properties(p -> p.mapColor(MapColor.METAL)).transform(CCStress.setNoImpact())).transform(TagGen.axeOnly())).blockstate(EncasedBlockStateGens.shaft(name)).onRegister(CreateRegistrate.blockModel(() -> BracketedKineticBlockModel::new))).item().model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(Objects.requireNonNull(EncasedBlockStateGens.shaftModel((RegistrateProvider)p, name)))).build()).register();
    }

    private static BlockEntry<WoodenCogwheelBlock> createWoodenCogwheel(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_cogwheel", WoodenCogwheelBlock::small).initialProperties(SharedProperties::stone).properties(p -> p.sound(SoundType.WOOD).mapColor(MapColor.DIRT)).transform(CCStress.setNoImpact())).transform(TagGen.axeOnly())).blockstate(EncasedBlockStateGens.cogwheel(name)).onRegister(CreateRegistrate.blockModel(() -> BracketedKineticBlockModel::new))).item(WoodenCogwheelBlockItem::new).model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(Objects.requireNonNull(EncasedBlockStateGens.cogwheelModel((RegistrateProvider)p, name, true)))).build()).register();
    }

    private static BlockEntry<WoodenCogwheelBlock> createLargeWoodenCogwheel(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_large_cogwheel", WoodenCogwheelBlock::large).initialProperties(SharedProperties::stone).properties(p -> p.sound(SoundType.WOOD).mapColor(MapColor.DIRT)).transform(TagGen.axeOnly())).transform(CCStress.setNoImpact())).blockstate(EncasedBlockStateGens.largeCogwheel(name)).onRegister(CreateRegistrate.blockModel(() -> BracketedKineticBlockModel::new))).item(WoodenCogwheelBlockItem::new).model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(Objects.requireNonNull(EncasedBlockStateGens.largeCogwheelModel((RegistrateProvider)p, name, true)))).build()).register();
    }

    public static BlockEntry<CustomDepotBlock> createDepot(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_depot", CustomDepotBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.mapColor(MapColor.COLOR_GRAY)).transform(TagGen.axeOrPickaxe())).blockstate(EncasedBlockStateGens.depot(name)).transform((NonNullFunction)DisplaySource.displaySource((RegistryEntry)AllDisplaySources.ITEM_NAMES))).onRegister(MovingInteractionBehaviour.interactionBehaviour((MovingInteractionBehaviour)new MountedDepotInteractionBehaviour()))).transform((NonNullFunction)MountedItemStorageType.mountedItemStorage((RegistryEntry)AllMountedStorageTypes.DEPOT))).item().model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(Objects.requireNonNull(EncasedBlockStateGens.depotModel((RegistrateProvider)p, name)))).build()).register();
    }

    public static BlockEntry<CustomChainDriveBlock> createDrive(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_encased_chain_drive", p -> new CustomChainDriveBlock((BlockBehaviour.Properties)p, name)).initialProperties(SharedProperties::stone).properties(p -> p.noOcclusion().mapColor(MapColor.PODZOL)).transform(CCStress.setNoImpact())).transform(TagGen.axeOrPickaxe())).blockstate(EncasedBlockStateGens.encasedChainDrive(name)).item().model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(Objects.requireNonNull(EncasedBlockStateGens.createChainDriveModel((RegistrateProvider)p, name, true, "item")))).build()).register();
    }

    public static BlockEntry<CustomChainGearshiftBlock> createChainGearshift(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_adjustable_chain_gearshift", p -> new CustomChainGearshiftBlock((BlockBehaviour.Properties)p, name)).initialProperties(SharedProperties::stone).properties(p -> p.noOcclusion().mapColor(MapColor.NETHER)).transform(CCStress.setNoImpact())).transform(TagGen.axeOrPickaxe())).blockstate(EncasedBlockStateGens.adjustableChainGearshift(name)).item().model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(Objects.requireNonNull(EncasedBlockStateGens.createAdjustableChainGearshiftModel((RegistrateProvider)p, name, true, "item", false)))).build()).register();
    }

    public static BlockEntry<ConfigurableGearboxBlock> createConfigurableGearbox(String name, CTSpriteShiftEntry ct) {
        BlockBuilder entry = (BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_configurable_gearbox", ConfigurableGearboxBlock::new).initialProperties(SharedProperties::stone).properties(BlockBehaviour.Properties::noOcclusion).properties(p -> p.mapColor(MapColor.PODZOL)).transform(CCStress.setNoImpact())).transform(TagGen.axeOrPickaxe())).blockstate(EncasedBlockStateGens.configurableGearbox(name)).item().model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(EncasedBlockStateGens.createConfigurableGearboxItemModel(p, name))).build();
        if (ct != null) {
            entry = (BlockBuilder)((BlockBuilder)entry.onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCTBehaviour(ct)))).onRegister(CreateRegistrate.casingConnectivity((block, cc) -> cc.make((Block)block, ct, (s, f) -> (Boolean)s.getValue((Property)ConfigurableGearboxBlock.getPropertyByDirection(f)) == false)));
        }
        return entry.register();
    }

    public static BlockEntry<PublicChainConveyorBlock> createChainConveyor(String name) {
        return ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block(name + "_chain_conveyor", PublicChainConveyorBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.noOcclusion().mapColor(MapColor.PODZOL)).transform(TagGen.axeOrPickaxe())).transform(CCStress.setImpact(1.0))).blockstate(EncasedBlockStateGens.chainConveyor(name)).item().model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(EncasedBlockStateGens.createConveyorModel((RegistrateProvider)p, name, true))).build()).register();
    }

    private static <T extends Block> BlockBuilder<T, CreateRegistrate> connectedTexture(BlockBuilder<T, CreateRegistrate> entry, CTSpriteShiftEntry sprite, BiConsumer<T, CasingConnectivity> consumer) {
        if (sprite != null) {
            return (BlockBuilder)((BlockBuilder)entry.onRegister(CreateRegistrate.connectedTextures(() -> new EncasedCTBehaviour(sprite)))).onRegister(CreateRegistrate.casingConnectivity(consumer));
        }
        return entry;
    }

    public static void registerEncasedShafts() {
        List<BlockEntry> casings = Arrays.asList(AllBlocks.WEATHERED_IRON_BLOCK, AllBlocks.INDUSTRIAL_IRON_BLOCK, CREATIVE_CASING, AllBlocks.ANDESITE_CASING, AllBlocks.BRASS_CASING, AllBlocks.COPPER_CASING, AllBlocks.RAILWAY_CASING, AllBlocks.REFINED_RADIANCE_CASING, AllBlocks.SHADOW_STEEL_CASING);
        EncasedBlocks.forEachShaft(shaft -> casings.forEach(c -> {
            String casing = c.getId().getPath().replace("_casing", "").replace("_block", "");
            CTSpriteShiftEntry sprite = EncasedSprites.getEntryForCasing(casing);
            EncasedBlocks.createShaft(shaft, casing, () -> ((BlockEntry)c).get(), sprite, (p, s) -> new EncasedCustomShaftBlock((BlockBehaviour.Properties)p, (Supplier<Block>)s, (Supplier<? extends Block>)shaft));
        }));
        EncasedBlocks.forEachCogwheel(cogwheel -> casings.forEach(c -> {
            String casing = c.getId().getPath().replace("_casing", "").replace("_block", "");
            CTSpriteShiftEntry sprite = EncasedSprites.getEntryForCasing(casing);
            CTSpriteShiftEntry sideSprite = EncasedSprites.getEntryForSide(casing);
            CTSpriteShiftEntry otherSideSprite = EncasedSprites.getEntryForOtherSide(casing);
            EncasedBlocks.createCogwheel(cogwheel, casing, () -> ((BlockEntry)c).get(), sprite, sideSprite, otherSideSprite, (p, s) -> new EncasedCustomCogwheelBlock((BlockBehaviour.Properties)p, false, (Supplier<Block>)s, (Supplier<? extends Block>)cogwheel));
        }));
        EncasedBlocks.forEachLargeCogwheel(cogwheel -> casings.forEach(c -> {
            String casing = c.getId().getPath().replace("_casing", "").replace("_block", "");
            CTSpriteShiftEntry sprite = EncasedSprites.getEntryForCasing(casing);
            EncasedBlocks.createLargeCogwheel(cogwheel, casing, () -> ((BlockEntry)c).get(), sprite, (p, s) -> new EncasedCustomCogwheelBlock((BlockBehaviour.Properties)p, true, (Supplier<Block>)s, (Supplier<? extends Block>)cogwheel));
        }));
    }

    public static void register() {
    }

    public static boolean isWoodenShaftHasState(BlockState state) {
        return OAK_SHAFT.has(state) || SPRUCE_SHAFT.has(state) || BIRCH_SHAFT.has(state) || JUNGLE_SHAFT.has(state) || ACACIA_SHAFT.has(state) || DARK_OAK_SHAFT.has(state) || MANGROVE_SHAFT.has(state) || BAMBOO_SHAFT.has(state) || CHERRY_SHAFT.has(state) || CRIMSON_SHAFT.has(state) || WARPED_SHAFT.has(state);
    }

    public static void forEachShaft(Consumer<BlockEntry<? extends ShaftBlock>> action) {
        action.accept(OAK_SHAFT);
        action.accept(BIRCH_SHAFT);
        action.accept(SPRUCE_SHAFT);
        action.accept(JUNGLE_SHAFT);
        action.accept(ACACIA_SHAFT);
        action.accept(DARK_OAK_SHAFT);
        action.accept(MANGROVE_SHAFT);
        action.accept(BAMBOO_SHAFT);
        action.accept(CHERRY_SHAFT);
        action.accept(WARPED_SHAFT);
        action.accept(CRIMSON_SHAFT);
        action.accept(GLASS_SHAFT);
        action.accept(MLDEG_SHAFT);
    }

    public static void forEachCogwheel(Consumer<BlockEntry<? extends WoodenCogwheelBlock>> action) {
        action.accept(OAK_COGWHEEL);
        action.accept(BIRCH_COGWHEEL);
        action.accept(JUNGLE_COGWHEEL);
        action.accept(ACACIA_COGWHEEL);
        action.accept(DARK_OAK_COGWHEEL);
        action.accept(MANGROVE_COGWHEEL);
        action.accept(BAMBOO_COGWHEEL);
        action.accept(CHERRY_COGWHEEL);
        action.accept(WARPED_COGWHEEL);
        action.accept(CRIMSON_COGWHEEL);
    }

    public static void forEachLargeCogwheel(Consumer<BlockEntry<? extends WoodenCogwheelBlock>> action) {
        action.accept(OAK_LARGE_COGWHEEL);
        action.accept(BIRCH_LARGE_COGWHEEL);
        action.accept(JUNGLE_LARGE_COGWHEEL);
        action.accept(ACACIA_LARGE_COGWHEEL);
        action.accept(DARK_OAK_LARGE_COGWHEEL);
        action.accept(MANGROVE_LARGE_COGWHEEL);
        action.accept(BAMBOO_LARGE_COGWHEEL);
        action.accept(CHERRY_LARGE_COGWHEEL);
        action.accept(WARPED_LARGE_COGWHEEL);
        action.accept(CRIMSON_LARGE_COGWHEEL);
    }

    public static boolean isChainConveyor(BlockState state) {
        return AllBlocks.CHAIN_CONVEYOR.has(state) || BRASS_CHAIN_CONVEYOR.has(state) || COPPER_CHAIN_CONVEYOR.has(state) || RAILWAY_CHAIN_CONVEYOR.has(state) || CREATIVE_CHAIN_CONVEYOR.has(state) || INDUSTRIAL_IRON_CHAIN_CONVEYOR.has(state) || WEATHERED_IRON_CHAIN_CONVEYOR.has(state) || REFINED_RADIANCE_CHAIN_CONVEYOR.has(state) || SHADOW_STEEL_CHAIN_CONVEYOR.has(state);
    }

    static {
        CreateCasing.REGISTRATE.setCreativeTab(EncasedCreativeModeTabs.MAIN_TAB);
        BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"createcasing");
        CREATIVE_CASING = EncasedBlocks.createCasing("creative", AllSpriteShifts.CREATIVE_CASING);
        RAILWAY_ENCASED_SHAFT = EncasedBlocks.createShaft("railway", () -> ((BlockEntry)AllBlocks.RAILWAY_CASING).get(), AllSpriteShifts.RAILWAY_CASING);
        COPPER_ENCASED_SHAFT = EncasedBlocks.createShaft("copper", () -> ((BlockEntry)AllBlocks.COPPER_CASING).get(), AllSpriteShifts.COPPER_CASING);
        SHADOW_STEEL_ENCASED_SHAFT = EncasedBlocks.createShaft("shadow_steel", () -> ((BlockEntry)AllBlocks.SHADOW_STEEL_CASING).get(), AllSpriteShifts.SHADOW_STEEL_CASING);
        REFINED_RADIANCE_ENCASED_SHAFT = EncasedBlocks.createShaft("refined_radiance", () -> ((BlockEntry)AllBlocks.REFINED_RADIANCE_CASING).get(), AllSpriteShifts.REFINED_RADIANCE_CASING);
        CREATIVE_ENCASED_SHAFT = EncasedBlocks.createShaft("creative", () -> CREATIVE_CASING.get(), AllSpriteShifts.CREATIVE_CASING);
        INDUSTRIAL_IRON_ENCASED_SHAFT = EncasedBlocks.createShaft("industrial_iron", () -> ((BlockEntry)AllBlocks.INDUSTRIAL_IRON_BLOCK).get(), null);
        WEATHERED_IRON_ENCASED_SHAFT = EncasedBlocks.createShaft("weathered_iron", () -> ((BlockEntry)AllBlocks.WEATHERED_IRON_BLOCK).get(), null);
        RAILWAY_ENCASED_COGWHEEL = EncasedBlocks.createCogwheel("railway", () -> ((BlockEntry)AllBlocks.RAILWAY_CASING).get(), AllSpriteShifts.RAILWAY_CASING, EncasedSprites.RAILWAY_ENCASED_COGWHEEL_SIDE, EncasedSprites.RAILWAY_ENCASED_COGWHEEL_OTHERSIDE);
        COPPER_ENCASED_COGWHEEL = EncasedBlocks.createCogwheel("copper", () -> ((BlockEntry)AllBlocks.COPPER_CASING).get(), AllSpriteShifts.COPPER_CASING, EncasedSprites.COPPER_ENCASED_COGWHEEL_SIDE, EncasedSprites.COPPER_ENCASED_COGWHEEL_OTHERSIDE);
        SHADOW_STEEL_ENCASED_COGWHEEL = EncasedBlocks.createCogwheel("shadow_steel", () -> ((BlockEntry)AllBlocks.SHADOW_STEEL_CASING).get(), AllSpriteShifts.SHADOW_STEEL_CASING, EncasedSprites.SHADOW_STEEL_ENCASED_COGWHEEL_SIDE, EncasedSprites.SHADOW_STEEL_ENCASED_COGWHEEL_OTHERSIDE);
        REFINED_RADIANCE_ENCASED_COGWHEEL = EncasedBlocks.createCogwheel("refined_radiance", () -> ((BlockEntry)AllBlocks.REFINED_RADIANCE_CASING).get(), AllSpriteShifts.REFINED_RADIANCE_CASING, EncasedSprites.REFINED_RADIANCE_ENCASED_COGWHEEL_SIDE, EncasedSprites.REFINED_RADIANCE_ENCASED_COGWHEEL_OTHERSIDE);
        CREATIVE_ENCASED_COGWHEEL = EncasedBlocks.createCogwheel("creative", () -> CREATIVE_CASING.get(), AllSpriteShifts.CREATIVE_CASING, EncasedSprites.CREATIVE_ENCASED_COGWHEEL_SIDE, EncasedSprites.CREATIVE_ENCASED_COGWHEEL_OTHERSIDE);
        INDUSTRIAL_IRON_ENCASED_COGWHEEL = EncasedBlocks.createCogwheel("industrial_iron", () -> ((BlockEntry)AllBlocks.INDUSTRIAL_IRON_BLOCK).get(), null, null, null);
        WEATHERED_IRON_ENCASED_COGWHEEL = EncasedBlocks.createCogwheel("weathered_iron", () -> ((BlockEntry)AllBlocks.WEATHERED_IRON_BLOCK).get(), null, null, null);
        RAILWAY_ENCASED_COGWHEEL_LARGE = EncasedBlocks.createLargeCogwheel("railway", () -> ((BlockEntry)AllBlocks.RAILWAY_CASING).get(), AllSpriteShifts.RAILWAY_CASING);
        COPPER_ENCASED_COGWHEEL_LARGE = EncasedBlocks.createLargeCogwheel("copper", () -> ((BlockEntry)AllBlocks.COPPER_CASING).get(), AllSpriteShifts.COPPER_CASING);
        SHADOW_STEEL_ENCASED_COGWHEEL_LARGE = EncasedBlocks.createLargeCogwheel("shadow_steel", () -> ((BlockEntry)AllBlocks.SHADOW_STEEL_CASING).get(), AllSpriteShifts.SHADOW_STEEL_CASING);
        REFINED_RADIANCE_ENCASED_COGWHEEL_LARGE = EncasedBlocks.createLargeCogwheel("refined_radiance", () -> ((BlockEntry)AllBlocks.REFINED_RADIANCE_CASING).get(), AllSpriteShifts.REFINED_RADIANCE_CASING);
        CREATIVE_ENCASED_COGWHEEL_LARGE = EncasedBlocks.createLargeCogwheel("creative", () -> CREATIVE_CASING.get(), AllSpriteShifts.CREATIVE_CASING);
        INDUSTRIAL_IRON_ENCASED_COGWHEEL_LARGE = EncasedBlocks.createLargeCogwheel("industrial_iron", () -> ((BlockEntry)AllBlocks.INDUSTRIAL_IRON_BLOCK).get(), null);
        WEATHERED_IRON_ENCASED_COGWHEEL_LARGE = EncasedBlocks.createLargeCogwheel("weathered_iron", () -> ((BlockEntry)AllBlocks.WEATHERED_IRON_BLOCK).get(), null);
        ENCASED_ANDESITE_FLUID_PIPE = EncasedBlocks.createPipe("andesite", () -> ((BlockEntry)AllBlocks.ANDESITE_CASING).get(), AllSpriteShifts.ANDESITE_CASING);
        ENCASED_BRASS_FLUID_PIPE = EncasedBlocks.createPipe("brass", () -> ((BlockEntry)AllBlocks.BRASS_CASING).get(), AllSpriteShifts.BRASS_CASING);
        ENCASED_RAILWAY_FLUID_PIPE = EncasedBlocks.createPipe("railway", () -> ((BlockEntry)AllBlocks.RAILWAY_CASING).get(), AllSpriteShifts.RAILWAY_CASING);
        ENCASED_SHADOW_STEEL_FLUID_PIPE = EncasedBlocks.createPipe("shadow_steel", () -> ((BlockEntry)AllBlocks.SHADOW_STEEL_CASING).get(), AllSpriteShifts.SHADOW_STEEL_CASING);
        ENCASED_REFINED_RADIANCE_FLUID_PIPE = EncasedBlocks.createPipe("refined_radiance", () -> ((BlockEntry)AllBlocks.REFINED_RADIANCE_CASING).get(), AllSpriteShifts.REFINED_RADIANCE_CASING);
        ENCASED_CREATIVE_FLUID_PIPE = EncasedBlocks.createPipe("creative", () -> CREATIVE_CASING.get(), AllSpriteShifts.CREATIVE_CASING);
        ENCASED_INDUSTRIAL_IRON_FLUID_PIPE = EncasedBlocks.createPipe("industrial_iron", () -> ((BlockEntry)AllBlocks.INDUSTRIAL_IRON_BLOCK).get(), null);
        ENCASED_WEATHERED_IRON_FLUID_PIPE = EncasedBlocks.createPipe("weathered_iron", () -> ((BlockEntry)AllBlocks.WEATHERED_IRON_BLOCK).get(), null);
        BRASS_GEARBOX = EncasedBlocks.createGearbox("brass", AllSpriteShifts.BRASS_CASING, EncasedItems.VERTICAL_BRASS_GEARBOX);
        COPPER_GEARBOX = EncasedBlocks.createGearbox("copper", AllSpriteShifts.COPPER_CASING, EncasedItems.VERTICAL_COPPER_GEARBOX);
        RAILWAY_GEARBOX = EncasedBlocks.createGearbox("railway", AllSpriteShifts.RAILWAY_CASING, EncasedItems.VERTICAL_RAILWAY_GEARBOX);
        CREATIVE_GEARBOX = EncasedBlocks.createGearbox("creative", AllSpriteShifts.CREATIVE_CASING, EncasedItems.VERTICAL_CREATIVE_GEARBOX);
        INDUSTRIAL_IRON_GEARBOX = EncasedBlocks.createGearbox("industrial_iron", null, EncasedItems.VERTICAL_INDUSTRIAL_IRON_GEARBOX);
        WEATHERED_IRON_GEARBOX = EncasedBlocks.createGearbox("weathered_iron", null, EncasedItems.VERTICAL_WEATHERED_IRON_GEARBOX);
        REFINED_RADIANCE_GEARBOX = EncasedBlocks.createGearbox("refined_radiance", AllSpriteShifts.REFINED_RADIANCE_CASING, EncasedItems.VERTICAL_REFINED_RADIANCE_GEARBOX);
        SHADOW_STEEL_GEARBOX = EncasedBlocks.createGearbox("shadow_steel", AllSpriteShifts.SHADOW_STEEL_CASING, EncasedItems.VERTICAL_SHADOW_STEEL_GEARBOX);
        BRASS_MIXER = EncasedBlocks.createMixer("brass");
        COPPER_MIXER = EncasedBlocks.createMixer("copper");
        RAILWAY_MIXER = EncasedBlocks.createMixer("railway");
        CREATIVE_MIXER = EncasedBlocks.createMixer("creative");
        INDUSTRIAL_IRON_MIXER = EncasedBlocks.createMixer("industrial_iron");
        WEATHERED_IRON_MIXER = EncasedBlocks.createMixer("weathered_iron");
        REFINED_RADIANCE_MIXER = EncasedBlocks.createMixer("refined_radiance");
        SHADOW_STEEL_MIXER = EncasedBlocks.createMixer("shadow_steel");
        BRASS_PRESS = EncasedBlocks.createPress("brass");
        COPPER_PRESS = EncasedBlocks.createPress("copper");
        RAILWAY_PRESS = EncasedBlocks.createPress("railway");
        CREATIVE_PRESS = EncasedBlocks.createPress("creative");
        INDUSTRIAL_IRON_PRESS = EncasedBlocks.createPress("industrial_iron");
        WEATHERED_IRON_PRESS = EncasedBlocks.createPress("weathered_iron");
        REFINED_RADIANCE_PRESS = EncasedBlocks.createPress("refined_radiance");
        SHADOW_STEEL_PRESS = EncasedBlocks.createPress("shadow_steel");
        BRASS_DEPOT = EncasedBlocks.createDepot("brass");
        COPPER_DEPOT = EncasedBlocks.createDepot("copper");
        RAILWAY_DEPOT = EncasedBlocks.createDepot("railway");
        CREATIVE_DEPOT = EncasedBlocks.createDepot("creative");
        INDUSTRIAL_IRON_DEPOT = EncasedBlocks.createDepot("industrial_iron");
        WEATHERED_IRON_DEPOT = EncasedBlocks.createDepot("weathered_iron");
        REFINED_RADIANCE_DEPOT = EncasedBlocks.createDepot("refined_radiance");
        SHADOW_STEEL_DEPOT = EncasedBlocks.createDepot("shadow_steel");
        BRASS_CHAIN_DRIVE = EncasedBlocks.createDrive("brass");
        COPPER_CHAIN_DRIVE = EncasedBlocks.createDrive("copper");
        RAILWAY_CHAIN_DRIVE = EncasedBlocks.createDrive("railway");
        CREATIVE_CHAIN_DRIVE = EncasedBlocks.createDrive("creative");
        INDUSTRIAL_IRON_CHAIN_DRIVE = EncasedBlocks.createDrive("industrial_iron");
        WEATHERED_IRON_CHAIN_DRIVE = EncasedBlocks.createDrive("weathered_iron");
        REFINED_RADIANCE_CHAIN_DRIVE = EncasedBlocks.createDrive("refined_radiance");
        SHADOW_STEEL_CHAIN_DRIVE = EncasedBlocks.createDrive("shadow_steel");
        BRASS_CHAIN_GEARSHIFT = EncasedBlocks.createChainGearshift("brass");
        COPPER_CHAIN_GEARSHIFT = EncasedBlocks.createChainGearshift("copper");
        RAILWAY_CHAIN_GEARSHIFT = EncasedBlocks.createChainGearshift("railway");
        CREATIVE_CHAIN_GEARSHIFT = EncasedBlocks.createChainGearshift("creative");
        INDUSTRIAL_IRON_CHAIN_GEARSHIFT = EncasedBlocks.createChainGearshift("industrial_iron");
        WEATHERED_IRON_CHAIN_GEARSHIFT = EncasedBlocks.createChainGearshift("weathered_iron");
        REFINED_RADIANCE_CHAIN_GEARSHIFT = EncasedBlocks.createChainGearshift("refined_radiance");
        SHADOW_STEEL_CHAIN_GEARSHIFT = EncasedBlocks.createChainGearshift("shadow_steel");
        ANDESITE_CONFIGURABLE_GEARBOX = EncasedBlocks.createConfigurableGearbox("andesite", AllSpriteShifts.ANDESITE_CASING);
        BRASS_CONFIGURABLE_GEARBOX = EncasedBlocks.createConfigurableGearbox("brass", AllSpriteShifts.BRASS_CASING);
        COPPER_CONFIGURABLE_GEARBOX = EncasedBlocks.createConfigurableGearbox("copper", AllSpriteShifts.COPPER_CASING);
        RAILWAY_CONFIGURABLE_GEARBOX = EncasedBlocks.createConfigurableGearbox("railway", AllSpriteShifts.RAILWAY_CASING);
        CREATIVE_CONFIGURABLE_GEARBOX = EncasedBlocks.createConfigurableGearbox("creative", AllSpriteShifts.CREATIVE_CASING);
        INDUSTRIAL_IRON_CONFIGURABLE_GEARBOX = EncasedBlocks.createConfigurableGearbox("industrial_iron", null);
        WEATHERED_IRON_CONFIGURABLE_GEARBOX = EncasedBlocks.createConfigurableGearbox("weathered_iron", null);
        REFINED_RADIANCE_CONFIGURABLE_GEARBOX = EncasedBlocks.createConfigurableGearbox("refined_radiance", AllSpriteShifts.REFINED_RADIANCE_CASING);
        SHADOW_STEEL_CONFIGURABLE_GEARBOX = EncasedBlocks.createConfigurableGearbox("shadow_steel", AllSpriteShifts.SHADOW_STEEL_CASING);
        BRASS_CHAIN_CONVEYOR = EncasedBlocks.createChainConveyor("brass");
        COPPER_CHAIN_CONVEYOR = EncasedBlocks.createChainConveyor("copper");
        RAILWAY_CHAIN_CONVEYOR = EncasedBlocks.createChainConveyor("railway");
        CREATIVE_CHAIN_CONVEYOR = EncasedBlocks.createChainConveyor("creative");
        INDUSTRIAL_IRON_CHAIN_CONVEYOR = EncasedBlocks.createChainConveyor("industrial_iron");
        WEATHERED_IRON_CHAIN_CONVEYOR = EncasedBlocks.createChainConveyor("weathered_iron");
        REFINED_RADIANCE_CHAIN_CONVEYOR = EncasedBlocks.createChainConveyor("refined_radiance");
        SHADOW_STEEL_CHAIN_CONVEYOR = EncasedBlocks.createChainConveyor("shadow_steel");
        OAK_SHAFT = EncasedBlocks.createWoodenShaft("oak");
        SPRUCE_SHAFT = EncasedBlocks.createWoodenShaft("spruce");
        BIRCH_SHAFT = EncasedBlocks.createWoodenShaft("birch");
        JUNGLE_SHAFT = EncasedBlocks.createWoodenShaft("jungle");
        ACACIA_SHAFT = EncasedBlocks.createWoodenShaft("acacia");
        DARK_OAK_SHAFT = EncasedBlocks.createWoodenShaft("dark_oak");
        MANGROVE_SHAFT = EncasedBlocks.createWoodenShaft("mangrove");
        CHERRY_SHAFT = EncasedBlocks.createWoodenShaft("cherry");
        BAMBOO_SHAFT = EncasedBlocks.createWoodenShaft("bamboo");
        CRIMSON_SHAFT = EncasedBlocks.createWoodenShaft("crimson");
        WARPED_SHAFT = EncasedBlocks.createWoodenShaft("warped");
        OAK_COGWHEEL = EncasedBlocks.createWoodenCogwheel("oak");
        BIRCH_COGWHEEL = EncasedBlocks.createWoodenCogwheel("birch");
        JUNGLE_COGWHEEL = EncasedBlocks.createWoodenCogwheel("jungle");
        ACACIA_COGWHEEL = EncasedBlocks.createWoodenCogwheel("acacia");
        DARK_OAK_COGWHEEL = EncasedBlocks.createWoodenCogwheel("dark_oak");
        MANGROVE_COGWHEEL = EncasedBlocks.createWoodenCogwheel("mangrove");
        CHERRY_COGWHEEL = EncasedBlocks.createWoodenCogwheel("cherry");
        BAMBOO_COGWHEEL = EncasedBlocks.createWoodenCogwheel("bamboo");
        CRIMSON_COGWHEEL = EncasedBlocks.createWoodenCogwheel("crimson");
        WARPED_COGWHEEL = EncasedBlocks.createWoodenCogwheel("warped");
        OAK_LARGE_COGWHEEL = EncasedBlocks.createLargeWoodenCogwheel("oak");
        BIRCH_LARGE_COGWHEEL = EncasedBlocks.createLargeWoodenCogwheel("birch");
        JUNGLE_LARGE_COGWHEEL = EncasedBlocks.createLargeWoodenCogwheel("jungle");
        ACACIA_LARGE_COGWHEEL = EncasedBlocks.createLargeWoodenCogwheel("acacia");
        DARK_OAK_LARGE_COGWHEEL = EncasedBlocks.createLargeWoodenCogwheel("dark_oak");
        MANGROVE_LARGE_COGWHEEL = EncasedBlocks.createLargeWoodenCogwheel("mangrove");
        CHERRY_LARGE_COGWHEEL = EncasedBlocks.createLargeWoodenCogwheel("cherry");
        BAMBOO_LARGE_COGWHEEL = EncasedBlocks.createLargeWoodenCogwheel("bamboo");
        CRIMSON_LARGE_COGWHEEL = EncasedBlocks.createLargeWoodenCogwheel("crimson");
        WARPED_LARGE_COGWHEEL = EncasedBlocks.createLargeWoodenCogwheel("warped");
        GLASS_SHAFT = ((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block("glass_shaft", GlassShaftBlock::new).initialProperties(() -> Blocks.GLASS).properties(p -> p.mapColor(MapColor.NONE).sound(SoundType.GLASS).noOcclusion()).transform(CCStress.setNoImpact())).blockstate(EncasedBlockStateGens.shaft("glass")).onRegister(CreateRegistrate.blockModel(() -> BracketedKineticBlockModel::new))).item().model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(Objects.requireNonNull(EncasedBlockStateGens.shaftModel((RegistrateProvider)p, "glass")))).build()).register();
        BRASS_SHAFT = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block("brass_shaft", BrassShaftBlock::new).initialProperties(SharedProperties::softMetal).properties(p -> p.mapColor(MapColor.METAL)).transform(CCStress.setNoImpact())).transform(TagGen.pickaxeOnly())).blockstate(EncasedBlockStateGens.shaft("brass")).onRegister(CreateRegistrate.blockModel(() -> BracketedKineticBlockModel::new))).item().model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(Objects.requireNonNull(EncasedBlockStateGens.shaftModel((RegistrateProvider)p, "brass")))).build()).register();
        MLDEG_SHAFT = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block("mldeg_shaft", MetalShaftBlock::new).initialProperties(() -> Blocks.BLACKSTONE).properties(p -> p.mapColor(MapColor.NONE).sound(SoundType.STONE).noOcclusion()).transform(CCStress.setNoImpact())).blockstate(EncasedBlockStateGens.shaft("mldeg")).onRegister(CreateRegistrate.blockModel(() -> BracketedKineticBlockModel::new))).onRegisterAfter(Registries.ITEM, CreateCasing::hideItem)).item().model((c, p) -> ((ItemModelBuilder)p.getBuilder(c.getName())).parent(Objects.requireNonNull(EncasedBlockStateGens.shaftModel((RegistrateProvider)p, "mldeg")))).build()).register();
        CREATIVE_COGWHEEL = ((BlockBuilder)((BlockBuilder)((BlockBuilder)((BlockBuilder)CreateCasing.REGISTRATE.block("creative_cogwheel", CreativeCogwheelBlock::new).initialProperties(SharedProperties::stone).properties(p -> p.mapColor(MapColor.COLOR_PURPLE)).properties(BlockBehaviour.Properties::noOcclusion).tag(new TagKey[]{AllTags.AllBlockTags.SAFE_NBT.tag}).transform(TagGen.pickaxeOnly())).blockstate((c, p) -> EncasedBlockStateGens.axisBlock(c, p, (Function<BlockState, ModelFile>)((Function)b -> new ModelFile.UncheckedModelFile(CreateCasing.asResource("block/creative_cogwheel/block"))), false)).transform(CCStress.setCapacity(16384.0))).onRegister(BlockStressValues.setGeneratorSpeed((int)256, (boolean)true))).addLayer(() -> RenderType::cutoutMipped).item().properties(p -> p.rarity(Rarity.EPIC)).transform(ModelGen.customItemModel())).register();
    }
}

