/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.drippyloadingscreen.customization.backgrounds.color;

import de.keksuccino.drippyloadingscreen.customization.backgrounds.color.ColorMenuBackground;
import de.keksuccino.drippyloadingscreen.customization.backgrounds.color.ColorMenuBackgroundConfigScreen;
import de.keksuccino.fancymenu.customization.background.MenuBackgroundBuilder;
import de.keksuccino.fancymenu.customization.background.SerializedMenuBackground;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorMenuBackgroundBuilder
extends MenuBackgroundBuilder<ColorMenuBackground> {
    public ColorMenuBackgroundBuilder() {
        super("drippy_color_background");
    }

    public void buildNewOrEditInstance(Screen currentScreen, @Nullable ColorMenuBackground backgroundToEdit, @NotNull Consumer<ColorMenuBackground> backgroundConsumer) {
        ColorMenuBackground back;
        ColorMenuBackground colorMenuBackground = back = backgroundToEdit != null ? (ColorMenuBackground)backgroundToEdit.copy() : null;
        if (back == null) {
            back = new ColorMenuBackground(this);
        }
        ColorMenuBackgroundConfigScreen s = new ColorMenuBackgroundConfigScreen(back, background -> {
            if (background != null) {
                backgroundConsumer.accept((ColorMenuBackground)((Object)background));
            } else {
                backgroundConsumer.accept(backgroundToEdit);
            }
            Minecraft.getInstance().setScreen(currentScreen);
        });
        Minecraft.getInstance().setScreen((Screen)s);
    }

    public ColorMenuBackground deserializeBackground(SerializedMenuBackground serializedMenuBackground) {
        ColorMenuBackground b = new ColorMenuBackground(this);
        String hex = serializedMenuBackground.getValue("color");
        if (hex != null) {
            b.color = DrawableColor.of((String)hex);
        }
        return b;
    }

    public SerializedMenuBackground serializedBackground(ColorMenuBackground background) {
        SerializedMenuBackground serialized = new SerializedMenuBackground();
        serialized.putProperty("color", background.color.getHex());
        return serialized;
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"drippyloadingscreen.background.color");
    }

    @Nullable
    public Component[] getDescription() {
        return LocalizationUtils.splitLocalizedLines((String)"drippyloadingscreen.background.color.desc", (String[])new String[0]);
    }
}

