ServerEvents.recipes(event => {

    event.shapeless('bigreactors:inanite_block', ['9x bigreactors:inanite_ingot']).id('techopolis:inanite_block_from_ingot')
    event.shapeless('9x bigreactors:inanite_ingot', ['bigreactors:inanite_block']).id('techopolis:inanite_ingot_from_block')
    event.shapeless('bigreactors:ridiculite_block', ['9x bigreactors:ridiculite_ingot']).id('techopolis:ridiculite_block_from_ingot')
    event.shapeless('9x bigreactors:ridiculite_ingot', ['bigreactors:ridiculite_block']).id('techopolis:ridiculite_ingot_from_block')
    event.shapeless('bigreactors:ludicrite_block', ['9x bigreactors:ludicrite_ingot']).id('techopolis:ludicrite_block_from_ingot')
    event.shapeless('9x bigreactors:ludicrite_ingot', ['bigreactors:ludicrite_block']).id('techopolis:ludicrite_ingot_from_block')
    event.shapeless('bigreactors:insanite_block', ['9x bigreactors:insanite_ingot']).id('techopolis:insanite_block_from_ingot')
    event.shapeless('9x bigreactors:insanite_ingot', ['bigreactors:insanite_block']).id('techopolis:insanite_ingot_from_block')

    event.remove({id: 'bigreactors:turbine/ridiculite_block'})
    event.remove({id: 'bigreactors:turbine/inanite_block'})
    event.remove({id: 'bigreactors:turbine/insanite_block'})
    event.remove({id: 'bigreactors:turbine/ludicrite_block'})

    event.replaceInput({id:'bigreactors:energizer/energizercell'}, 'bigreactors:benitoite_crystal', 'techopolis:ultimate_technium_nugget')

    //Extreme Reactors - Fluid
    function createMobEssenceRecipes(input, outputAmount) {

        event.custom({
            "type": "bigreactors:fluidizersolid",
            "ingredient": {
                "count": 1,
                "ingredient": {
                "type": "neoforge:components",
                "components": {
                    "minecraft:attribute_modifiers": {
                    "modifiers": []
                    },
                    "minecraft:enchantments": {
                    "levels": {}
                    },
                    "minecraft:lore": [],
                    "minecraft:max_stack_size": 64,
                    "minecraft:rarity": "common",
                    "minecraft:repair_cost": 0
                },
                "items": input,
                "strict": true
                }
            },
            "result": {
                "amount": outputAmount,
                "id": "techopolis:molten_mob_essence"
            }
        })
    }

    createMobEssenceRecipes("minecraft:rotten_flesh", 100)
    createMobEssenceRecipes("minecraft:bone", 120)
    createMobEssenceRecipes("minecraft:spider_eye", 120)
    createMobEssenceRecipes("minecraft:gunpowder", 60)
    createMobEssenceRecipes("minecraft:ender_pearl", 200)
    createMobEssenceRecipes("hostilenetworks:overworld_prediction", 500)
    createMobEssenceRecipes("hostilenetworks:nether_prediction", 1000)
    createMobEssenceRecipes("techopolis:alien_prediction", 2500)
    createMobEssenceRecipes("hostilenetworks:end_prediction", 5000)


    //
    event.custom({
        "type": "bigreactors:fluidizersolid",
        "ingredient": {
          "count": 1,
          "ingredient": {
            "type": "neoforge:components",
            "components": {
              "minecraft:attribute_modifiers": {
                "modifiers": []
              },
              "minecraft:enchantments": {
                "levels": {}
              },
              "minecraft:lore": [],
              "minecraft:max_stack_size": 64,
              "minecraft:rarity": "common",
              "minecraft:repair_cost": 0
            },
            "items": "alltheores:uranium_ingot",
            "strict": true
          }
        },
        "result": {
          "amount": 90,
          "id": "casting:molten_uranium"
        }
    }).id('bigreactors:fluidizer/solid/yellorium')

    event.custom({
        "type": "bigreactors:fluidizersolid",
        "ingredient": {
          "count": 1,
          "ingredient": {
            "type": "neoforge:components",
            "components": {
              "minecraft:attribute_modifiers": {
                "modifiers": []
              },
              "minecraft:enchantments": {
                "levels": {}
              },
              "minecraft:lore": [],
              "minecraft:max_stack_size": 64,
              "minecraft:rarity": "common",
              "minecraft:repair_cost": 0
            },
            "items": "alltheores:uranium_block",
            "strict": true
          }
        },
        "result": {
          "amount": 810,
          "id": "casting:molten_uranium"
        }
    }).id('bigreactors:fluidizer/solid/yellorium9')

    event.custom({
        "type": "bigreactors:fluidizerfluidmixing",
        "ingredient1": {
          "amount": 180,
          "id": "casting:molten_uranium"
        },
        "ingredient2": {
          "amount": 1000,
          "id": "bigreactors:blutonium"
        },
        "result": {
          "amount": 2000,
          "id": "bigreactors:verderium"
        }
    }).id('bigreactors:fluidizer/fluidmixing/verderium_1')

    event.custom({
        "type": "bigreactors:fluidizerfluidmixing",
        "ingredient1": {
          "amount": 1000,
          "id": "bigreactors:blutonium"
        },
        "ingredient2": {
          "amount": 180,
          "id": "casting:molten_uranium"
        },
        "result": {
          "amount": 2000,
          "id": "bigreactors:verderium"
        }
    }).id('bigreactors:fluidizer/fluidmixing/verderium_2')

    event.custom({
      "type": "bigreactors:fluidizersolid",
      "ingredient": {
        "count": 1,
        "ingredient": {
          "type": "neoforge:components",
          "components": {
            "minecraft:attribute_modifiers": {
              "modifiers": []
            },
            "minecraft:enchantments": {
              "levels": {}
            },
            "minecraft:lore": [],
            "minecraft:max_stack_size": 64,
            "minecraft:rarity": "common",
            "minecraft:repair_cost": 0
          },
          "items": "techopolis:unstable_matter",
          "strict": true
        }
      },
      "result": {
        "amount": 16000,
        "id": "techopolis:liquid_matter"
      }
  }).id('techopolis:fluidizer/liquid_matter')


})