ServerEvents.recipes(event => {

    //Mekanism - Processing
    function createOreProcessing(type) {

        //Dimensional Ore Processing
        event.recipes.mekanism.dissolution(`2000x techopolis:dirty_${type}_slurry`, `techopolis:dimensional_${type}_ore`, `1x mekanism:sulfuric_acid`, true).id(`techopolis:processing/dirt_${type}_slurry`)
        event.recipes.mekanism.washing(`1x techopolis:clean_${type}_slurry`, `5x strainers:purifying_water`, `1x techopolis:dirty_${type}_slurry`).id(`techopolis:processing/clean_${type}_slurry`)
        event.recipes.mekanism.crystallizing(`1x techopolis:${type}_crystal`, `200x techopolis:clean_${type}_slurry`).id(`techopolis:processing/${type}_crystal`)
        event.recipes.mekanism.injecting(`1x techopolis:${type}_shard`, `techopolis:${type}_crystal`, `1x mekanism:hydrogen_chloride`, true).id(`techopolis:processing/${type}_shard`)
        event.recipes.mekanism.purifying(`1x techopolis:${type}_clump`, `techopolis:${type}_shard`, `1x mekanism:oxygen`, true).id(`techopolis:processing/${type}_clump`)
        event.recipes.mekanism.crushing(`1x techopolis:dirty_${type}_dust`, `techopolis:${type}_clump`).id(`techopolis:processing/dirty_${type}_dust`)
        event.recipes.mekanism.enriching(`1x techopolis:${type}_dust`, `techopolis:dirty_${type}_dust`).id(`techopolis:processing/${type}_dust`)
    

        event.remove({id: `mekanism:processing/${type}/shard/from_crystal`})
        event.remove({id: `mekanism:processing/${type}/slurry/dirty/from_ore`})
        event.remove({id: `mekanism:processing/${type}/slurry/clean`})
        event.remove({id: `mekanism:processing/${type}/from_ore`})
        event.remove({id: `mekanism:processing/${type}/ore/from_raw`})
        event.remove({id: `mekanism:processing/${type}/from_raw`})
        event.remove({id: `mekanism:processing/${type}/ore/deepslate_from_raw`})
        event.remove({id: `mekanism:processing/${type}/to_deepslate_ore`})
        event.remove({id: `mekanism:processing/${type}/to_ore`})
        event.remove({id: `mekanism:processing/${type}/slurry/dirty/from_raw_ore`})

        event.remove({id: `alltheores:processing/${type}/clump/from_ore`})
        event.remove({id: `alltheores:processing/${type}/dust/from_ore`})
        event.remove({id: `alltheores:processing/${type}/shard/from_ore`})
        event.remove({id: `alltheores:processing/${type}/shard/from_crystal`})
        event.remove({id: `alltheores:processing/${type}/slurry/dirty/from_ore`})
        event.remove({id: `alltheores:processing/${type}/slurry/from_dirty`})
        event.remove({id: `alltheores:processing/${type}/clump/from_shard`})
        event.remove({id: `alltheores:processing/${type}/dirty_dust/from_clump`})
        event.remove({id: `alltheores:processing/${type}/dust/from_dirty_dust`})
        event.remove({id: `alltheores:arcfurnace/${type}/from_raw_block`})
        event.remove({id: `alltheores:arcfurnace/${type}/crystal/from_slurry`})
        event.remove({id: `alltheores:processing/${type}/slurry/dirty/from_raw`})
        event.remove({id: `alltheores:processing/${type}/crystal/from_slurry`})

        event.remove({id: `immersiveengineering:arcfurnace/ore_${type}`})
        event.remove({id: `immersiveengineering:arcfurnace/raw_ore_${type}`})
        event.remove({id: `immersiveengineering:arcfurnace/raw_block_${type}`})

        //Crusher - Raw Ores to Dust
        event.custom({"neoforge:conditions": [{"type": "neoforge:not","value": {"type": "neoforge:tag_empty","tag": `c:raw_materials/${type}`}}],
            type: "immersiveengineering:crusher", energy: 6000, input: {tag: `c:raw_materials/${type}`},"result": {"item": `techopolis:${type}_dust`},
            "secondaries": [{"chance": 0.66666667,"output": {"item": `techopolis:${type}_dust`}}]})

        //Crusher - Ingots to Dust
        event.custom({"neoforge:conditions": [{"type": "neoforge:not","value": {"type": "neoforge:tag_empty","tag": `c:ingots/${type}`}}],
            type: "immersiveengineering:crusher", energy: 6000, input: {tag: `c:ingots/${type}`},"result": {"item": `techopolis:${type}_dust`}})

        //Crusher - Gems to Dust
        event.custom({"neoforge:conditions": [{"type": "neoforge:not","value": {"type": "neoforge:tag_empty","tag": `c:gems/${type}`}}],
            type: "immersiveengineering:crusher", energy: 6000, input: {tag: `c:gems/${type}`},"result": {"item": `techopolis:${type}_dust`}})



    }

    createOreProcessing('coal')
    createOreProcessing('iron')
    createOreProcessing('gold')
    createOreProcessing('copper')
    createOreProcessing('tin')
    createOreProcessing('diamond')
    createOreProcessing('emerald')
    createOreProcessing('redstone')
    createOreProcessing('lapis')
    createOreProcessing('aluminum')
    createOreProcessing('lead')
    createOreProcessing('nickel')
    createOreProcessing('osmium')
    createOreProcessing('platinum')
    createOreProcessing('silver')
    createOreProcessing('uranium')
    createOreProcessing('zinc')
    createOreProcessing('ender')
    createOreProcessing('replica')
    createOreProcessing('black_quartz')
    createOreProcessing('quartz')
    createOreProcessing('cheesium')
    createOreProcessing('ostrum')
    createOreProcessing('desh')
    createOreProcessing('neptunium')
    createOreProcessing('iridium')
    createOreProcessing('anglesite')
    
    //Enricher - Redstone Dust
    event.recipes.mekanism.enriching(`1x minecraft:redstone`, `techopolis:dirty_redstone_dust`).id(`techopolis:processing/enriching/redstone_dust`)

    //Crushing Coal Dust
    event.custom({type: "immersiveengineering:crusher", energy: 6000, input: {item: "minecraft:coal"},"result": {"item": `techopolis:coal_dust`}}).id("techopolis:ie/crusher/coal_dust")

    //Crushing Cobblestone
    event.custom({type: "immersiveengineering:crusher", energy: 2000, input: {item: "minecraft:cobblestone"},"result": {"item": "minecraft:gravel"}}).id("techopolis:ie/crusher/gravel")

    //Crushing Simulation Pearl
    event.custom({type: "immersiveengineering:crusher", energy: 2000, input: {item: "techopolis:simulation_pearl"},"result": {"item": "techopolis:replica_dust"}}).id("techopolis:ie/crusher/replica_dust")
    event.recipes.mekanism.crushing("techopolis:replica_dust", "techopolis:simulation_pearl").id("techopolis:mek/crusher/replica_dust")

    //Crushing Blazing Sawdust
    event.custom({type: "immersiveengineering:crusher", energy: 2000, input: {item: "techopolis:lava_planks"},"result": {"item": "techopolis:blazing_sawdust"}}).id("techopolis:ie/crusher/blazing_sawdust")
    event.recipes.mekanism.crushing("techopolis:blazing_sawdust", "techopolis:lava_planks").id("techopolis:mek/crusher/blazing_sawdust")

    //Moon Cobblestone
    event.custom({type: "immersiveengineering:crusher", energy: 2000, input: {item: "stellaris:moon_stone"},"result": {"item": "stellaris:moon_cobblestone"}}).id("techopolis:ie/crusher/moon_cobblestone")
    event.recipes.mekanism.crushing("stellaris:moon_cobblestone", "stellaris:moon_stone").id("techopolis:mek/crusher/moon_stone")

    //Crushing Gravel
    event.custom({type: "immersiveengineering:crusher", energy: 2000, input: {item: "minecraft:gravel"},"result": {"item": "minecraft:sand"}}).id("techopolis:ie/crusher/sand")

    //Crushing Coke Coal
    event.custom({type: "immersiveengineering:crusher", energy: 2000, input: {item: "immersiveengineering:coal_coke"},"result": {"item": "immersiveengineering:dust_coke"}}).id("techopolis:ie/crusher/dust_coke")
    event.recipes.mekanism.crushing("immersiveengineering:dust_coke", "immersiveengineering:coal_coke").id("techopolis:mek/crusher/dust_coke")

    //Crushing Super Empowered Crystals
    event.custom({type: "immersiveengineering:crusher", energy: 2000, input: {item: "techopolis:super_empowered_crystal"},"result": {"item": "minecraft:amethyst_shard"}}).id("techopolis:ie/crusher/amethyst_shard")
    event.recipes.mekanism.crushing("minecraft:amethyst_shard", "techopolis:super_empowered_crystal").id("techopolis:mek/crusher/amethyst_shard")

    //Cyanite Plate
    event.custom({"type": "immersiveengineering:metal_press","energy": 2400,"input": {"tag": "c:ingots/cyanite"},
        "mold": "casting:plate_mold","result": {"item": "techopolis:cyanite_plate"}}).id("techopolis:ie/metal_press/plate_cyanite")
    event.remove(`immersiveengineering:metalpress/plate_cyanite`)

    //Neptunium Plate
    event.custom({"type": "immersiveengineering:metal_press","energy": 2400,"input": {"tag": "c:ingots/neptunium"},
        "mold": "casting:plate_mold","result": {"item": "techopolis:neptunium_plate"}}).id("techopolis:ie/metal_press/plate_neptunium")
    event.remove(`immersiveengineering:metalpress/plate_neptunium`)

    //Ostrum Rod
    event.custom({"type": "immersiveengineering:metal_press","energy": 2400,"input": {"tag": "c:ingots/ostrum"},
        "mold": "casting:rod_mold","result": {"item": "techopolis:ostrum_rod"}}).id("techopolis:ie/metal_press/rod_ostrum")
    event.remove(`immersiveengineering:metalpress/rod_ostrum`)

    //Misc Gears (techopolis)
    event.custom({"type": "immersiveengineering:metal_press","energy": 2400,"input": {"basePredicate": {"item": "minecraft:coal"},"count": 4},
        "mold": "casting:gear_mold","result": {"item": "techopolis:coal_gear"}}).id("techopolis:ie/metal_press/coal_gear")

    event.custom({"type": "immersiveengineering:metal_press","energy": 2400,"input": {"basePredicate": {"item": "minecraft:stone"},"count": 4},
        "mold": "casting:gear_mold","result": {"item": "techopolis:stone_gear"}}).id("techopolis:ie/metal_press/stone_gear")

    event.custom({"type": "immersiveengineering:metal_press","energy": 2400,"input": {"basePredicate": {"tag": "minecraft:planks"},"count": 4},
        "mold": "casting:gear_mold","result": {"item": "techopolis:wooden_gear"}}).id("techopolis:ie/metal_press/wooden_gear")

    event.custom({"type": "immersiveengineering:metal_press","energy": 2400,"input": {"basePredicate": {"item": "stellaris:desh_ingot"},"count": 4},
        "mold": "casting:gear_mold","result": {"item": "techopolis:desh_gear"}}).id("techopolis:ie/metal_press/desh_gear")
    
    event.custom({"type": "immersiveengineering:metal_press","energy": 2400,"input": {"basePredicate": {"item": "extendedcrafting:the_ultimate_ingot"},"count": 4},
        "mold": "casting:gear_mold","result": {"item": "techopolis:the_ultimate_gear"}}).id("techopolis:ie/metal_press/the_ultimate_gear")
    
    event.custom({"type": "immersiveengineering:metal_press","energy": 2400,"input": {"basePredicate": {"item": "extendedcrafting:the_ultimate_ingot"},"count": 1},
        "mold": "casting:rod_mold","result": {"item": "techopolis:the_ultimate_rod"}}).id("techopolis:ie/metal_press/the_ultimate_rod")

    event.custom({"type": "immersiveengineering:metal_press","energy": 2400,"input": {"basePredicate": {"item": "extendedcrafting:the_ultimate_ingot"},"count": 1},
        "mold": "casting:plate_mold","result": {"item": "techopolis:the_ultimate_plate"}}).id("techopolis:ie/metal_press/the_ultimate_plate")

    //Smelting - Cheesium Ingot
    event.smelting('techopolis:cheesium_ingot', 'techopolis:cheesium_dust').xp(1).id('techopolis:smelting/cheesium_ingot')


    /*
    //Smelting - Neptunium Ingot
    event.smelting('stellaris:neptunium_ingot', 'techopolis:neptunium_dust').xp(1).id('techopolis:smelting/neptunium_ingot')
    event.blasting('stellaris:neptunium_ingot', 'techopolis:neptunium_dust').xp(1).id('techopolis:blasting/neptunium_ingot')

    //Smelting - Desh Ingot
    event.smelting('stellaris:desh_ingot', 'techopolis:desh_dust').xp(1).id('techopolis:smelting/desh_ingot')
    event.blasting('stellaris:desh_ingot', 'techopolis:desh_dust').xp(1).id('techopolis:blasting/desh_ingot')

    //Smelting - Ostrum Ingot
    event.smelting('techopolis:ostrum_ingot', 'techopolis:ostrum_dust').xp(1).id('techopolis:smelting/ostrum_ingot')
    event.blasting('techopolis:ostrum_ingot', 'techopolis:ostrum_dust').xp(1).id('techopolis:blasting/ostrum_ingot')
    */

    //Metal Press
    function createMetalPressRecipes(type, inputItem) {

        event.custom({"type": "immersiveengineering:metal_press","energy": 2400,"input": {"tag": inputItem},
            "mold": "casting:plate_mold","result": {"item": `alltheores:${type}_plate`}})
        event.remove(`immersiveengineering:metalpress/plate_${type}`)

        event.custom({"type": "immersiveengineering:metal_press","energy": 2400,"input": {"basePredicate": {"tag": inputItem},"count": 4},
            "mold": "casting:gear_mold","result": {"item": `alltheores:${type}_gear`}})
        event.remove(`immersiveengineering:metalpress/gear_${type}`)

        event.custom({"type": "immersiveengineering:metal_press","energy": 2400,"input": {"tag": inputItem},
            "mold": "casting:rod_mold","result": {"item": `alltheores:${type}_rod`}})
        event.remove(`immersiveengineering:metalpress/rod_${type}`)

    }

    createMetalPressRecipes('aluminum', 'c:ingots/aluminum')
    createMetalPressRecipes('lead', 'c:ingots/lead')
    createMetalPressRecipes('nickel', 'c:ingots/nickel')
    createMetalPressRecipes('osmium', 'c:ingots/osmium')
    createMetalPressRecipes('platinum', 'c:ingots/platinum')
    createMetalPressRecipes('silver', 'c:ingots/silver')
    createMetalPressRecipes('tin', 'c:ingots/tin')
    createMetalPressRecipes('uranium', 'c:ingots/uranium')
    createMetalPressRecipes('zinc', 'c:ingots/zinc')
    createMetalPressRecipes('iridium', 'c:ingots/iridium')
    createMetalPressRecipes('steel', 'c:ingots/steel')
    createMetalPressRecipes('invar', 'c:ingots/invar')
    createMetalPressRecipes('electrum', 'c:ingots/electrum')
    createMetalPressRecipes('bronze', 'c:ingots/bronze')
    createMetalPressRecipes('constantan', 'c:ingots/constantan')
    createMetalPressRecipes('signalum', 'c:ingots/signalum')
    createMetalPressRecipes('lumium', 'c:ingots/lumium')
    createMetalPressRecipes('enderium', 'c:ingots/enderium')
    createMetalPressRecipes('copper', 'c:ingots/copper')
    createMetalPressRecipes('iron', 'c:ingots/iron')
    createMetalPressRecipes('gold', 'c:ingots/gold')
    createMetalPressRecipes('diamond', 'c:gems/diamond')
    createMetalPressRecipes('netherite', 'c:ingots/netherite')
    createMetalPressRecipes('brass', 'c:ingots/brass')

    //Energy Smelting
    event.recipes.mekanism.smelting(`1x casting:black_brick`, `techopolis:grout`).id(`techopolis:processing/black_brick`)


    //Remove Casting Melting Raw Materials - Not Early Game Though as casting is requires for early game ores

    event.remove({id: 'casting:melting/lead/from_raw_ore'})
    event.remove({id: 'casting:melting/silver/from_raw_ore'})
    event.remove({id: 'casting:melting/nickel/from_raw_ore'})
    event.remove({id: 'casting:melting/uranium/from_raw_ore'})
    event.remove({id: 'casting:melting/platinum/from_raw_ore'})
    event.remove({id: 'casting:melting/gold/from_raw_ore'})
    event.remove({id: 'casting:melting/osmium/from_raw_ore'})
    event.remove({id: 'casting:melting/zinc/from_raw_ore'})

})