/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.screen.custom;

import com.benbenlaw.opolisutilities.recipe.CatalogueRecipe;
import com.benbenlaw.opolisutilities.screen.custom.CatalogueMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.NotNull;

public class CatalogueScreen
extends AbstractContainerScreen<CatalogueMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"textures/gui/shop_inventory.png");
    private static final int SCROLLER_WIDTH = 12;
    private static final int SCROLLER_HEIGHT = 15;
    private static final int RECIPES_COLUMNS = 4;
    private static final int RECIPES_ROWS = 3;
    private static final int RECIPES_IMAGE_SIZE_WIDTH = 18;
    private static final int RECIPES_IMAGE_SIZE_HEIGHT = 18;
    private static final int SCROLLER_FULL_HEIGHT = 54;
    private static final int RECIPES_X = 48;
    private static final int RECIPES_Y = 23;
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;
    private EditBox searchBar;
    private int selectedRecipeIndex = -1;
    private List<RecipeHolder<CatalogueRecipe>> filteredRecipes;

    public CatalogueScreen(CatalogueMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        pMenu.registerUpdateListener(this::containerChanged);
        this.titleLabelY = 4;
        this.titleLabelX = 4;
        this.inventoryLabelY = 100000;
        this.inventoryLabelX = 9;
    }

    protected void init() {
        super.init();
        this.font = this.getMinecraft().font;
        this.searchBar = new EditBox(this, this.font, this.width / 2 - 21, this.height / 2 - 77, 100, 14, (Component)Component.literal((String)"")){

            public boolean mouseClicked(double mouseX, double mouseY, int button) {
                boolean result = super.mouseClicked(mouseX, mouseY, button);
                if (button == 1 && this.isMouseOver(mouseX, mouseY)) {
                    this.setValue("");
                    return true;
                }
                this.setFocused(result);
                return result;
            }
        };
        this.searchBar.setMaxLength(50);
        this.addWidget((GuiEventListener)this.searchBar);
        this.filteredRecipes = ((CatalogueMenu)this.menu).getRecipes();
    }

    public void render(@NotNull GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(guiGraphics, pMouseX, pMouseY);
        this.searchBar.render(guiGraphics, pMouseX, pMouseY, pPartialTick);
    }

    private void updateFilteredRecipes() {
        String searchQuery = this.searchBar.getValue().toLowerCase();
        this.filteredRecipes = searchQuery.isEmpty() ? ((CatalogueMenu)this.menu).getRecipes() : ((CatalogueMenu)this.menu).getRecipes().stream().filter(recipe -> ((CatalogueRecipe)recipe.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()).getHoverName().getString().toLowerCase().contains(searchQuery)).collect(Collectors.toList());
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.searchBar.keyPressed(keyCode, scanCode, modifiers) || this.searchBar.canConsumeInput()) {
            String searchQuery = this.searchBar.getValue().toLowerCase();
            this.filteredRecipes = searchQuery.isEmpty() ? ((CatalogueMenu)this.menu).getRecipes() : ((CatalogueMenu)this.menu).getRecipes().stream().filter(recipe -> ((CatalogueRecipe)recipe.value()).getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()).getHoverName().getString().toLowerCase().contains(searchQuery)).collect(Collectors.toList());
            this.startIndex = 0;
            this.selectedRecipeIndex = -1;
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean keyReleased(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        return super.keyReleased(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char charTyped, int keyCode) {
        if (this.searchBar.charTyped(charTyped, keyCode)) {
            return true;
        }
        return super.charTyped(charTyped, keyCode);
    }

    protected void renderBg(@NotNull GuiGraphics guiGraphics, float pPartialTick, int pX, int pY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int i = this.leftPos;
        int j = this.topPos;
        guiGraphics.blit(TEXTURE, i, j, 0, 0, this.imageWidth, this.imageHeight);
        int k = (int)(39.0f * this.scrollOffs);
        guiGraphics.blit(TEXTURE, i + 123, j + 26 + k, 220 + (!this.isScrollBarActive() ? 24 : (this.scrolling ? 12 : 0)), 0, 12, 15);
        int l = this.leftPos + 48;
        int i1 = this.topPos + 23;
        int j1 = this.startIndex + 12;
        this.renderButtons(guiGraphics, pX, pY, l, i1, j1, false);
        this.renderRecipes(guiGraphics, l, i1, j1);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!((CatalogueMenu)this.menu).resultContainer.isEmpty()) {
            guiGraphics.blit(TEXTURE, i + 146, j + 46, 211, 0, 8, 11);
        }
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int pX, int pY) {
        boolean shouldRenderTooltips;
        super.renderTooltip(guiGraphics, pX, pY);
        boolean searchBarFocused = this.searchBar.isFocused();
        boolean bl = shouldRenderTooltips = this.displayRecipes || searchBarFocused;
        if (shouldRenderTooltips) {
            int i = this.leftPos + 48;
            int j = this.topPos + 23;
            int k = this.startIndex + 12;
            List<RecipeHolder<CatalogueRecipe>> list = searchBarFocused ? this.filteredRecipes : ((CatalogueMenu)this.menu).getRecipes();
            for (int l = this.startIndex; l < k && l < list.size(); ++l) {
                int i1 = l - this.startIndex;
                int j1 = i + i1 % 4 * 18 + 2;
                int k1 = j + i1 / 4 * 18 + 2;
                if (pX < j1 || pX >= j1 + 18 || pY < k1 || pY >= k1 + 18) continue;
                CatalogueRecipe recipe = (CatalogueRecipe)list.get(l).value();
                ItemStack result = recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
                assert (Minecraft.getInstance().level != null);
                guiGraphics.renderTooltip(this.font, result, pX, pY);
                if (!searchBarFocused) {
                    this.selectedRecipeIndex = ((CatalogueMenu)this.menu).getRecipes().indexOf(recipe);
                }
                return;
            }
        }
        if (CatalogueScreen.isHovering(pX, pY, this.leftPos + 142, this.topPos + 32, 16.0, 16.0)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"Price"), pX, pY);
        }
    }

    public static boolean isHovering(double mouseX, double mouseY, double x, double y, double width, double height) {
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    private void renderButtons(GuiGraphics guiGraphics, int pMouseX, int pMouseY, int pX, int pY, int pLastVisibleElementIndex, boolean overlay) {
        List<RecipeHolder<CatalogueRecipe>> list = ((CatalogueMenu)this.menu).getRecipes();
        for (int i = this.startIndex; i < pLastVisibleElementIndex && i < list.size(); ++i) {
            int xOffset;
            int j = i - this.startIndex;
            int k = pX + j % 4 * 18;
            int l = j / 4;
            int i1 = pY + l * 18 + 2;
            int j1 = 0;
            int n = xOffset = overlay ? 22 : 0;
            if (i >= this.filteredRecipes.size() && !this.searchBar.getValue().isEmpty()) continue;
            if (i == ((CatalogueMenu)this.menu).getSelectedRecipeIndex()) {
                j1 += 22;
            } else if (pMouseX >= k + 2 && pMouseY >= i1 + 2 && pMouseX < k + 2 + 18 && pMouseY < i1 + 2 + 18) {
                j1 += 44;
            }
            guiGraphics.pose();
            if (overlay) {
                guiGraphics.pose().translate(0.0f, 50.0f, 100.0f);
            }
            guiGraphics.blit(TEXTURE, k, i1 - 1, xOffset, 122 + j1 + 50, 22, 22);
            guiGraphics.pose();
        }
    }

    private void renderRecipes(GuiGraphics guiGraphics, int pLeft, int pTop, int pRecipeIndexOffsetMax) {
        List<RecipeHolder<CatalogueRecipe>> list = ((CatalogueMenu)this.menu).getRecipes();
        for (int i = this.startIndex; i < pRecipeIndexOffsetMax && i < list.size(); ++i) {
            int j = i - this.startIndex;
            int k = pLeft + j % 4 * 18 + 3;
            int l = j / 4;
            int i1 = pTop + l * 18 + 4;
            if (i >= this.filteredRecipes.size() && !this.searchBar.getValue().isEmpty()) continue;
            CatalogueRecipe recipe = this.searchBar.getValue().isEmpty() ? (CatalogueRecipe)list.get(i).value() : (CatalogueRecipe)this.filteredRecipes.get(i).value();
            ItemStack result = recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
            guiGraphics.renderItem(result, k, i1);
            guiGraphics.renderItemDecorations(this.font, result, k, i1);
        }
        if (((CatalogueMenu)this.menu).getSelectedRecipeIndex() != -1 && ((CatalogueMenu)this.menu).getRecipes().size() >= ((CatalogueMenu)this.menu).getSelectedRecipeIndex() + 1) {
            CatalogueRecipe recipe = (CatalogueRecipe)((CatalogueMenu)this.menu).getRecipes().get(((CatalogueMenu)this.menu).getSelectedRecipeIndex()).value();
            ItemStack stack = ((Ingredient)recipe.getIngredients().get(0)).getItems()[0];
            stack.setCount(recipe.getIngredientStackCount());
            guiGraphics.renderItem(stack, this.leftPos + 142, this.topPos + 32);
            guiGraphics.renderItemDecorations(this.font, stack, this.leftPos + 142, this.topPos + 32);
        }
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.searchBar.mouseClicked(pMouseX, pMouseY, pButton)) {
            return true;
        }
        this.scrolling = false;
        if (this.displayRecipes) {
            int i = this.leftPos + 48;
            int j = this.topPos + 23;
            int k = this.startIndex + 12;
            for (int l = this.startIndex; l < k; ++l) {
                int recipeIndex;
                int i1 = l - this.startIndex;
                double d0 = pMouseX - (double)(i + i1 % 4 * 18 + 2);
                double d1 = pMouseY - (double)(j + i1 / 4 * 18 + 3);
                if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 18.0) || !(d1 < 18.0) || !((CatalogueMenu)this.menu).clickMenuButton((Player)this.minecraft.player, l) || (recipeIndex = this.startIndex + i1) < 0 || recipeIndex >= this.filteredRecipes.size()) continue;
                CatalogueRecipe recipe = (CatalogueRecipe)this.filteredRecipes.get(recipeIndex).value();
                int originalIndex = -1;
                List<RecipeHolder<CatalogueRecipe>> recipeHolders = ((CatalogueMenu)this.menu).getRecipes();
                for (int x = 0; x < recipeHolders.size(); ++x) {
                    CatalogueRecipe holderRecipe = (CatalogueRecipe)recipeHolders.get(x).value();
                    if (!holderRecipe.equals(recipe)) continue;
                    originalIndex = x;
                    break;
                }
                if (originalIndex < 0) continue;
                assert (Minecraft.getInstance().level != null);
                ItemStack result = recipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
                if (result.isEmpty()) continue;
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_STONECUTTER_SELECT_RECIPE, (float)1.0f));
                assert (Objects.requireNonNull(this.minecraft).gameMode != null);
                assert (this.minecraft.gameMode != null);
                this.minecraft.gameMode.handleInventoryButtonClick(((CatalogueMenu)this.getMenu()).containerId, originalIndex);
                this.selectedRecipeIndex = originalIndex;
                this.searchBar.setValue("");
                return true;
            }
            i = this.leftPos + 123;
            j = this.topPos + 26;
            if (pMouseX >= (double)i && pMouseX < (double)(i + 12) && pMouseY >= (double)j && pMouseY < (double)(j + 54)) {
                if (this.isScrollBarActive()) {
                    this.scrolling = true;
                    i = this.topPos + 26;
                    j = i + 54;
                    this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
                    this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
                    this.startIndex = Math.max(0, (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4);
                } else {
                    this.scrollOffs = 0.0f;
                    this.startIndex = 0;
                }
            }
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.topPos + 26;
            int j = i + 54;
            this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.clamp((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = Math.max(0, (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4);
            return true;
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseScrolled(double pMouseX, double pMouseY, double pScrollX, double pScrollY) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)pScrollY / (float)i;
            this.scrollOffs = Mth.clamp((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = Math.max(0, (int)((double)(this.scrollOffs * (float)i) + 0.5) * 4);
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && ((CatalogueMenu)this.menu).getNumRecipes() > 12;
    }

    protected int getOffscreenRows() {
        return (((CatalogueMenu)this.menu).getNumRecipes() + 4 - 1) / 4 - 3;
    }

    private void containerChanged() {
        this.displayRecipes = ((CatalogueMenu)this.menu).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
        if (!this.isScrollBarActive()) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
        this.updateFilteredRecipes();
    }
}

