/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.screen.custom;

import com.benbenlaw.opolisutilities.block.custom.BlockPlacerBlock;
import com.benbenlaw.opolisutilities.block.entity.custom.BlockPlacerBlockEntity;
import com.benbenlaw.opolisutilities.networking.payload.DecreaseTickButtonPayload;
import com.benbenlaw.opolisutilities.networking.payload.IncreaseTickButtonPayload;
import com.benbenlaw.opolisutilities.networking.payload.OnOffButtonPayload;
import com.benbenlaw.opolisutilities.screen.custom.BlockPlacerMenu;
import com.benbenlaw.opolisutilities.screen.utils.ModButtons;
import com.benbenlaw.opolisutilities.util.MouseUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockPlacerScreen
extends AbstractContainerScreen<BlockPlacerMenu> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"textures/gui/block_placer_gui.png");

    public BlockPlacerScreen(BlockPlacerMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
    }

    protected void init() {
        super.init();
        this.addMenuButtons();
    }

    protected void containerTick() {
        this.clearWidgets();
        this.addMenuButtons();
    }

    protected void renderBg(GuiGraphics guiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        if (((BlockPlacerMenu)this.menu).isCrafting()) {
            guiGraphics.blit(TEXTURE, x + 84, y + 45, 176, 0, 8, ((BlockPlacerMenu)this.menu).getScaledProgress());
        }
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        this.renderBackground(guiGraphics, mouseX, mouseY, delta);
        super.render(guiGraphics, mouseX, mouseY, delta);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderTickRate(guiGraphics, mouseX, mouseY, this.leftPos + 5, this.height / 2 - 66);
    }

    @Nullable
    private void renderTickRate(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea(mouseX, mouseY, x, y, 0, 0, 20, 54)) {
            int ticks = 0;
            BlockEntity blockEntity = ((BlockPlacerMenu)this.menu).level.getBlockEntity(((BlockPlacerMenu)this.menu).blockPos);
            if (blockEntity instanceof BlockPlacerBlockEntity) {
                BlockPlacerBlockEntity blockPlacerBlockEntity = (BlockPlacerBlockEntity)blockEntity;
                ticks = blockPlacerBlockEntity.maxProgress;
            }
            guiGraphics.drawString(this.font, (Component)Component.translatable((String)"gui.opolisutilities.shift"), this.leftPos + 95, this.topPos + 45, 0x3F3F3F, false);
            guiGraphics.drawString(this.font, ticks + " ticks", this.leftPos + 95, this.topPos + 55, 0x3F3F3F, false);
        }
    }

    private void addMenuButtons() {
        if (!((Boolean)((BlockPlacerMenu)this.menu).blockEntity.getBlockState().getValue((Property)BlockPlacerBlock.POWERED)).booleanValue()) {
            this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 5, this.height / 2 - 49, 20, 18, ModButtons.OFF_BUTTONS, pressed -> PacketDistributor.sendToServer((CustomPacketPayload)new OnOffButtonPayload(((BlockPlacerMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0])));
        } else {
            this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 5, this.height / 2 - 49, 20, 18, ModButtons.ON_BUTTONS, pressed -> PacketDistributor.sendToServer((CustomPacketPayload)new OnOffButtonPayload(((BlockPlacerMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0])));
        }
        boolean isShiftDown = BlockPlacerScreen.hasShiftDown();
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 5, this.height / 2 - 32, 20, 18, ModButtons.DECREASE_BUTTONS, pressed -> PacketDistributor.sendToServer((CustomPacketPayload)new DecreaseTickButtonPayload(((BlockPlacerMenu)this.menu).blockEntity.getBlockPos(), isShiftDown), (CustomPacketPayload[])new CustomPacketPayload[0])));
        this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 5, this.height / 2 - 66, 20, 18, ModButtons.INCREASE_BUTTONS, pressed -> PacketDistributor.sendToServer((CustomPacketPayload)new IncreaseTickButtonPayload(((BlockPlacerMenu)this.menu).blockEntity.getBlockPos(), isShiftDown), (CustomPacketPayload[])new CustomPacketPayload[0])));
    }
}

