/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.loot;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.storage.loot.LootTable;

public class ModLootTables {
    private static final Set<ResourceKey<LootTable>> LOCATIONS = Sets.newHashSet();
    public static final ResourceKey<LootTable> BASIC_LOOT_BOX = ModLootTables.register("loot_boxes/basic_loot_box");
    private static final Set<ResourceKey<LootTable>> IMMUTABLE_LOCATIONS = Collections.unmodifiableSet(LOCATIONS);

    private static ResourceKey<LootTable> register(String string) {
        return ModLootTables.register(ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)string));
    }

    private static ResourceKey<LootTable> register(ResourceLocation id) {
        return ModLootTables.register((ResourceKey<LootTable>)ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)id));
    }

    private static ResourceKey<LootTable> register(ResourceKey<LootTable> id) {
        if (LOCATIONS.add(id)) {
            return id;
        }
        throw new IllegalArgumentException(String.valueOf(id) + " is already a registered built-in loot table");
    }

    public static Set<ResourceKey<LootTable>> allBuiltin() {
        return IMMUTABLE_LOCATIONS;
    }
}

