/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.integration.jei;

import com.benbenlaw.opolisutilities.block.ModBlocks;
import com.benbenlaw.opolisutilities.integration.jei.CatalogueRecipeCategory;
import com.benbenlaw.opolisutilities.integration.jei.ClocheRecipeCategory;
import com.benbenlaw.opolisutilities.integration.jei.DryingTableRecipeCategory;
import com.benbenlaw.opolisutilities.integration.jei.FluidGeneratorRecipeCategory;
import com.benbenlaw.opolisutilities.integration.jei.ResourceGeneratorRecipeCategory;
import com.benbenlaw.opolisutilities.integration.jei.SoakingTableRecipeCategory;
import com.benbenlaw.opolisutilities.integration.jei.SpeedUpgradesRecipeCategory;
import com.benbenlaw.opolisutilities.integration.jei.SummoningRecipeCategory;
import com.benbenlaw.opolisutilities.item.ModItems;
import com.benbenlaw.opolisutilities.recipe.CatalogueRecipe;
import com.benbenlaw.opolisutilities.recipe.ClocheRecipe;
import com.benbenlaw.opolisutilities.recipe.DryingTableRecipe;
import com.benbenlaw.opolisutilities.recipe.FluidGeneratorRecipe;
import com.benbenlaw.opolisutilities.recipe.ModRecipes;
import com.benbenlaw.opolisutilities.recipe.ResourceGeneratorRecipe;
import com.benbenlaw.opolisutilities.recipe.SoakingTableRecipe;
import com.benbenlaw.opolisutilities.recipe.SpeedUpgradesRecipe;
import com.benbenlaw.opolisutilities.recipe.SummoningBlockRecipe;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class JEIOpolisUtilitiesPlugin
implements IModPlugin {
    public static IDrawableStatic slotDrawable;
    public static RecipeType<CatalogueRecipe> CATALOGUE_RECIPE;
    public static RecipeType<ResourceGeneratorRecipe> RESOURCE_GENERATOR;
    public static RecipeType<SpeedUpgradesRecipe> SPEED_UPGRADES;
    public static RecipeType<FluidGeneratorRecipe> FLUID_GENERATOR;
    public static RecipeType<DryingTableRecipe> DRYING_TABLE;
    public static RecipeType<SoakingTableRecipe> SOAKING_TABLE;
    public static RecipeType<SummoningBlockRecipe> SUMMOMING_BLOCK;
    public static RecipeType<ClocheRecipe> CLOCHE;

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)"jei_plugin");
    }

    public void registerRecipeCatalysts(@NotNull IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.DRYING_TABLE.get()), new RecipeType[]{DryingTableRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.DRYING_TABLE.get()), new RecipeType[]{SoakingTableRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.RESOURCE_GENERATOR.get()), new RecipeType[]{ResourceGeneratorRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.FLUID_GENERATOR.get()), new RecipeType[]{FluidGeneratorRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CATALOGUE.get()), new RecipeType[]{CatalogueRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItems.CATALOGUE_BOOK.get()), new RecipeType[]{CatalogueRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.SUMMONING_BLOCK.get()), new RecipeType[]{SummoningRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CLOCHE.get()), new RecipeType[]{ClocheRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.RESOURCE_GENERATOR.get()), new RecipeType[]{SpeedUpgradesRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ITEM_REPAIRER.get()), new RecipeType[]{SpeedUpgradesRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.FLUID_GENERATOR.get()), new RecipeType[]{SpeedUpgradesRecipeCategory.RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.CLOCHE.get()), new RecipeType[]{SpeedUpgradesRecipeCategory.RECIPE_TYPE});
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        IGuiHelper guiHelper = registration.getJeiHelpers().getGuiHelper();
        registration.addRecipeCategories(new IRecipeCategory[]{new DryingTableRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SoakingTableRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ResourceGeneratorRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SpeedUpgradesRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new FluidGeneratorRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new CatalogueRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new SummoningRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ClocheRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        slotDrawable = guiHelper.getSlotDrawable();
    }

    public void registerRecipes(IRecipeRegistration registration) {
        assert (Minecraft.getInstance().level != null);
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        registration.addRecipes(CatalogueRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(ModRecipes.CATALOGUE_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(DryingTableRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(ModRecipes.DRYING_TABLE_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(SoakingTableRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(ModRecipes.SOAKING_TABLE_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(ResourceGeneratorRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(ModRecipes.RESOURCE_GENERATOR_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(FluidGeneratorRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(ModRecipes.FLUID_GENERATOR_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(SpeedUpgradesRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(ModRecipes.SPEED_UPGRADE_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(SummoningRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(ModRecipes.SUMMONING_BLOCK_TYPE.get()).stream().map(RecipeHolder::value).toList());
        registration.addRecipes(ClocheRecipeCategory.RECIPE_TYPE, recipeManager.getAllRecipesFor(ModRecipes.CLOCHE_TYPE.get()).stream().map(RecipeHolder::value).toList());
    }

    static {
        CATALOGUE_RECIPE = new RecipeType(CatalogueRecipeCategory.UID, CatalogueRecipe.class);
        RESOURCE_GENERATOR = new RecipeType(ResourceGeneratorRecipeCategory.UID, ResourceGeneratorRecipe.class);
        SPEED_UPGRADES = new RecipeType(SpeedUpgradesRecipeCategory.UID, SpeedUpgradesRecipe.class);
        FLUID_GENERATOR = new RecipeType(FluidGeneratorRecipeCategory.UID, FluidGeneratorRecipe.class);
        DRYING_TABLE = new RecipeType(DryingTableRecipeCategory.UID, DryingTableRecipe.class);
        SOAKING_TABLE = new RecipeType(SoakingTableRecipeCategory.UID, SoakingTableRecipe.class);
        SUMMOMING_BLOCK = new RecipeType(SummoningRecipeCategory.UID, SummoningBlockRecipe.class);
        CLOCHE = new RecipeType(ClocheRecipeCategory.UID, ClocheRecipe.class);
    }
}

