/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.datagen.recipes;

import com.benbenlaw.opolisutilities.recipe.SpeedUpgradesRecipe;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpeedUpgradesRecipeBuilder
implements RecipeBuilder {
    protected String group;
    protected Ingredient input;
    protected int tickRate;
    protected final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    public SpeedUpgradesRecipeBuilder(Ingredient input, int tickRate) {
        this.input = input;
        this.tickRate = tickRate;
    }

    public static SpeedUpgradesRecipeBuilder SpeedUpgradesRecipeBuilder(Ingredient input, int tickRate) {
        return new SpeedUpgradesRecipeBuilder(input, tickRate);
    }

    @NotNull
    public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    @NotNull
    public RecipeBuilder group(@Nullable String groupName) {
        this.group = groupName;
        return this;
    }

    @NotNull
    public Item getResult() {
        return ItemStack.EMPTY.getItem();
    }

    public void save(@NotNull RecipeOutput recipeOutput) {
        this.save(recipeOutput, ResourceLocation.fromNamespaceAndPath((String)"opolisutilities", (String)("speed_upgrades/" + BuiltInRegistries.ITEM.getKey((Object)Objects.requireNonNull(this.input.getItems()[0].getItem())).getPath())));
    }

    public void save(@NotNull RecipeOutput recipeOutput, @NotNull ResourceLocation id) {
        Advancement.Builder builder = Advancement.Builder.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        SpeedUpgradesRecipe speedUpgradesRecipe = new SpeedUpgradesRecipe(this.input, this.tickRate);
        recipeOutput.accept(id, (Recipe)speedUpgradesRecipe, builder.build(id.withPrefix("recipes/speed_upgrades/")));
    }
}

