/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.block.entity.custom;

import com.benbenlaw.opolisutilities.block.ModBlocks;
import com.benbenlaw.opolisutilities.block.custom.ResourceGeneratorBlock;
import com.benbenlaw.opolisutilities.block.entity.ModBlockEntities;
import com.benbenlaw.opolisutilities.block.entity.custom.handler.InputOutputItemHandler;
import com.benbenlaw.opolisutilities.recipe.NoInventoryRecipe;
import com.benbenlaw.opolisutilities.recipe.ResourceGeneratorRecipe;
import com.benbenlaw.opolisutilities.recipe.SpeedUpgradesRecipe;
import com.benbenlaw.opolisutilities.screen.custom.ResourceGeneratorMenu;
import com.benbenlaw.opolisutilities.util.inventory.IInventoryHandlingBlockEntity;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceGeneratorBlockEntity
extends BlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected int getStackLimit(int slot, ItemStack stack) {
            if (slot == 2) {
                return 1;
            }
            if (slot == 1) {
                return stack.getMaxStackSize();
            }
            if (slot == 0) {
                return 1;
            }
            return slot;
        }

        protected void onContentsChanged(int slot) {
            ResourceGeneratorBlockEntity.this.setChanged();
            ResourceGeneratorBlockEntity.this.sync();
        }
    };
    public final ContainerData data;
    public int progress = 0;
    public int maxProgress = 220;
    public String resource = "";
    public static final int INPUT_SLOT = 0;
    public static final int OUTPUT_SLOT = 1;
    public static final int UPGRADE_SLOT = 2;
    private final IItemHandler outputItemHandler = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> false, i -> i == 1);

    public void sync() {
        ServerLevel serverLevel;
        LevelChunk chunk;
        ChunkSource chunkSource;
        Level level = this.level;
        if (level instanceof ServerLevel && (chunkSource = Objects.requireNonNull((chunk = (serverLevel = (ServerLevel)level).getChunkAt(this.getBlockPos())).getLevel()).getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
            chunkCache.chunkMap.getPlayers(chunk.getPos(), false).forEach(this::syncContents);
        }
    }

    public void syncContents(ServerPlayer player) {
        player.connection.send(Objects.requireNonNull(this.getUpdatePacket()));
    }

    public IItemHandler getItemHandlerCapability(Direction side) {
        if (side == null) {
            return this.itemHandler;
        }
        return this.outputItemHandler;
    }

    @Override
    public void setHandler(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    @Override
    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public ResourceGeneratorBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.RESOURCE_GENERATOR_BLOCK_ENTITY.get(), blockPos, blockState);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> ResourceGeneratorBlockEntity.this.progress;
                    case 1 -> ResourceGeneratorBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        ResourceGeneratorBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        ResourceGeneratorBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.opolisutilities.resource_generator");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new ResourceGeneratorMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
    }

    public void handleUpdateTag(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, provider);
        return compoundTag;
    }

    public void onDataPacket(@NotNull Connection connection, @NotNull ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.onDataPacket(connection, clientboundBlockEntityDataPacket, provider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        compoundTag.putInt("progress", this.progress);
        compoundTag.putInt("maxProgress", this.maxProgress);
        compoundTag.putString("resource", this.resource);
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        this.progress = compoundTag.getInt("progress");
        this.maxProgress = compoundTag.getInt("maxProgress");
        this.resource = compoundTag.getString("resource");
        super.loadAdditional(compoundTag, provider);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick() {
        BlockPos blockPos = this.worldPosition;
        ResourceGeneratorBlockEntity entity = this;
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            Object match2;
            this.sync();
            for (Object match2 : this.level.getRecipeManager().getRecipesFor((RecipeType)SpeedUpgradesRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, this.level)) {
                NonNullList<Ingredient> input = ((SpeedUpgradesRecipe)match2.value()).getIngredients();
                block1: for (Ingredient ingredient : input) {
                    for (ItemStack itemStack : ingredient.getItems()) {
                        if (!this.itemHandler.getStackInSlot(2).is(itemStack.getItem())) continue;
                        this.maxProgress = ((SpeedUpgradesRecipe)match2.value()).tickRate();
                        continue block1;
                    }
                }
            }
            if (this.itemHandler.getStackInSlot(2).isEmpty()) {
                this.maxProgress = 220;
            }
            RecipeInput inventory = new RecipeInput(){

                @NotNull
                public ItemStack getItem(int index) {
                    return ResourceGeneratorBlockEntity.this.itemHandler.getStackInSlot(index);
                }

                public int size() {
                    return ResourceGeneratorBlockEntity.this.itemHandler.getSlots();
                }
            };
            match2 = this.level.getRecipeManager().getRecipeFor((RecipeType)ResourceGeneratorRecipe.Type.INSTANCE, inventory, this.level);
            if (((Optional)match2).isPresent()) {
                ResourceGeneratorRecipe recipe = (ResourceGeneratorRecipe)((RecipeHolder)((Optional)match2).get()).value();
                if (recipe.matches(inventory, this.level)) {
                    this.resource = this.itemHandler.getStackInSlot(0).getItem().toString();
                    ItemStack output = this.itemHandler.getStackInSlot(0).copy();
                    if (!this.itemHandler.getStackInSlot(0).getComponents().isEmpty()) {
                        DataComponentMap dataComponentMap = this.itemHandler.getStackInSlot(0).getComponents();
                        output.applyComponents(dataComponentMap);
                    }
                    output.setCount(entity.itemHandler.getStackInSlot(1).getCount() + 1);
                    this.level.setBlockAndUpdate(blockPos, (BlockState)this.level.getBlockState(blockPos).setValue((Property)ResourceGeneratorBlock.POWERED, (Comparable)Boolean.valueOf(true)));
                    if (this.itemHandler.getStackInSlot(1).isEmpty() || this.itemHandler.getStackInSlot(1).getItem() == this.itemHandler.getStackInSlot(0).getItem() && this.itemHandler.getStackInSlot(1).getCount() < this.itemHandler.getStackInSlot(1).getMaxStackSize()) {
                        ++this.progress;
                        if (this.progress >= this.maxProgress) {
                            this.progress = 0;
                            if (this.level.getBlockState(blockPos).is((Block)ModBlocks.RESOURCE_GENERATOR.get())) {
                                entity.itemHandler.setStackInSlot(1, output);
                                this.setChanged();
                                this.sync();
                            }
                        }
                    }
                }
            } else {
                this.resource = "";
                this.level.setBlockAndUpdate(blockPos, (BlockState)this.level.getBlockState(blockPos).setValue((Property)ResourceGeneratorBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            }
            if (this.itemHandler.getStackInSlot(0).isEmpty()) {
                this.progress = 0;
            }
        }
    }
}

