/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.block.entity.custom;

import com.benbenlaw.opolisutilities.block.custom.ItemRepairerBlock;
import com.benbenlaw.opolisutilities.block.entity.ModBlockEntities;
import com.benbenlaw.opolisutilities.block.entity.custom.handler.InputOutputItemHandler;
import com.benbenlaw.opolisutilities.recipe.NoInventoryRecipe;
import com.benbenlaw.opolisutilities.recipe.SpeedUpgradesRecipe;
import com.benbenlaw.opolisutilities.screen.custom.ItemRepairerMenu;
import com.benbenlaw.opolisutilities.util.ModTags;
import com.benbenlaw.opolisutilities.util.inventory.IInventoryHandlingBlockEntity;
import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemRepairerBlockEntity
extends BlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            ItemRepairerBlockEntity.this.setChanged();
            ItemRepairerBlockEntity.this.sync();
        }
    };
    private FakePlayer fakePlayer;
    public final ContainerData data;
    public int progress = 0;
    public int maxProgress = 220;
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    public static final int UPGRADE_SLOT = 2;
    private final IItemHandler itemRepairerHandler = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0 && !stack.is(ModTags.Items.BANNED_IN_ITEM_REPAIRER), i -> i == 1);
    int playingSound = 0;

    public void sync() {
        ServerLevel serverLevel;
        LevelChunk chunk;
        ChunkSource chunkSource;
        Level level = this.level;
        if (level instanceof ServerLevel && (chunkSource = Objects.requireNonNull((chunk = (serverLevel = (ServerLevel)level).getChunkAt(this.getBlockPos())).getLevel()).getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
            chunkCache.chunkMap.getPlayers(chunk.getPos(), false).forEach(this::syncContents);
        }
    }

    public void syncContents(ServerPlayer player) {
        player.connection.send(Objects.requireNonNull(this.getUpdatePacket()));
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        return this.itemRepairerHandler;
    }

    @Override
    public void setHandler(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    @Override
    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public ItemRepairerBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.ITEM_REPAIRER_BLOCK_ENTITY.get(), blockPos, blockState);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> ItemRepairerBlockEntity.this.progress;
                    case 1 -> ItemRepairerBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        ItemRepairerBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        ItemRepairerBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.fakePlayer = this.createFakePlayer(serverLevel);
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.opolisutilities.item_repairer");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new ItemRepairerMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, provider);
        return compoundTag;
    }

    public void onDataPacket(@NotNull Connection connection, @NotNull ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.onDataPacket(connection, clientboundBlockEntityDataPacket, provider);
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        compoundTag.putInt("progress", this.progress);
        compoundTag.putInt("maxProgress", this.maxProgress);
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        this.progress = compoundTag.getInt("progress");
        this.maxProgress = compoundTag.getInt("maxProgress");
        super.loadAdditional(compoundTag, provider);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick() {
        Level level = this.level;
        BlockPos blockPos = this.worldPosition;
        assert (level != null);
        BlockState blockState = level.getBlockState(blockPos);
        ItemRepairerBlockEntity blockEntity = this;
        ItemStack inputAsStack = new ItemStack((ItemLike)blockEntity.itemHandler.getStackInSlot(0).getItem());
        boolean isDamaged = inputAsStack.isDamaged();
        int damageValue = blockEntity.itemHandler.getStackInSlot(0).getDamageValue();
        ItemStack stackInSlot0 = blockEntity.itemHandler.getStackInSlot(0);
        ItemStack copiedStack = stackInSlot0.copy();
        if (!level.isClientSide()) {
            if (this.fakePlayer == null && level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.fakePlayer = this.createFakePlayer(serverLevel);
            }
            for (RecipeHolder match : level.getRecipeManager().getRecipesFor((RecipeType)SpeedUpgradesRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, level)) {
                NonNullList<Ingredient> input = ((SpeedUpgradesRecipe)match.value()).getIngredients();
                block1: for (Ingredient ingredient : input) {
                    for (ItemStack itemStack : ingredient.getItems()) {
                        if (!this.itemHandler.getStackInSlot(2).is(itemStack.getItem())) continue;
                        this.maxProgress = ((SpeedUpgradesRecipe)match.value()).tickRate();
                        continue block1;
                    }
                }
            }
            if (this.itemHandler.getStackInSlot(2).isEmpty()) {
                this.maxProgress = 220;
            }
            if (inputAsStack.isDamageableItem() && damageValue != 0 && ((Boolean)blockState.getValue((Property)ItemRepairerBlock.POWERED)).booleanValue()) {
                ++blockEntity.progress;
                this.playBreakingSound(level, blockPos);
                if (blockEntity.progress > blockEntity.maxProgress) {
                    if (!isDamaged) {
                        blockEntity.itemHandler.getStackInSlot(0).hurtAndBreak(-1, (LivingEntity)this.fakePlayer, this.fakePlayer.getEquipmentSlotForItem(ItemStack.EMPTY));
                        level.playLocalSound((double)blockPos.getX(), (double)blockPos.getY(), (double)blockPos.getZ(), SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 0.5f, 3.0f, false);
                    }
                    blockEntity.resetProgress();
                    this.setChanged();
                    this.sync();
                }
            }
            if (inputAsStack.isDamageableItem() && damageValue == 0 && blockEntity.itemHandler.getStackInSlot(1).isEmpty()) {
                blockEntity.itemHandler.setStackInSlot(1, copiedStack);
                blockEntity.itemHandler.extractItem(0, 1, false);
                blockEntity.resetProgress();
                this.playCompletedSound(level, blockPos);
                this.setChanged();
                this.sync();
            }
            if (!inputAsStack.isDamageableItem() && blockEntity.itemHandler.getStackInSlot(1).isEmpty()) {
                blockEntity.itemHandler.setStackInSlot(1, copiedStack);
                blockEntity.itemHandler.extractItem(0, copiedStack.getCount(), false);
                blockEntity.resetProgress();
                this.setChanged();
                this.sync();
            }
        }
    }

    private FakePlayer createFakePlayer(ServerLevel level) {
        return new FakePlayer(level, new GameProfile(UUID.randomUUID(), "ItemRepairer"));
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void playBreakingSound(Level level, BlockPos blockPos) {
        ++this.playingSound;
        if (this.playingSound / 30 == 1) {
            level.playSound(null, blockPos, SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 0.3f, 1.0f);
            this.playingSound = 0;
        }
    }

    private void playCompletedSound(Level level, BlockPos blockPos) {
        level.playSound(null, blockPos, SoundEvents.PLAYER_LEVELUP, SoundSource.BLOCKS, 0.3f, 1.0f);
    }
}

