/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.block.entity.custom;

import com.benbenlaw.opolisutilities.block.custom.ClocheBlock;
import com.benbenlaw.opolisutilities.block.entity.ModBlockEntities;
import com.benbenlaw.opolisutilities.block.entity.custom.handler.InputOutputItemHandler;
import com.benbenlaw.opolisutilities.recipe.ClocheRecipe;
import com.benbenlaw.opolisutilities.recipe.NoInventoryRecipe;
import com.benbenlaw.opolisutilities.recipe.SpeedUpgradesRecipe;
import com.benbenlaw.opolisutilities.screen.custom.ClocheMenu;
import com.benbenlaw.opolisutilities.util.inventory.IInventoryHandlingBlockEntity;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(forRemoval=true, since="4.11.6")
public class ClocheBlockEntity
extends BlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(8){

        protected int getStackLimit(int slot, ItemStack stack) {
            if (slot == 3 || slot == 2 || slot == 1 || slot == 0) {
                return 1;
            }
            return slot;
        }

        protected void onContentsChanged(int slot) {
            ClocheBlockEntity.this.setChanged();
            ClocheBlockEntity.this.sync();
        }
    };
    public final ContainerData data;
    public int progress = 0;
    public int maxProgress = 80;
    public static final int SEED_SLOT = 0;
    public static final int SOIL_SLOT = 1;
    public static final int CATALYST_SLOT = 2;
    public static final int UPGRADE_SLOT = 3;
    public static final int[] OUTPUT_SLOTS = new int[]{4, 5, 6, 7};
    private final IItemHandler clocheItemHandlerSide = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> false, this::isOutputSlot);

    public void sync() {
        ServerLevel serverLevel;
        LevelChunk chunk;
        ChunkSource chunkSource;
        Level level = this.level;
        if (level instanceof ServerLevel && (chunkSource = Objects.requireNonNull((chunk = (serverLevel = (ServerLevel)level).getChunkAt(this.getBlockPos())).getLevel()).getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
            chunkCache.chunkMap.getPlayers(chunk.getPos(), false).forEach(this::syncContents);
        }
    }

    public void syncContents(ServerPlayer player) {
        player.connection.send(Objects.requireNonNull(this.getUpdatePacket()));
    }

    public ItemStack getSoilBlock() {
        return this.itemHandler.getStackInSlot(1);
    }

    public ItemStack getSeed() {
        return this.itemHandler.getStackInSlot(0);
    }

    private boolean isOutputSlot(int slot) {
        for (int outputSlot : OUTPUT_SLOTS) {
            if (slot != outputSlot) continue;
            return true;
        }
        return false;
    }

    public IItemHandler getItemHandlerCapability(Direction side) {
        return this.clocheItemHandlerSide;
    }

    @Override
    public void setHandler(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    @Override
    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public ClocheBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.CLOCHE_BLOCK_ENTITY.get(), blockPos, blockState);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> ClocheBlockEntity.this.progress;
                    case 1 -> ClocheBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        ClocheBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        ClocheBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.opolisutilities.cloche");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new ClocheMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
    }

    public void handleUpdateTag(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, provider);
        return compoundTag;
    }

    public void onDataPacket(@NotNull Connection connection, @NotNull ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.onDataPacket(connection, clientboundBlockEntityDataPacket, provider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        compoundTag.putInt("progress", this.progress);
        compoundTag.putInt("maxProgress", this.maxProgress);
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        this.progress = compoundTag.getInt("progress");
        this.maxProgress = compoundTag.getInt("maxProgress");
        super.loadAdditional(compoundTag, provider);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick() {
        BlockPos blockPos = this.worldPosition;
        BlockState blockState = this.level.getBlockState(blockPos);
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            ClocheRecipe recipe;
            Object match2;
            this.sync();
            int originalMaxProgress = this.maxProgress;
            int defaultMaxProgress = 220;
            boolean validRecipeFound = false;
            for (Object match2 : this.level.getRecipeManager().getRecipesFor((RecipeType)SpeedUpgradesRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, this.level)) {
                NonNullList<Ingredient> input = ((SpeedUpgradesRecipe)match2.value()).getIngredients();
                block1: for (Ingredient ingredient : input) {
                    for (ItemStack itemStack : ingredient.getItems()) {
                        if (!this.itemHandler.getStackInSlot(3).is(itemStack.getItem())) continue;
                        this.maxProgress = ((SpeedUpgradesRecipe)match2.value()).tickRate();
                        continue block1;
                    }
                }
            }
            if (this.itemHandler.getStackInSlot(3).isEmpty()) {
                this.maxProgress = defaultMaxProgress;
            }
            if (this.itemHandler.getStackInSlot(0).isEmpty() || this.itemHandler.getStackInSlot(1).isEmpty()) {
                this.progress = 0;
            }
            RecipeInput inventory = new RecipeInput(){

                @NotNull
                public ItemStack getItem(int index) {
                    return ClocheBlockEntity.this.itemHandler.getStackInSlot(index);
                }

                public int size() {
                    return ClocheBlockEntity.this.itemHandler.getSlots();
                }
            };
            match2 = this.level.getRecipeManager().getRecipeFor((RecipeType)ClocheRecipe.Type.INSTANCE, inventory, this.level);
            if (((Optional)match2).isPresent() && ((Boolean)blockState.getValue((Property)ClocheBlock.POWERED)).booleanValue() && ((recipe = (ClocheRecipe)((RecipeHolder)((Optional)match2).get()).value()).catalyst().test(inventory.getItem(2)) || recipe.catalyst().isEmpty())) {
                validRecipeFound = true;
                this.maxProgress = (int)((double)this.maxProgress * recipe.durationModifier());
                boolean allSlotsFull = true;
                Item mainOutput = recipe.mainOutput().getItem().asItem();
                Item chanceOutput1 = recipe.chanceOutput1().getItem().asItem();
                Item chanceOutput2 = recipe.chanceOutput2().getItem().asItem();
                Item chanceOutput3 = recipe.chanceOutput3().getItem().asItem();
                for (int slot = 4; slot <= 7; ++slot) {
                    ItemStack currentStack = this.itemHandler.getStackInSlot(slot);
                    if (!(currentStack.isEmpty() || currentStack.getItem() == mainOutput && currentStack.getCount() < currentStack.getMaxStackSize() || currentStack.getItem() == chanceOutput1 && currentStack.getCount() < currentStack.getMaxStackSize() || currentStack.getItem() == chanceOutput2 && currentStack.getCount() < currentStack.getMaxStackSize()) && (currentStack.getItem() != chanceOutput3 || currentStack.getCount() >= currentStack.getMaxStackSize())) continue;
                    allSlotsFull = false;
                    break;
                }
                if (allSlotsFull) {
                    return;
                }
                ++this.progress;
                if (this.progress >= this.maxProgress) {
                    int amountToAdd;
                    ItemStack currentStack;
                    int slot;
                    boolean mainOutputPlaced = false;
                    boolean chanceOutput1Placed = false;
                    boolean chanceOutput2Placed = false;
                    boolean chanceOutput3Placed = false;
                    for (slot = 4; slot <= 7; ++slot) {
                        currentStack = this.itemHandler.getStackInSlot(slot);
                        if (currentStack.isEmpty()) {
                            this.itemHandler.setStackInSlot(slot, new ItemStack((ItemLike)mainOutput));
                            mainOutputPlaced = true;
                            this.setChanged();
                        } else if (currentStack.getItem() == mainOutput && currentStack.getCount() < currentStack.getMaxStackSize()) {
                            amountToAdd = Math.min(currentStack.getMaxStackSize() - currentStack.getCount(), 1);
                            currentStack.grow(amountToAdd);
                            mainOutputPlaced = true;
                            this.setChanged();
                        }
                        if (mainOutputPlaced) break;
                    }
                    if (Math.random() < recipe.chanceOutputChance1()) {
                        for (slot = 4; slot <= 7; ++slot) {
                            currentStack = this.itemHandler.getStackInSlot(slot);
                            if (currentStack.isEmpty()) {
                                this.itemHandler.setStackInSlot(slot, new ItemStack((ItemLike)chanceOutput1));
                                chanceOutput1Placed = true;
                                this.setChanged();
                            } else if (currentStack.getItem() == chanceOutput1 && currentStack.getCount() < currentStack.getMaxStackSize()) {
                                amountToAdd = Math.min(currentStack.getMaxStackSize() - currentStack.getCount(), 1);
                                currentStack.grow(amountToAdd);
                                chanceOutput1Placed = true;
                                this.setChanged();
                            }
                            if (chanceOutput1Placed) break;
                        }
                    }
                    if (Math.random() < recipe.chanceOutputChance2()) {
                        for (slot = 4; slot <= 7; ++slot) {
                            currentStack = this.itemHandler.getStackInSlot(slot);
                            if (currentStack.isEmpty()) {
                                this.itemHandler.setStackInSlot(slot, new ItemStack((ItemLike)chanceOutput2));
                                chanceOutput2Placed = true;
                                this.setChanged();
                            } else if (currentStack.getItem() == chanceOutput2 && currentStack.getCount() < currentStack.getMaxStackSize()) {
                                amountToAdd = Math.min(currentStack.getMaxStackSize() - currentStack.getCount(), 1);
                                currentStack.grow(amountToAdd);
                                chanceOutput2Placed = true;
                                this.setChanged();
                            }
                            if (chanceOutput2Placed) break;
                        }
                    }
                    if (Math.random() < recipe.chanceOutputChance3()) {
                        for (slot = 4; slot <= 7; ++slot) {
                            currentStack = this.itemHandler.getStackInSlot(slot);
                            if (currentStack.isEmpty()) {
                                this.itemHandler.setStackInSlot(slot, new ItemStack((ItemLike)chanceOutput3));
                                chanceOutput3Placed = true;
                                this.setChanged();
                            } else if (currentStack.getItem() == chanceOutput3 && currentStack.getCount() < currentStack.getMaxStackSize()) {
                                amountToAdd = Math.min(currentStack.getMaxStackSize() - currentStack.getCount(), 1);
                                currentStack.grow(amountToAdd);
                                chanceOutput3Placed = true;
                                this.setChanged();
                            }
                            if (chanceOutput3Placed) break;
                        }
                    }
                    if (mainOutputPlaced || chanceOutput1Placed || chanceOutput2Placed || chanceOutput3Placed) {
                        this.progress = 0;
                    }
                }
            }
            if (!validRecipeFound) {
                this.maxProgress = originalMaxProgress;
            }
        }
    }
}

