/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities.block;

import com.benbenlaw.opolisutilities.block.custom.BlockBreakerBlock;
import com.benbenlaw.opolisutilities.block.custom.BlockPlacerBlock;
import com.benbenlaw.opolisutilities.block.custom.CatalogueBlock;
import com.benbenlaw.opolisutilities.block.custom.ClocheBlock;
import com.benbenlaw.opolisutilities.block.custom.CrafterBlock;
import com.benbenlaw.opolisutilities.block.custom.DryingTableBlock;
import com.benbenlaw.opolisutilities.block.custom.EnderOreBlock;
import com.benbenlaw.opolisutilities.block.custom.EnderScramblerBlock;
import com.benbenlaw.opolisutilities.block.custom.FluidGeneratorBlock;
import com.benbenlaw.opolisutilities.block.custom.ItemRepairerBlock;
import com.benbenlaw.opolisutilities.block.custom.RedstoneClockBlock;
import com.benbenlaw.opolisutilities.block.custom.ResourceGeneratorBlock;
import com.benbenlaw.opolisutilities.block.custom.SmartCraftingTableBlock;
import com.benbenlaw.opolisutilities.block.custom.SummoningBlock;
import com.benbenlaw.opolisutilities.item.ModItems;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"opolisutilities");
    public static final DeferredBlock<Block> FLOATING_BLOCK = ModBlocks.registerBlockWithoutBlockItem("floating_block_block", () -> new Block(BlockBehaviour.Properties.of().instabreak()));
    public static final DeferredBlock<Block> DRYING_TABLE = ModBlocks.registerBlock("drying_table", () -> new DryingTableBlock(BlockBehaviour.Properties.of().strength(2.0f, 2.0f).noOcclusion()));
    public static final DeferredBlock<Block> CRAFTER = ModBlocks.registerBlock("crafter", () -> new CrafterBlock(BlockBehaviour.Properties.of().strength(2.0f, 2.0f).noOcclusion()));
    public static final DeferredBlock<Block> BLOCK_PLACER = ModBlocks.registerBlock("block_placer", () -> new BlockPlacerBlock(BlockBehaviour.Properties.of().strength(2.0f, 2.0f).noOcclusion()));
    public static final DeferredBlock<Block> BLOCK_BREAKER = ModBlocks.registerBlock("block_breaker", () -> new BlockBreakerBlock(BlockBehaviour.Properties.of().strength(2.0f, 2.0f).noOcclusion()));
    public static final DeferredBlock<Block> ITEM_REPAIRER = ModBlocks.registerBlock("item_repairer", () -> new ItemRepairerBlock(BlockBehaviour.Properties.of().strength(2.0f, 2.0f).noOcclusion()));
    public static final DeferredBlock<Block> RESOURCE_GENERATOR = ModBlocks.registerBlock("resource_generator", () -> new ResourceGeneratorBlock(BlockBehaviour.Properties.of().strength(2.0f, 2.0f).noOcclusion()));
    public static final DeferredBlock<Block> FLUID_GENERATOR = ModBlocks.registerBlock("fluid_generator", () -> new FluidGeneratorBlock(BlockBehaviour.Properties.of().strength(2.0f, 2.0f).noOcclusion()));
    public static final DeferredBlock<Block> CATALOGUE = ModBlocks.registerBlock("catalogue", () -> new CatalogueBlock(BlockBehaviour.Properties.of().strength(2.0f, 2.0f).noOcclusion()));
    public static final DeferredBlock<Block> SUMMONING_BLOCK = ModBlocks.registerBlock("summoning_block", () -> new SummoningBlock(BlockBehaviour.Properties.of().strength(2.0f, 2.0f).noOcclusion()));
    public static final DeferredBlock<Block> CLOCHE = ModBlocks.registerBlock("cloche", () -> new ClocheBlock(BlockBehaviour.Properties.of().strength(2.0f, 2.0f).noOcclusion()));
    public static final DeferredBlock<Block> REDSTONE_CLOCK = ModBlocks.registerBlock("redstone_clock", () -> new RedstoneClockBlock(BlockBehaviour.Properties.of().strength(2.0f, 2.0f).noOcclusion()));
    public static final DeferredBlock<Block> ENDER_ORE = ModBlocks.registerBlock("ender_ore", () -> new EnderOreBlock(BlockBehaviour.Properties.of().strength(3.0f, 3.0f).requiresCorrectToolForDrops().sound(SoundType.STONE).lightLevel(ModBlocks.litBlockEmission())));
    public static final DeferredBlock<Block> DEEPSLATE_ENDER_ORE = ModBlocks.registerBlock("deepslate_ender_ore", () -> new EnderOreBlock(BlockBehaviour.Properties.of().strength(4.5f, 3.0f).requiresCorrectToolForDrops().sound(SoundType.DEEPSLATE).lightLevel(ModBlocks.litBlockEmission())));
    public static final DeferredBlock<Block> ENDER_SCRAMBLER = ModBlocks.registerBlock("ender_scrambler", () -> new EnderScramblerBlock(BlockBehaviour.Properties.of().strength(4.5f, 3.0f).requiresCorrectToolForDrops().sound(SoundType.STONE)));
    public static final DeferredBlock<Block> SMART_CRAFTING_TABLE = ModBlocks.registerBlock("smart_crafting_table", () -> new SmartCraftingTableBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ACACIA_PLANKS).sound(SoundType.WOOD)));

    private static ToIntFunction<BlockState> litBlockEmission() {
        return lightLevel -> (Boolean)lightLevel.getValue((Property)BlockStateProperties.LIT) != false ? 9 : 0;
    }

    private static <T extends Block> DeferredBlock<T> registerBlockWithoutBlockItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

