/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.opolisutilities;

import com.benbenlaw.opolisutilities.block.ModBlocks;
import com.benbenlaw.opolisutilities.block.entity.ModBlockEntities;
import com.benbenlaw.opolisutilities.config.ConfigFile;
import com.benbenlaw.opolisutilities.config.StartupBlockConfigFile;
import com.benbenlaw.opolisutilities.config.StartupItemConfigFile;
import com.benbenlaw.opolisutilities.item.ModCreativeTab;
import com.benbenlaw.opolisutilities.item.ModDataComponents;
import com.benbenlaw.opolisutilities.item.ModItems;
import com.benbenlaw.opolisutilities.networking.ModMessages;
import com.benbenlaw.opolisutilities.particles.ModParticles;
import com.benbenlaw.opolisutilities.recipe.ModRecipes;
import com.benbenlaw.opolisutilities.screen.ModMenuTypes;
import com.benbenlaw.opolisutilities.screen.custom.BlockBreakerScreen;
import com.benbenlaw.opolisutilities.screen.custom.BlockPlacerScreen;
import com.benbenlaw.opolisutilities.screen.custom.CatalogueScreen;
import com.benbenlaw.opolisutilities.screen.custom.ClocheScreen;
import com.benbenlaw.opolisutilities.screen.custom.CrafterScreen;
import com.benbenlaw.opolisutilities.screen.custom.DryingTableScreen;
import com.benbenlaw.opolisutilities.screen.custom.EnderScramblerScreen;
import com.benbenlaw.opolisutilities.screen.custom.FluidGeneratorScreen;
import com.benbenlaw.opolisutilities.screen.custom.ItemRepairerScreen;
import com.benbenlaw.opolisutilities.screen.custom.RedstoneClockScreen;
import com.benbenlaw.opolisutilities.screen.custom.ResourceGeneratorScreen;
import com.benbenlaw.opolisutilities.screen.custom.SmartCraftingScreen;
import com.benbenlaw.opolisutilities.screen.custom.SummoningBlockScreen;
import com.benbenlaw.opolisutilities.sound.ModSounds;
import com.benbenlaw.opolisutilities.util.ModAttachments;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.common.world.chunk.RegisterTicketControllersEvent;
import net.neoforged.neoforge.common.world.chunk.TicketController;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="opolisutilities")
public class OpolisUtilities {
    public static final String MOD_ID = "opolisutilities";
    public static final Logger LOGGER = LogManager.getLogger();

    public OpolisUtilities(IEventBus modEventBus) {
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)StartupItemConfigFile.SPEC, "opolisutilities/items.toml");
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.STARTUP, (IConfigSpec)StartupBlockConfigFile.SPEC, "opolisutilities/blocks.toml");
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ConfigFile.SPEC, "opolis_utilities.toml");
        ModItems.register(modEventBus);
        ModDataComponents.COMPONENTS.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModCreativeTab.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModAttachments.register(modEventBus);
        modEventBus.addListener(this::registerCapabilities);
        ModRecipes.register(modEventBus);
        ModParticles.register(modEventBus);
        ModSounds.register(modEventBus);
        modEventBus.addListener(this::commonSetup);
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
        ModBlockEntities.registerCapabilities(event);
    }

    public void commonSetup(RegisterPayloadHandlersEvent event) {
        ModMessages.registerNetworking(event);
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
    public static class ClientModEvents {
        @SubscribeEvent
        public static void registerScreens(RegisterMenuScreensEvent event) {
            event.register((MenuType)ModMenuTypes.BLOCK_BREAKER_MENU.get(), BlockBreakerScreen::new);
            event.register((MenuType)ModMenuTypes.BLOCK_PLACER_MENU.get(), BlockPlacerScreen::new);
            event.register((MenuType)ModMenuTypes.DRYING_TABLE_MENU.get(), DryingTableScreen::new);
            event.register((MenuType)ModMenuTypes.RESOURCE_GENERATOR_MENU.get(), ResourceGeneratorScreen::new);
            event.register((MenuType)ModMenuTypes.ITEM_REPAIRER_MENU.get(), ItemRepairerScreen::new);
            event.register((MenuType)ModMenuTypes.CATALOGUE_MENU.get(), CatalogueScreen::new);
            event.register((MenuType)ModMenuTypes.CRAFTER_MENU.get(), CrafterScreen::new);
            event.register((MenuType)ModMenuTypes.REDSTONE_CLOCK_MENU.get(), RedstoneClockScreen::new);
            event.register((MenuType)ModMenuTypes.ENDER_SCRAMBLER_MENU.get(), EnderScramblerScreen::new);
            event.register((MenuType)ModMenuTypes.FLUID_GENERATOR_MENU.get(), FluidGeneratorScreen::new);
            event.register((MenuType)ModMenuTypes.SUMMONING_BLOCK_MENU.get(), SummoningBlockScreen::new);
            event.register((MenuType)ModMenuTypes.CLOCHE_MENU.get(), ClocheScreen::new);
            event.register((MenuType)ModMenuTypes.SMART_CRAFTING_MENU.get(), SmartCraftingScreen::new);
        }
    }

    @EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
    public static class CommonModEvents {
        @SubscribeEvent
        public static void registerTickControllers(RegisterTicketControllersEvent event) {
            event.register(new TicketController(ResourceLocation.fromNamespaceAndPath((String)OpolisUtilities.MOD_ID, (String)"portable_gui")));
            System.out.println("Registered ticket controller");
        }
    }
}

