/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.network;

import java.util.Map;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import mcjty.rftoolsutility.modules.screen.network.PacketReturnScreenData;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record PacketGetScreenData(String modid, GlobalPos pos, Long millis) implements CustomPacketPayload
{
    public static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"rftoolsutility", (String)"getscreendata");
    public static final CustomPacketPayload.Type<PacketGetScreenData> TYPE = new CustomPacketPayload.Type(ID);
    public static final StreamCodec<FriendlyByteBuf, PacketGetScreenData> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, PacketGetScreenData::modid, (StreamCodec)GlobalPos.STREAM_CODEC, b -> b.pos(), (StreamCodec)ByteBufCodecs.VAR_LONG, PacketGetScreenData::millis, PacketGetScreenData::new);

    public static PacketGetScreenData create(String modid, GlobalPos pos, long millis) {
        return new PacketGetScreenData(modid, pos, millis);
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            BlockEntity patt0$temp;
            Player player = ctx.player();
            Level world = player.getCommandSenderWorld();
            if ((world = LevelTools.getLevel((Level)world, (ResourceKey)this.pos.dimension())).hasChunkAt(this.pos.pos()) && (patt0$temp = world.getBlockEntity(this.pos.pos())) instanceof ScreenTileEntity) {
                ScreenTileEntity screen = (ScreenTileEntity)patt0$temp;
                Map<Integer, IModuleData> screenData = screen.getScreenData(this.millis);
                PacketReturnScreenData msg = new PacketReturnScreenData(this.pos, screenData);
                RFToolsUtilityMessages.sendToPlayer(msg, player);
            }
        });
    }
}

