/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.items.modules;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.api.machineinfo.CapabilityMachineInformation;
import mcjty.rftoolsbase.api.machineinfo.IMachineInformation;
import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleGuiBuilder;
import mcjty.rftoolsbase.api.screens.IModuleProvider;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolsbase.tools.GenericModuleItem;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.screen.ScreenConfiguration;
import mcjty.rftoolsutility.modules.screen.ScreenModule;
import mcjty.rftoolsutility.modules.screen.modules.MachineInformationScreenModule;
import mcjty.rftoolsutility.modules.screen.modulesclient.MachineInformationClientScreenModule;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class MachineInformationModuleItem
extends GenericModuleItem
implements IModuleProvider {
    private static final IModuleGuiBuilder.Choice[] EMPTY_CHOICES = new IModuleGuiBuilder.Choice[0];

    public MachineInformationModuleItem() {
        super(RFToolsUtility.setup.defaultProperties().stacksTo(1).durability(1));
    }

    @Nullable
    public Codec<? extends IScreenModule<?, ?>> codec() {
        return MachineInformationScreenModule.CODEC;
    }

    @Nullable
    public StreamCodec<RegistryFriendlyByteBuf, ? extends IScreenModule<?, ?>> streamCodec() {
        return MachineInformationScreenModule.STREAM_CODEC;
    }

    @Nullable
    public DataComponentType<? extends IScreenModule<?, ?>> componentType() {
        return (DataComponentType)ScreenModule.MODULE_MACHINEINFO_DATA.get();
    }

    public IScreenModule<?, ?> createServerScreenModule() {
        return MachineInformationScreenModule.DEFAULT;
    }

    public IClientScreenModule<?> createClientScreenModule() {
        return new MachineInformationClientScreenModule();
    }

    protected int getUses(ItemStack stack) {
        return (Integer)ScreenConfiguration.MACHINEINFO_RFPERTICK.get();
    }

    protected boolean hasGoldMessage(ItemStack stack) {
        return !BlockPosTools.isValid((BlockPos)MachineInformationModuleItem.data(stack).getPos().pos());
    }

    protected String getInfoString(ItemStack stack) {
        MachineInformationScreenModule data = MachineInformationModuleItem.data(stack);
        return ModuleTools.getTargetString((String)data.getMonitor(), (GlobalPos)data.getPos());
    }

    public String getModuleName() {
        return "Info";
    }

    public static MachineInformationScreenModule data(ItemStack stack) {
        MachineInformationScreenModule data = (MachineInformationScreenModule)stack.get(ScreenModule.MODULE_MACHINEINFO_DATA);
        if (data == null) {
            data = MachineInformationScreenModule.DEFAULT;
        }
        return data;
    }

    public static void data(ItemStack stack, Function<MachineInformationScreenModule, MachineInformationScreenModule> setter) {
        MachineInformationScreenModule data = MachineInformationModuleItem.data(stack);
        data = setter.apply(data);
        stack.set(ScreenModule.MODULE_MACHINEINFO_DATA, (Object)data);
    }

    public void createGui(IModuleGuiBuilder guiBuilder) {
        IMachineInformation capability;
        BlockEntity tileEntity;
        Level world = guiBuilder.getWorld();
        MachineInformationScreenModule currentData = MachineInformationModuleItem.data(guiBuilder.getCurrentModule());
        IModuleGuiBuilder.Choice[] choices = EMPTY_CHOICES;
        if (currentData.getPos().dimension().equals(world.dimension()) && (tileEntity = world.getBlockEntity(currentData.getPos().pos())) != null && (capability = (IMachineInformation)world.getCapability(CapabilityMachineInformation.MACHINE_INFORMATION_CAPABILITY, currentData.getPos().pos(), null)) != null) {
            int count = capability.getTagCount();
            IModuleGuiBuilder.Choice[] cs = new IModuleGuiBuilder.Choice[count];
            for (int i = 0; i < count; ++i) {
                cs[i] = new IModuleGuiBuilder.Choice(capability.getTagName(i), new String[]{capability.getTagDescription(i)});
            }
            choices = cs;
        }
        guiBuilder.label("L:").color((stack, c) -> MachineInformationModuleItem.data(stack).withLabcolor((int)c), stack -> MachineInformationModuleItem.data(stack).getLabcolor(), new String[]{"Color for the label"}).label("Txt:").color((stack, c) -> MachineInformationModuleItem.data(stack).withTxtcolor((int)c), stack -> MachineInformationModuleItem.data(stack).getTxtcolor(), new String[]{"Color for the text"}).nl().choices((stack, s) -> MachineInformationModuleItem.data(stack, d -> d.withTag((int)s)), stack -> MachineInformationModuleItem.data(stack).getTag(), choices).nl().block(stack -> MachineInformationModuleItem.data(stack).getPos(), stack -> MachineInformationModuleItem.data(stack).getMonitor()).nl();
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction facing = context.getClickedFace();
        Player player = context.getPlayer();
        BlockEntity te = world.getBlockEntity(pos);
        MachineInformationScreenModule data = MachineInformationModuleItem.data(stack);
        IMachineInformation capability = (IMachineInformation)world.getCapability(CapabilityMachineInformation.MACHINE_INFORMATION_CAPABILITY, pos, null);
        if (te != null && capability != null) {
            data = data.withPos(GlobalPos.of((ResourceKey)world.dimension(), (BlockPos)pos));
            String name = "<invalid>";
            if (!world.getBlockState(pos).isAir()) {
                name = Tools.getReadableName((Level)world, (BlockPos)pos);
            }
            data = data.withMonitor(name);
            if (world.isClientSide) {
                Logging.message((Player)player, (String)("Machine Information module is set to block '" + name + "'"));
            }
        } else {
            data = data.withPos(GlobalPos.of((ResourceKey)Level.OVERWORLD, (BlockPos)BlockPosTools.INVALID));
            data = data.withMonitor("");
            if (world.isClientSide) {
                Logging.message((Player)player, (String)"Machine Information module is cleared");
            }
        }
        stack.set(ScreenModule.MODULE_MACHINEINFO_DATA, (Object)data);
        return InteractionResult.SUCCESS;
    }
}

