/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public record ScreenData(int size, boolean transparent, int color, boolean bright, int trueTypeMode) {
    public static final Codec<ScreenData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("size").forGetter(ScreenData::size), (App)Codec.BOOL.fieldOf("transparent").forGetter(ScreenData::transparent), (App)Codec.INT.fieldOf("color").forGetter(ScreenData::color), (App)Codec.BOOL.fieldOf("bright").forGetter(ScreenData::bright), (App)Codec.INT.fieldOf("truetype").forGetter(ScreenData::trueTypeMode)).apply((Applicative)instance, ScreenData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ScreenData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, ScreenData::size, (StreamCodec)ByteBufCodecs.BOOL, ScreenData::transparent, (StreamCodec)ByteBufCodecs.INT, ScreenData::color, (StreamCodec)ByteBufCodecs.BOOL, ScreenData::bright, (StreamCodec)ByteBufCodecs.INT, ScreenData::trueTypeMode, ScreenData::new);

    public static ScreenData createDefault() {
        return new ScreenData(0, false, 0, false, 0);
    }

    public ScreenData withSize(int size) {
        return new ScreenData(size, this.transparent, this.color, this.bright, this.trueTypeMode);
    }

    public ScreenData withTransparent(boolean transparent) {
        return new ScreenData(this.size, transparent, this.color, this.bright, this.trueTypeMode);
    }

    public ScreenData withColor(int color) {
        return new ScreenData(this.size, this.transparent, color, this.bright, this.trueTypeMode);
    }

    public ScreenData withBright(boolean bright) {
        return new ScreenData(this.size, this.transparent, this.color, bright, this.trueTypeMode);
    }

    public ScreenData withTrueTypeMode(int trueTypeMode) {
        return new ScreenData(this.size, this.transparent, this.color, this.bright, trueTypeMode);
    }
}

