/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.environmental.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import mcjty.rftoolsutility.modules.environmental.recipes.SyringeBasedRecipe;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapedRecipePattern;

public class SyringeRecipeSerializer
implements RecipeSerializer<SyringeBasedRecipe> {
    private final ShapedRecipe.Serializer serializer = new ShapedRecipe.Serializer();
    public static final MapCodec<SyringeBasedRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("group").forGetter(recipe -> recipe.getGroup()), (App)ShapedRecipePattern.MAP_CODEC.fieldOf("pattern").forGetter(recipe -> recipe.pattern), (App)ItemStack.CODEC.fieldOf("result").forGetter(recipe -> recipe.getResultItem(null)), (App)ResourceLocation.CODEC.fieldOf("mob").forGetter(SyringeBasedRecipe::getMobId), (App)Codec.INT.fieldOf("syringe").forGetter(SyringeBasedRecipe::getSyringeIndex)).apply((Applicative)instance, SyringeBasedRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyringeBasedRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
        buf.writeUtf(recipe.getGroup());
        ShapedRecipePattern.STREAM_CODEC.encode(buf, (Object)recipe.pattern);
        ItemStack.STREAM_CODEC.encode(buf, (Object)recipe.getResultItem(null));
        buf.writeResourceLocation(recipe.getMobId());
        buf.writeInt(recipe.getSyringeIndex());
    }, buf -> {
        String group = buf.readUtf(Short.MAX_VALUE);
        ShapedRecipePattern pattern = (ShapedRecipePattern)ShapedRecipePattern.STREAM_CODEC.decode(buf);
        ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
        ResourceLocation mobId = buf.readResourceLocation();
        int syringeIndex = buf.readInt();
        return new SyringeBasedRecipe(group, pattern, result, mobId, syringeIndex);
    });

    public MapCodec<SyringeBasedRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, SyringeBasedRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

