/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import dev.latvian.mods.kubejs.KubeJSPaths;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import moe.wolfgirl.probejs.ProbeJS;
import moe.wolfgirl.probejs.utils.JsonUtils;

public class ProbeFileUtils {
    public static void forEachFile(Path basePath, Consumer<Path> callback) throws IOException {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(basePath);){
            for (Path path : dirStream) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    ProbeFileUtils.forEachFile(path, callback);
                    continue;
                }
                callback.accept(path);
            }
        }
    }

    public static void writeMergedConfig(Path path, String config) throws IOException {
        JsonObject read;
        JsonObject updates = (JsonObject)ProbeJS.GSON.fromJson(config, JsonObject.class);
        JsonObject jsonObject = read = Files.exists(path, new LinkOption[0]) ? (JsonObject)ProbeJS.GSON.fromJson((Reader)Files.newBufferedReader(path), JsonObject.class) : new JsonObject();
        if (read == null) {
            read = new JsonObject();
        }
        JsonObject original = (JsonObject)JsonUtils.mergeJsonRecursively((JsonElement)read, (JsonElement)updates);
        JsonWriter jsonWriter = ProbeJS.GSON_WRITER.newJsonWriter((Writer)Files.newBufferedWriter(path, new OpenOption[0]));
        jsonWriter.setIndent("    ");
        ProbeJS.GSON_WRITER.toJson((Object)original, JsonObject.class, jsonWriter);
        jsonWriter.close();
    }

    @Nullable
    public static Path parseSourcePath(String name) {
        Path base;
        if (!name.contains(":")) {
            return null;
        }
        String[] parts = name.split(":", 2);
        String string = parts[0];
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"client_scripts", "server_scripts", "startup_scripts"}, (Object)string, n)) {
            case 0: {
                Path path = KubeJSPaths.CLIENT_SCRIPTS;
                break;
            }
            case 1: {
                Path path = KubeJSPaths.SERVER_SCRIPTS;
                break;
            }
            case 2: {
                Path path = KubeJSPaths.STARTUP_SCRIPTS;
                break;
            }
            default: {
                Path path = base = null;
            }
        }
        if (base == null) {
            return null;
        }
        return base.resolve(parts[1]);
    }
}

