/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class JsonUtils {
    private static final Pattern MATCH_TRAILING = Pattern.compile(",(?!\\s*?[{\\[\"'\\w])");

    public static String stripSussyJson5Stuffs(String jsonc) {
        StringBuilder sb = new StringBuilder();
        block0: for (String line : jsonc.lines()::iterator) {
            String[] parts = line.strip().split("//");
            boolean enclosed = false;
            int quotes = 0;
            int escaped = 0;
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                if (enclosed) continue block0;
                if (i != 0) {
                    sb.append("//");
                }
                sb.append(part);
                enclosed = ((quotes += StringUtils.countMatches((CharSequence)part, (CharSequence)"\"")) - (escaped += StringUtils.countMatches((CharSequence)part, (CharSequence)"\\\""))) % 2 == 0;
            }
        }
        return MATCH_TRAILING.matcher(sb.toString()).replaceAll("").strip();
    }

    public static JsonArray asStringArray(Collection<String> array) {
        JsonArray jsonArray = new JsonArray();
        for (String s : array) {
            jsonArray.add(s);
        }
        return jsonArray;
    }

    public static JsonElement parseObject(Object obj) {
        if (obj instanceof Number) {
            Number number = (Number)obj;
            return new JsonPrimitive(number);
        }
        if (obj instanceof String) {
            String string = (String)obj;
            return new JsonPrimitive(string);
        }
        if (obj instanceof Boolean) {
            Boolean bool = (Boolean)obj;
            return new JsonPrimitive(bool);
        }
        if (obj instanceof List) {
            List list = (List)obj;
            JsonArray jsonArray = new JsonArray(list.size());
            for (Object o : list) {
                jsonArray.add(JsonUtils.parseObject(o));
            }
            return jsonArray;
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            JsonObject object = new JsonObject();
            for (Map.Entry entry : map.entrySet()) {
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (!(k instanceof String)) continue;
                String s = (String)k;
                object.add(s, JsonUtils.parseObject(v));
            }
            return object;
        }
        return JsonNull.INSTANCE;
    }

    public static Object deserializeObject(JsonElement jsonElement) {
        if (jsonElement instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)jsonElement;
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isString()) {
                return primitive.getAsString();
            }
            if (primitive.isNumber()) {
                return primitive.getAsNumber();
            }
        } else {
            if (jsonElement instanceof JsonArray) {
                JsonArray array = (JsonArray)jsonElement;
                ArrayList<Object> deserialized = new ArrayList<Object>();
                for (JsonElement element : array) {
                    deserialized.add(JsonUtils.deserializeObject(element));
                }
                return deserialized;
            }
            if (jsonElement instanceof JsonObject) {
                JsonObject object = (JsonObject)jsonElement;
                HashMap<String, Object> deserialized = new HashMap<String, Object>();
                for (String s : object.keySet()) {
                    deserialized.put(s, JsonUtils.deserializeObject(object.get(s)));
                }
                return deserialized;
            }
        }
        return null;
    }

    public static JsonElement mergeJsonRecursively(JsonElement first, JsonElement second) {
        if (first instanceof JsonObject) {
            JsonObject firstObject = (JsonObject)first;
            if (second instanceof JsonObject) {
                JsonObject secondObject = (JsonObject)second;
                JsonObject result = firstObject.deepCopy();
                for (Map.Entry entry : secondObject.entrySet()) {
                    String key = (String)entry.getKey();
                    JsonElement value = (JsonElement)entry.getValue();
                    if (result.has(key)) {
                        result.add(key, JsonUtils.mergeJsonRecursively(result.get(key), value));
                        continue;
                    }
                    result.add(key, value);
                }
                return result;
            }
        }
        if (first instanceof JsonArray) {
            JsonArray firstArray = (JsonArray)first;
            if (second instanceof JsonArray) {
                JsonArray secondArray = (JsonArray)second;
                ArrayList<JsonElement> elements = new ArrayList<JsonElement>();
                for (JsonElement element : firstArray) {
                    elements.add(element.deepCopy());
                }
                for (JsonElement element : secondArray) {
                    int index = elements.indexOf(element);
                    if (index != -1) {
                        elements.set(index, JsonUtils.mergeJsonRecursively((JsonElement)elements.get(index), element));
                        continue;
                    }
                    elements.add(element);
                }
                JsonArray result = new JsonArray();
                for (JsonElement element : elements) {
                    result.add(element);
                }
                return result;
            }
        }
        return second;
    }

    public static JsonElement errorAsPayload(Throwable throwable) {
        JsonObject object = new JsonObject();
        object.addProperty("message", throwable.getMessage());
        JsonArray jsonArray = new JsonArray();
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            jsonArray.add(stackTraceElement.toString());
        }
        object.add("stackTrace", (JsonElement)jsonArray);
        return object;
    }

    public static <T> JsonElement forceEncodeAsJson(Codec<T> codec, Object value) {
        return (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value).result().orElse(JsonNull.INSTANCE);
    }

    public static class PathConverter
    implements JsonDeserializer<Path>,
    JsonSerializer<Path> {
        public Path deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Paths.get(json.getAsString(), new String[0]);
        }

        public JsonElement serialize(Path src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(src.toString());
        }
    }
}

