/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.utils;

import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class ImageUtils {
    private static final Lock LOCK = new ReentrantLock();

    public static NativeImage renderItem(ItemStack itemStack, int width, int height) {
        LOCK.lock();
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.player == null) {
            return null;
        }
        NativeImage image = new NativeImage(width, height, false);
        minecraft.executeBlocking(() -> {
            MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
            TextureTarget renderTarget = new TextureTarget(width, height, true, false);
            renderTarget.bindWrite(true);
            Matrix4f matrix = new Matrix4f().setOrtho(0.0f, 16.0f, 16.0f, 0.0f, 1000.0f, 21000.0f);
            RenderSystem.setProjectionMatrix((Matrix4f)matrix, (VertexSorting)VertexSorting.ORTHOGRAPHIC_Z);
            Matrix4fStack matrix4fStack = RenderSystem.getModelViewStack();
            matrix4fStack.pushMatrix();
            matrix4fStack.translation(0.0f, 0.0f, -11000.0f);
            RenderSystem.applyModelViewMatrix();
            GuiGraphics graphics = new GuiGraphics(minecraft, bufferSource);
            graphics.renderItem((LivingEntity)minecraft.player, itemStack, 0, 0, 0);
            graphics.renderItemDecorations(minecraft.font, itemStack, 0, 0);
            graphics.flush();
            renderTarget.bindRead();
            RenderSystem.bindTexture((int)renderTarget.getColorTextureId());
            image.downloadTexture(0, false);
            image.flipY();
            renderTarget.unbindRead();
            renderTarget.unbindWrite();
            matrix4fStack.popMatrix();
            RenderSystem.applyModelViewMatrix();
            renderTarget.destroyBuffers();
        });
        LOCK.unlock();
        return image;
    }
}

