/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.typescript.code.type.js;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.stream.Collectors;
import moe.wolfgirl.probejs.lang.typescript.Declaration;
import moe.wolfgirl.probejs.lang.typescript.code.ImportInfo;
import moe.wolfgirl.probejs.lang.typescript.code.type.BaseType;
import moe.wolfgirl.probejs.lang.typescript.code.type.js.JSParam;

public abstract class JSMemberType
extends BaseType {
    public final Collection<JSParam> members;

    protected JSMemberType(Collection<JSParam> members) {
        this.members = members;
    }

    @Override
    public Collection<ImportInfo> getUsedImports() {
        HashSet<ImportInfo> paths = new HashSet<ImportInfo>();
        for (JSParam member : this.members) {
            paths.addAll(member.type().getUsedImports());
        }
        return paths;
    }

    protected String formatMembers(Declaration declaration, BaseType.FormatType type) {
        return this.formatMembers(declaration, type, ", ");
    }

    protected String formatMembers(Declaration declaration, BaseType.FormatType type, String delimiter) {
        return this.members.stream().map(m -> m.format(declaration, type, this::getMemberName)).collect(Collectors.joining(delimiter));
    }

    protected abstract String getMemberName(String var1);

    public static abstract class Builder<T extends Builder<T, O>, O extends BaseType> {
        public final Collection<JSParam> members = new ArrayList<JSParam>();

        public T member(String name, BaseType type) {
            return this.member(name, false, type);
        }

        public T member(String name, boolean optional, BaseType type) {
            this.members.add(new JSParam(name, optional, type));
            return (T)this;
        }

        public abstract O build();
    }
}

