/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.typescript.code.type;

import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import moe.wolfgirl.probejs.ProbeJS;
import moe.wolfgirl.probejs.lang.java.clazz.ClassPath;
import moe.wolfgirl.probejs.lang.typescript.Declaration;
import moe.wolfgirl.probejs.lang.typescript.code.ImportInfo;
import moe.wolfgirl.probejs.lang.typescript.code.type.BaseType;
import moe.wolfgirl.probejs.lang.typescript.code.type.ContextShield;
import moe.wolfgirl.probejs.lang.typescript.code.type.CustomType;
import moe.wolfgirl.probejs.lang.typescript.code.type.ImportShield;
import moe.wolfgirl.probejs.lang.typescript.code.type.TSClassType;
import moe.wolfgirl.probejs.lang.typescript.code.type.TSOptionalType;
import moe.wolfgirl.probejs.lang.typescript.code.type.TSParamType;
import moe.wolfgirl.probejs.lang.typescript.code.type.TSVariableType;
import moe.wolfgirl.probejs.lang.typescript.code.type.js.JSArrayType;
import moe.wolfgirl.probejs.lang.typescript.code.type.js.JSJoinedType;
import moe.wolfgirl.probejs.lang.typescript.code.type.js.JSLambdaType;
import moe.wolfgirl.probejs.lang.typescript.code.type.js.JSObjectType;
import moe.wolfgirl.probejs.lang.typescript.code.type.js.JSPrimitiveType;
import moe.wolfgirl.probejs.lang.typescript.code.type.js.JSTypeOfType;

public interface Types {
    public static final JSPrimitiveType ANY = new JSPrimitiveType("any");
    public static final JSPrimitiveType BOOLEAN = new JSPrimitiveType("boolean");
    public static final JSPrimitiveType NUMBER = new JSPrimitiveType("number");
    public static final JSPrimitiveType STRING = new JSPrimitiveType("string");
    public static final JSPrimitiveType NEVER = new JSPrimitiveType("never");
    public static final JSPrimitiveType UNKNOWN = new JSPrimitiveType("unknown");
    public static final JSPrimitiveType VOID = new JSPrimitiveType("void");
    public static final JSPrimitiveType THIS = new JSPrimitiveType("this");
    public static final JSPrimitiveType OBJECT = new JSPrimitiveType("object");
    public static final JSPrimitiveType NULL = new JSPrimitiveType("null");
    public static final JSArrayType EMPTY_ARRAY = Types.arrayOf().build();

    public static JSPrimitiveType literal(Object content) {
        if (!(content instanceof String || content instanceof Number || content instanceof Boolean)) {
            return ANY;
        }
        return new JSPrimitiveType(ProbeJS.GSON.toJson(content));
    }

    public static JSPrimitiveType primitive(String type) {
        return new JSPrimitiveType(type);
    }

    public static JSArrayType.Builder arrayOf() {
        return new JSArrayType.Builder();
    }

    public static JSJoinedType.Intersection and(BaseType ... types) {
        return new JSJoinedType.Intersection(Arrays.stream(types).toList());
    }

    public static BaseType or(BaseType ... types) {
        if (types.length == 0) {
            return NEVER;
        }
        return new JSJoinedType.Union(Arrays.stream(types).toList());
    }

    public static TSParamType parameterized(BaseType base, BaseType ... params) {
        return new TSParamType(base, Arrays.stream(params).toList());
    }

    public static TSVariableType generic(String symbol) {
        return Types.generic(symbol, ANY);
    }

    public static TSVariableType generic(String symbol, BaseType extendOn) {
        return new TSVariableType(symbol, extendOn);
    }

    public static BaseType typeMaybeGeneric(Class<?> clazz) {
        if (clazz.getTypeParameters().length == 0) {
            return Types.type(clazz);
        }
        BaseType[] params = (BaseType[])Collections.nCopies(clazz.getTypeParameters().length, ANY).toArray(BaseType[]::new);
        return Types.parameterized(Types.type(clazz), params);
    }

    public static TSClassType type(Class<?> clazz) {
        return Types.type(new ClassPath(clazz));
    }

    public static TSClassType type(ClassPath classPath) {
        return new TSClassType(classPath);
    }

    public static JSTypeOfType typeOf(Class<?> clazz) {
        return Types.typeOf(new ClassPath(clazz));
    }

    public static JSTypeOfType typeOf(ClassPath classPath) {
        return Types.typeOf(new TSClassType(classPath));
    }

    public static JSTypeOfType typeOf(BaseType classType) {
        return new JSTypeOfType(classType);
    }

    public static BaseType ignoreContext(BaseType type, BaseType.FormatType formatType) {
        return new ContextShield(type, formatType);
    }

    public static BaseType ignoreImport(BaseType type, ImportInfo.Type importType) {
        return new ImportShield(type, importType);
    }

    public static BaseType custom(BiFunction<Declaration, BaseType.FormatType, String> formatter, ImportInfo ... imports) {
        return new CustomType(formatter, imports);
    }

    public static JSLambdaType.Builder lambda() {
        return new JSLambdaType.Builder();
    }

    public static JSObjectType.Builder object() {
        return new JSObjectType.Builder();
    }

    public static TSOptionalType optional(BaseType type) {
        return new TSOptionalType(type);
    }

    public static BaseType filter(BaseType type, Predicate<BaseType> typePredicate) {
        BaseType baseType = type;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JSJoinedType.Union.class, JSJoinedType.Intersection.class}, (Object)baseType, n)) {
            case 0 -> {
                JSJoinedType.Union union = (JSJoinedType.Union)baseType;
                yield new JSJoinedType.Union(union.types.stream().filter(t -> !typePredicate.test((BaseType)t)).map(t -> Types.filter(t, typePredicate)).toList());
            }
            case 1 -> {
                JSJoinedType.Intersection intersection = (JSJoinedType.Intersection)baseType;
                yield new JSJoinedType.Intersection(intersection.types.stream().filter(t -> !typePredicate.test((BaseType)t)).map(t -> Types.filter(t, typePredicate)).toList());
            }
            default -> type;
        };
    }
}

