/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.typescript.code.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import moe.wolfgirl.probejs.lang.typescript.Declaration;
import moe.wolfgirl.probejs.lang.typescript.code.ImportInfo;
import moe.wolfgirl.probejs.lang.typescript.code.type.BaseType;

public class TSParamType
extends BaseType {
    public BaseType baseType;
    public List<BaseType> params;

    public TSParamType(BaseType baseType, List<BaseType> params) {
        this.baseType = baseType;
        this.params = new ArrayList<BaseType>(params);
    }

    @Override
    public Collection<ImportInfo> getUsedImports() {
        HashSet<ImportInfo> paths = new HashSet<ImportInfo>(this.baseType.getUsedImports());
        for (BaseType param : this.params) {
            paths.addAll(param.getUsedImports());
        }
        return paths;
    }

    @Override
    public List<String> format(Declaration declaration, BaseType.FormatType input) {
        return List.of("%s<%s>".formatted(this.baseType.line(declaration, input), this.params.stream().map(type -> "(%s)".formatted(type.line(declaration, input))).collect(Collectors.joining(", "))));
    }
}

