/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.typescript.code.ts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import moe.wolfgirl.probejs.lang.typescript.Declaration;
import moe.wolfgirl.probejs.lang.typescript.code.Code;
import moe.wolfgirl.probejs.lang.typescript.code.ImportInfo;
import moe.wolfgirl.probejs.lang.typescript.code.member.CommentableCode;

public abstract class Wrapped
extends CommentableCode {
    public final List<Code> codes = new ArrayList<Code>();

    public void addCode(Code inner) {
        this.codes.add(inner);
    }

    @Override
    public Collection<ImportInfo> getUsedImports() {
        HashSet<ImportInfo> innerPaths = new HashSet<ImportInfo>();
        for (Code code : this.codes) {
            innerPaths.addAll(code.getUsedImports());
        }
        return innerPaths;
    }

    @Override
    public List<String> formatRaw(Declaration declaration) {
        ArrayList<String> lines = new ArrayList<String>();
        for (Code code : this.codes) {
            lines.addAll(code.format(declaration));
        }
        return lines;
    }

    public boolean isEmpty() {
        return this.codes.isEmpty();
    }

    public void merge(Wrapped other) {
        this.codes.addAll(other.codes);
    }

    public static class Namespace
    extends Wrapped {
        public final String nameSpace;

        public Namespace(String nameSpace) {
            this.nameSpace = nameSpace;
        }

        @Override
        public List<String> formatRaw(Declaration declaration) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("export namespace %s {".formatted(this.nameSpace));
            lines.addAll(super.formatRaw(declaration));
            lines.add("}");
            return lines;
        }
    }

    public static class Global
    extends Wrapped {
        @Override
        public List<String> formatRaw(Declaration declaration) {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("declare global {");
            lines.addAll(super.formatRaw(declaration));
            lines.add("}");
            return lines;
        }
    }
}

