/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.typescript.code.member;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import moe.wolfgirl.probejs.lang.typescript.Declaration;
import moe.wolfgirl.probejs.lang.typescript.code.Code;
import moe.wolfgirl.probejs.lang.typescript.code.member.ClassDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.FieldDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.MethodDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.ParamDecl;
import moe.wolfgirl.probejs.lang.typescript.code.ts.VariableDeclaration;
import moe.wolfgirl.probejs.lang.typescript.code.ts.Wrapped;
import moe.wolfgirl.probejs.lang.typescript.code.type.BaseType;
import moe.wolfgirl.probejs.lang.typescript.code.type.TSVariableType;
import moe.wolfgirl.probejs.lang.typescript.code.type.Types;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class InterfaceDecl
extends ClassDecl {
    public InterfaceDecl(String name, @Nullable BaseType superClass, List<BaseType> interfaces, List<TSVariableType> variableTypes) {
        super(name, superClass, interfaces, variableTypes);
    }

    @Override
    public boolean isInterface() {
        return true;
    }

    @Override
    public List<String> formatRaw(Declaration declaration) {
        for (MethodDecl method2 : this.methods) {
            method2.isInterface = true;
        }
        String head = "export interface %s".formatted(this.name);
        if (!this.variableTypes.isEmpty()) {
            String variables = this.variableTypes.stream().map(type -> type.line(declaration, BaseType.FormatType.VARIABLE)).collect(Collectors.joining(", "));
            head = "%s<%s>".formatted(head, variables);
        }
        if (!this.interfaces.isEmpty()) {
            String formatted = this.interfaces.stream().map(type -> type.line(declaration)).collect(Collectors.joining(", "));
            head = "%s extends %s".formatted(head, formatted);
        }
        head = "%s {".formatted(head);
        ArrayList<String> body = new ArrayList<String>();
        Wrapped.Namespace namespace = new Wrapped.Namespace(this.name);
        for (FieldDecl field : this.fields) {
            namespace.addCode(new VariableDeclaration(field.name, field.type));
        }
        body.add("");
        for (MethodDecl method3 : this.methods) {
            if (!method3.isStatic) {
                body.addAll(method3.format(declaration));
                continue;
            }
            namespace.addCode(method3.asDeclaration());
        }
        namespace.addCode(new VariableDeclaration("probejs$$marker", Types.NEVER));
        MutableInt count = new MutableInt(0);
        MethodDecl hybrid = this.methods.stream().filter(method -> !method.isStatic).filter(method -> method.isAbstract).peek(c -> count.add(1)).reduce((a, b) -> b).orElse(null);
        if (count.getValue() == 1 && hybrid != null) {
            body.add("");
            String hybridBody = ParamDecl.formatParams(hybrid.params, declaration, BaseType.FormatType.RETURN);
            String returnType = hybrid.returnType.line(declaration, BaseType.FormatType.INPUT);
            body.add("%s: %s".formatted(hybridBody, returnType));
        }
        ArrayList<String> tail = new ArrayList<String>();
        for (Code code : this.bodyCode) {
            tail.addAll(code.format(declaration));
        }
        tail.add("}\n");
        ArrayList<String> formatted = new ArrayList<String>();
        formatted.add(head);
        formatted.addAll(body);
        formatted.addAll(tail);
        formatted.addAll(namespace.format(declaration));
        formatted.addAll(this.createStaticClass(this.name, this.methods, this.fields).format(declaration));
        return formatted;
    }

    public ClassDecl createStaticClass(String name, List<MethodDecl> methodDecls, List<FieldDecl> fieldDecls) {
        ClassDecl classDecl = new ClassDecl("%s$$Static".formatted(name), null, List.of(Types.primitive(name)), this.variableTypes);
        classDecl.methods.addAll(methodDecls);
        classDecl.fields.addAll(fieldDecls);
        return classDecl;
    }
}

