/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.typescript.code.member;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import moe.wolfgirl.probejs.lang.typescript.Declaration;
import moe.wolfgirl.probejs.lang.typescript.code.Code;
import moe.wolfgirl.probejs.lang.typescript.code.ImportInfo;
import moe.wolfgirl.probejs.lang.typescript.code.member.CommentableCode;
import moe.wolfgirl.probejs.lang.typescript.code.member.ConstructorDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.FieldDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.InterfaceDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.MethodDecl;
import moe.wolfgirl.probejs.lang.typescript.code.member.clazz.ConstructorBuilder;
import moe.wolfgirl.probejs.lang.typescript.code.member.clazz.MethodBuilder;
import moe.wolfgirl.probejs.lang.typescript.code.type.BaseType;
import moe.wolfgirl.probejs.lang.typescript.code.type.TSVariableType;
import moe.wolfgirl.probejs.lang.typescript.code.type.Types;
import org.jetbrains.annotations.Nullable;

public class ClassDecl
extends CommentableCode {
    public final String name;
    @Nullable
    public BaseType superClass;
    public final List<BaseType> interfaces;
    public final List<TSVariableType> variableTypes;
    public boolean isAbstract = false;
    public boolean isNative = true;
    public final List<FieldDecl> fields = new ArrayList<FieldDecl>();
    public final List<ConstructorDecl> constructors = new ArrayList<ConstructorDecl>();
    public final List<MethodDecl> methods = new ArrayList<MethodDecl>();
    public final List<Code> bodyCode = new ArrayList<Code>();

    public ClassDecl(String name, @Nullable BaseType superClass, List<BaseType> interfaces, List<TSVariableType> variableTypes) {
        this.name = name;
        this.superClass = superClass;
        this.interfaces = interfaces;
        this.variableTypes = variableTypes;
    }

    public boolean isInterface() {
        return false;
    }

    @Override
    public Collection<ImportInfo> getUsedImports() {
        HashSet<ImportInfo> paths = new HashSet<ImportInfo>();
        for (FieldDecl field : this.fields) {
            paths.addAll(field.getUsedImports());
        }
        for (ConstructorDecl constructor : this.constructors) {
            paths.addAll(constructor.getUsedImports());
        }
        for (MethodDecl method : this.methods) {
            paths.addAll(method.getUsedImports());
        }
        for (BaseType anInterface : this.interfaces) {
            paths.addAll(anInterface.getUsedImports());
        }
        for (TSVariableType variableType : this.variableTypes) {
            paths.addAll(variableType.getUsedImports());
        }
        for (Code code : this.bodyCode) {
            paths.addAll(code.getUsedImports());
        }
        if (this.superClass != null) {
            paths.addAll(this.superClass.getUsedImports());
        }
        return paths;
    }

    @Override
    public List<String> formatRaw(Declaration declaration) {
        ArrayList<String> modifiers = new ArrayList<String>();
        modifiers.add("export");
        if (this.isAbstract) {
            modifiers.add("abstract");
        }
        modifiers.add("class");
        String head = "%s %s".formatted(String.join((CharSequence)" ", modifiers), this.name);
        if (!this.variableTypes.isEmpty()) {
            String variables = this.variableTypes.stream().map(type -> type.line(declaration, BaseType.FormatType.VARIABLE)).collect(Collectors.joining(", "));
            head = "%s<%s>".formatted(head, variables);
        }
        if (this.superClass != null) {
            head = "%s extends %s".formatted(head, this.superClass.line(declaration));
        }
        if (!this.interfaces.isEmpty()) {
            String formatted = this.interfaces.stream().map(type -> type.line(declaration)).collect(Collectors.joining(", "));
            head = "%s implements %s".formatted(head, formatted);
        }
        head = "%s {".formatted(head);
        ArrayList<String> body = new ArrayList<String>();
        for (FieldDecl fieldDecl : this.fields) {
            body.addAll(fieldDecl.format(declaration));
        }
        body.add("");
        for (ConstructorDecl constructorDecl : this.constructors) {
            body.addAll(constructorDecl.format(declaration));
        }
        body.add("");
        for (MethodDecl methodDecl : this.methods) {
            body.addAll(methodDecl.format(declaration));
        }
        ArrayList<String> tail = new ArrayList<String>();
        for (Code code : this.bodyCode) {
            tail.addAll(code.format(declaration));
        }
        tail.add("}");
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(head);
        arrayList.addAll(body);
        arrayList.addAll(tail);
        return arrayList;
    }

    public static class Builder {
        public final String name;
        @Nullable
        public BaseType superClass = null;
        public final List<BaseType> interfaces = new ArrayList<BaseType>();
        public final List<TSVariableType> variableTypes = new ArrayList<TSVariableType>();
        public boolean isAbstract = false;
        public boolean isInterface = false;
        public final List<FieldDecl> fields = new ArrayList<FieldDecl>();
        public final List<ConstructorDecl> constructors = new ArrayList<ConstructorDecl>();
        public final List<MethodDecl> methods = new ArrayList<MethodDecl>();

        public Builder(String name) {
            this.name = name;
        }

        public Builder abstractClass() {
            this.isAbstract = true;
            return this;
        }

        public Builder interfaceClass() {
            this.isInterface = true;
            return this;
        }

        public Builder field(String symbol, BaseType baseType) {
            return this.field(symbol, baseType, false);
        }

        public Builder field(String symbol, BaseType baseType, boolean isStatic) {
            return this.field(symbol, baseType, isStatic, false);
        }

        public Builder field(String symbol, BaseType baseType, boolean isStatic, boolean isFinal) {
            FieldDecl field = new FieldDecl(symbol, baseType);
            field.isStatic = isStatic;
            field.isFinal = isFinal;
            this.fields.add(field);
            return this;
        }

        public Builder superClass(BaseType superClass) {
            this.superClass = superClass;
            return this;
        }

        public Builder interfaces(BaseType ... interfaces) {
            this.interfaces.addAll(Arrays.asList(interfaces));
            return this;
        }

        public Builder typeVariables(String ... symbols) {
            for (String symbol : symbols) {
                this.typeVariables(Types.generic(symbol));
            }
            return this;
        }

        public Builder typeVariables(TSVariableType ... variableTypes) {
            this.variableTypes.addAll(Arrays.asList(variableTypes));
            return this;
        }

        public Builder method(String name, Consumer<MethodBuilder> method) {
            MethodBuilder builder = new MethodBuilder(name);
            method.accept(builder);
            this.methods.add(builder.buildAsMethod());
            return this;
        }

        public Builder ctor(Consumer<ConstructorBuilder> constructor) {
            ConstructorBuilder builder = new ConstructorBuilder();
            constructor.accept(builder);
            this.constructors.add(builder.buildAsConstructor());
            return this;
        }

        public ClassDecl build() {
            ClassDecl decl = this.isInterface ? new InterfaceDecl(this.name, this.superClass, this.interfaces, this.variableTypes) : new ClassDecl(this.name, this.superClass, this.interfaces, this.variableTypes);
            decl.isAbstract = this.isAbstract;
            decl.methods.addAll(this.methods);
            decl.fields.addAll(this.fields);
            decl.constructors.addAll(this.constructors);
            decl.isNative = false;
            decl.addComment("This is a class generated by ProbeJS, you shall not load/require this class for your usages\nbecause it doesn't exist in the JVM. The class exist only for type hinting purpose.\nLoading the class will not throw an error, but instead the class loaded will be undefined.\n");
            return decl;
        }
    }
}

