/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.typescript;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import moe.wolfgirl.probejs.ProbeJS;
import moe.wolfgirl.probejs.lang.java.clazz.ClassPath;
import moe.wolfgirl.probejs.lang.typescript.Declaration;
import moe.wolfgirl.probejs.lang.typescript.Reference;
import moe.wolfgirl.probejs.lang.typescript.code.Code;
import moe.wolfgirl.probejs.lang.typescript.code.ImportInfo;

public class TypeScriptFile {
    public final Declaration declaration = new Declaration();
    public final List<Code> codeList = new ArrayList<Code>();
    public final ClassPath classPath;

    public TypeScriptFile(ClassPath self) {
        if (self != null) {
            this.declaration.addClass(ImportInfo.original(self));
        }
        this.classPath = self;
    }

    public void excludeSymbol(String name) {
        this.declaration.exclude(name);
    }

    public void addCode(Code code) {
        this.codeList.add(code);
        for (ImportInfo usedClassPath : code.getUsedImports()) {
            this.declaration.addClass(usedClassPath);
        }
    }

    public void refreshImports() {
        for (Code code : this.codeList) {
            for (ImportInfo usedImport : code.getUsedImports()) {
                this.declaration.addClass(usedImport);
            }
        }
    }

    public String format() {
        ArrayList<String> formatted = new ArrayList<String>();
        for (Code code : this.codeList) {
            formatted.addAll(code.format(this.declaration));
        }
        return String.join((CharSequence)"\n", formatted);
    }

    public void write(Path writeTo) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(writeTo, new OpenOption[0]);){
            this.write(writer);
        }
    }

    public void write(BufferedWriter writer) throws IOException {
        boolean written = false;
        for (Reference value : this.declaration.references.values()) {
            if (value.classPath().equals(this.classPath)) continue;
            writer.write(value.getImport() + "\n");
            written = true;
        }
        if (!written) {
            writer.write("export {} // Mark the file as a module, do not remove unless there are other import/exports!");
        }
        writer.write("\n");
        writer.write(this.format());
    }

    public void writeAsModule(BufferedWriter writer) throws IOException {
        String modulePath = this.classPath.getTypeScriptPath();
        writer.write("declare module %s {\n".formatted(ProbeJS.GSON.toJson((Object)modulePath)));
        this.write(writer);
        writer.write("}\n");
    }

    public <T extends Code> Optional<T> findCode(Class<T> type) {
        for (Code code : this.codeList) {
            if (!type.isInstance(code)) continue;
            return Optional.of(code);
        }
        return Optional.empty();
    }
}

