/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.typescript;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import moe.wolfgirl.probejs.lang.java.clazz.ClassPath;
import moe.wolfgirl.probejs.lang.typescript.Reference;
import moe.wolfgirl.probejs.lang.typescript.code.ImportInfo;

public class Declaration {
    private static final String SYMBOL_TEMPLATE = "%s$%d";
    public final Map<ClassPath, Reference> references = new HashMap<ClassPath, Reference>();
    private final Map<ClassPath, String> symbols = new HashMap<ClassPath, String>();
    private final Set<String> excludedName = new HashSet<String>();

    public void addClass(ImportInfo path) {
        this.references.computeIfAbsent(path.classPath(), classPath -> {
            String name = this.getSymbolName((ClassPath)classPath);
            return new Reference((ClassPath)classPath, name, EnumSet.noneOf(ImportInfo.Type.class));
        }).types().add(path.type());
    }

    public void exclude(String name) {
        this.excludedName.add(name);
    }

    private void putSymbolName(ClassPath path, String name) {
        this.symbols.put(path, name);
    }

    private boolean containsSymbol(String name) {
        return this.excludedName.contains(name) || this.symbols.containsValue(name);
    }

    private String getSymbolName(ClassPath path) {
        if (!this.symbols.containsKey(path)) {
            String name = path.getName();
            if (!this.containsSymbol(name)) {
                this.putSymbolName(path, name);
            } else {
                int counter = 0;
                while (this.containsSymbol(SYMBOL_TEMPLATE.formatted(name, counter))) {
                    ++counter;
                }
                this.putSymbolName(path, SYMBOL_TEMPLATE.formatted(name, counter));
            }
        }
        return this.symbols.get(path);
    }

    public String getSymbol(ClassPath path) {
        if (!this.references.containsKey(path)) {
            throw new RuntimeException("Trying to get a symbol of a classpath that is not resolved yet!");
        }
        Reference reference = this.references.get(path);
        return reference.symbol();
    }
}

