/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.schema;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import moe.wolfgirl.probejs.lang.schema.AnyElement;
import moe.wolfgirl.probejs.lang.schema.PrimitiveElement;
import moe.wolfgirl.probejs.lang.schema.SchemaElement;
import moe.wolfgirl.probejs.utils.JsonUtils;

public class ObjectElement
extends SchemaElement<ObjectElement> {
    private final Map<String, SchemaElement<?>> members = new HashMap();
    private final List<String> requires = new ArrayList<String>();

    public ObjectElement primitive(String name, String type, Function<PrimitiveElement, SchemaElement<?>> function) {
        this.members.put(name, function.apply(new PrimitiveElement(type)));
        return this;
    }

    public ObjectElement stringType(String name) {
        return this.stringType(name, o -> o);
    }

    public ObjectElement stringType(String name, Function<PrimitiveElement, SchemaElement<?>> function) {
        return this.primitive(name, "string", function);
    }

    public ObjectElement numberType(String name) {
        return this.numberType(name, o -> o);
    }

    public ObjectElement numberType(String name, Function<PrimitiveElement, SchemaElement<?>> function) {
        return this.primitive(name, "number", function);
    }

    public ObjectElement booleanType(String name) {
        return this.booleanType(name, o -> o);
    }

    public ObjectElement booleanType(String name, Function<PrimitiveElement, SchemaElement<?>> function) {
        return this.primitive(name, "boolean", function);
    }

    public ObjectElement anyType(String name) {
        this.members.put(name, AnyElement.INSTANCE);
        return this;
    }

    public ObjectElement object(String name) {
        return this.object(name, o -> o);
    }

    public ObjectElement object(String name, Function<ObjectElement, SchemaElement<?>> function) {
        this.members.put(name, function.apply(new ObjectElement()));
        return this;
    }

    public ObjectElement requires(String ... requires) {
        this.requires.addAll(List.of(requires));
        return this;
    }

    @Override
    public String getType() {
        return "object";
    }

    @Override
    protected JsonObject toSchema() {
        JsonObject object = new JsonObject();
        JsonObject properties = new JsonObject();
        for (Map.Entry<String, SchemaElement<?>> entry : this.members.entrySet()) {
            String key = entry.getKey();
            SchemaElement<?> value = entry.getValue();
            properties.add(key, (JsonElement)value.getSchema());
        }
        object.add("properties", (JsonElement)properties);
        object.add("requires", JsonUtils.parseObject(this.requires));
        return object;
    }

    public static ObjectElement of() {
        return new ObjectElement();
    }
}

