/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.linter.rules;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import moe.wolfgirl.probejs.ProbeConfig;
import moe.wolfgirl.probejs.lang.linter.LintingWarning;
import moe.wolfgirl.probejs.lang.linter.rules.Rule;

public class NoNamespacePollution
extends Rule {
    final Multimap<String, Pair<Integer, Path>> identifiers = ArrayListMultimap.create();

    @Override
    public void acceptFile(Path path, List<String> content) {
        if (ProbeConfig.INSTANCE.isolatedScopes.get().booleanValue()) {
            for (int i = 0; i < content.size(); ++i) {
                String identifier;
                String s = content.get(i).trim();
                if (!s.startsWith("export")) continue;
                s = s.substring(6).trim();
                String[] parts = s.split(" ", 2);
                switch (parts[0]) {
                    case "function": {
                        String string = parts[1].split("\\(", 2)[0];
                        break;
                    }
                    case "var": 
                    case "let": 
                    case "const": {
                        String string = parts[1].split(" ")[0];
                        break;
                    }
                    default: {
                        String string = identifier = null;
                    }
                }
                if (identifier == null || identifier.equals("{") && s.contains("}")) continue;
                this.identifiers.put((Object)identifier, (Object)Pair.of((Object)i, (Object)path));
            }
        } else {
            for (int i = 0; i < content.size(); ++i) {
                String identifier;
                String s = content.get(i).trim();
                if (!s.startsWith("var") && !s.startsWith("let") && !s.startsWith("const") && !s.startsWith("function")) continue;
                String[] parts = s.split(" ", 2);
                switch (parts[0]) {
                    case "function": {
                        String string = parts[1].split("\\(", 2)[0];
                        break;
                    }
                    case "var": 
                    case "let": 
                    case "const": {
                        String string = parts[1].split(" ")[0];
                        break;
                    }
                    default: {
                        String string = identifier = null;
                    }
                }
                if (identifier == null || identifier.equals("{") && s.contains("}")) continue;
                this.identifiers.put((Object)identifier, (Object)Pair.of((Object)i, (Object)path));
            }
        }
    }

    @Override
    public List<LintingWarning> lint(Path basePath) {
        ArrayList<LintingWarning> warnings = new ArrayList<LintingWarning>();
        for (Map.Entry entry : this.identifiers.asMap().entrySet()) {
            String identifier = (String)entry.getKey();
            Collection paths = (Collection)entry.getValue();
            if (paths.size() <= 1) continue;
            for (Pair path : paths) {
                warnings.add(new LintingWarning((Path)path.getSecond(), LintingWarning.Level.ERROR, (Integer)path.getFirst(), 0, "Duplicate declaration of %s".formatted(identifier)));
            }
        }
        return warnings;
    }
}

