/*
 * Decompiled with CFR 0.152.
 */
package moe.wolfgirl.probejs.lang.java.clazz;

import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.JavaMembers;
import dev.latvian.mods.rhino.Scriptable;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import moe.wolfgirl.probejs.lang.java.base.TypeVariableHolder;
import moe.wolfgirl.probejs.lang.java.clazz.ClassPath;
import moe.wolfgirl.probejs.lang.java.clazz.members.ConstructorInfo;
import moe.wolfgirl.probejs.lang.java.clazz.members.FieldInfo;
import moe.wolfgirl.probejs.lang.java.clazz.members.MethodInfo;
import moe.wolfgirl.probejs.lang.java.type.TypeAdapter;
import moe.wolfgirl.probejs.lang.java.type.TypeDescriptor;
import org.jetbrains.annotations.Nullable;

public class Clazz
extends TypeVariableHolder {
    @HideFromJS
    public final Class<?> original;
    public final ClassPath classPath;
    public final List<ConstructorInfo> constructors;
    public final List<FieldInfo> fields;
    public final List<MethodInfo> methods;
    @Nullable
    public final TypeDescriptor superClass;
    public final List<TypeDescriptor> interfaces;
    public final ClassAttribute attribute;
    public int recursionDepth;

    public Clazz(Class<?> clazz) {
        super(clazz.getTypeParameters(), clazz.getAnnotations());
        ScriptManager manager = KubeJS.getStartupScriptManager();
        KubeJSContext context = (KubeJSContext)manager.contextFactory.enter();
        JavaMembers members = JavaMembers.lookupClass((Context)context, (Scriptable)context.topLevelScope, clazz, clazz, (boolean)false);
        this.original = clazz;
        this.classPath = new ClassPath(clazz);
        this.constructors = members.getAccessibleConstructors().stream().map(ConstructorInfo::new).collect(Collectors.toList());
        HashSet names = new HashSet();
        this.methods = members.getAccessibleMethods((Context)context, false).stream().peek(m -> names.add(m.name)).filter(m -> !Clazz.hasIdenticalParentMethodAndEnsureNotDirectlyImplementsInterfaceSinceTypeScriptDoesNotHaveInterfaceAtRuntimeInTypeDeclarationFilesJustBecauseItSucks(m.method, clazz)).map(method -> {
            Map<TypeVariable<?>, Type> replacement = Clazz.getGenericTypeReplacementForParentInterfaceMethodsJustBecauseJavaDoNotKnowToReplaceThemWithGenericArgumentsOfThisClass(clazz, method.method);
            return new MethodInfo((JavaMembers.MethodInfo)method, replacement);
        }).collect(Collectors.toList());
        this.fields = members.getAccessibleFields((Context)context, false).stream().filter(f -> !names.contains(f.name)).map(FieldInfo::new).collect(Collectors.toList());
        this.superClass = clazz.getSuperclass() != Object.class ? TypeAdapter.getTypeDescription(clazz.getAnnotatedSuperclass()) : null;
        this.interfaces = Arrays.stream(clazz.getAnnotatedInterfaces()).map(TypeAdapter::getTypeDescription).collect(Collectors.toList());
        this.attribute = new ClassAttribute(clazz);
        this.recursionDepth = 0;
    }

    public int hashCode() {
        return this.classPath.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Clazz clazz = (Clazz)o;
        return Objects.equals(this.classPath, clazz.classPath);
    }

    private static boolean hasIdenticalParentMethodAndEnsureNotDirectlyImplementsInterfaceSinceTypeScriptDoesNotHaveInterfaceAtRuntimeInTypeDeclarationFilesJustBecauseItSucks(Method method, Class<?> clazz) {
        Class<?> parent = clazz.getSuperclass();
        if (parent == null) {
            return false;
        }
        while (parent != null && !parent.isInterface()) {
            try {
                Method parentMethod = parent.getMethod(method.getName(), method.getParameterTypes());
                return parentMethod.equals(method);
            }
            catch (NoSuchMethodException e) {
                parent = parent.getSuperclass();
            }
        }
        return false;
    }

    private static Map<TypeVariable<?>, Type> getGenericTypeReplacementForParentInterfaceMethodsJustBecauseJavaDoNotKnowToReplaceThemWithGenericArgumentsOfThisClass(Class<?> thisClass, Method thatMethod) {
        Class<?> targetClass = thatMethod.getDeclaringClass();
        HashMap replacement = new HashMap();
        if (Arrays.stream(thisClass.getInterfaces()).noneMatch(c -> c.equals(targetClass))) {
            Class superInterface = Arrays.stream(thisClass.getInterfaces()).filter(targetClass::isAssignableFrom).findFirst().orElse(null);
            if (superInterface == null) {
                return Map.of();
            }
            Map<TypeVariable<?>, Type> parentType = Clazz.getGenericTypeReplacementForParentInterfaceMethodsJustBecauseJavaDoNotKnowToReplaceThemWithGenericArgumentsOfThisClass(superInterface, thatMethod);
            Map<TypeVariable<?>, Type> parentReplacement = Clazz.getInterfaceRemap(thisClass, superInterface);
            for (Map.Entry<TypeVariable<?>, Type> entry : parentType.entrySet()) {
                Type type;
                TypeVariable<?> variable = entry.getKey();
                Type type2 = entry.getValue();
                if (type2 instanceof TypeVariable) {
                    TypeVariable typeVariable = (TypeVariable)type2;
                    type = parentReplacement.getOrDefault(typeVariable, typeVariable);
                } else {
                    type = type2;
                }
                replacement.put(variable, type);
            }
        } else {
            return Clazz.getInterfaceRemap(thisClass, targetClass);
        }
        return replacement;
    }

    private static Map<TypeVariable<?>, Type> getInterfaceRemap(Class<?> thisClass, Class<?> thatInterface) {
        HashMap replacement = new HashMap();
        int indexOfInterface = -1;
        for (Type type : thisClass.getGenericInterfaces()) {
            Class clazz;
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                if (!parameterizedType.getRawType().equals(thatInterface)) continue;
                indexOfInterface = 0;
                for (TypeVariable<Class<?>> typeVariable : thatInterface.getTypeParameters()) {
                    replacement.put(typeVariable, parameterizedType.getActualTypeArguments()[indexOfInterface]);
                    ++indexOfInterface;
                }
                continue;
            }
            if (!(type instanceof Class) || !(clazz = (Class)type).equals(thatInterface)) continue;
            indexOfInterface = 0;
            for (TypeVariable<Class<?>> typeVariable : thatInterface.getTypeParameters()) {
                replacement.put(typeVariable, (Type)((Object)Object.class));
            }
        }
        if (indexOfInterface == -1) {
            return Map.of();
        }
        return replacement;
    }

    public static class ClassAttribute {
        public final ClassType type;
        public final boolean isAbstract;
        public final boolean isInterface;
        public final Class<?> raw;

        public ClassAttribute(Class<?> clazz) {
            this.type = clazz.isInterface() ? ClassType.INTERFACE : (clazz.isEnum() ? ClassType.ENUM : (clazz.isRecord() ? ClassType.RECORD : ClassType.CLASS));
            int modifiers = clazz.getModifiers();
            this.isAbstract = Modifier.isAbstract(modifiers);
            this.isInterface = this.type == ClassType.INTERFACE;
            this.raw = clazz;
        }
    }

    public static enum ClassType {
        INTERFACE,
        ENUM,
        RECORD,
        CLASS;

    }
}

